/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.propagation;

import com.tssap.dtr.client.lib.deltavlib.xcm.EIntegrateOption;
import com.tssap.dtr.client.lib.propagation.DtrConnection;
import com.tssap.dtr.client.lib.propagation.Importable;
import com.tssap.dtr.client.lib.propagation.Propagatable;
import com.tssap.dtr.client.lib.propagation.PropagationUtil;
import com.tssap.dtr.client.lib.propagation.Requestor;
import com.tssap.dtr.client.lib.propagation.Workspace;
import com.tssap.dtr.client.lib.propagation.clientapi.IExportable;
import com.tssap.dtr.client.lib.propagation.clientapi.IIntegration;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatable;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatableBlob;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatableBlobSegment;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagationCollision;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagationSource;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagationTarget;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagator;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.entities.ErrorEntity;
import com.tssap.dtr.client.lib.protocol.requests.dav.ProppatchRequest;
import com.tssap.dtr.client.lib.protocol.requests.xcm.MkPropagationRequest;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;

public class PropagationManager
extends Requestor
implements IPropagator {
    public static final String READ_TIMEOUT = "readTimeout";
    public static final String CONNECTION_TIMEOUT = "connectTimeout";
    public static final String EXPIRE_TIMEOUT = "expireTimeout";
    public static final String REPEAT_ONTIMEOUT = "repeatOnTimeout";
    public static final String REPEAT_COUNT = "repeat";
    public static final String COMPRESS = "compress";
    public static final String COMPRESS_REPSPONSES = "compressResponses";
    public static final String COMPRESS_REQUESTS = "compressRequests";
    public static final String DEFAULT_READ_TIMEOUT = "0";
    public static final String DEFAULT_CONNECTION_TIMEOUT = "300000";
    public static final String DEFAULT_EXPIRE_TIMEOUT = "10000";
    public static final String DEFAULT_REPEAT_ONTIMEOUT = "false";
    public static final String DEFAULT_REPEAT_COUNT = "1";
    public static final String DEFAULT_COMPRESS = "false";
    public static final String DEFAULT_COMPRESS_RESPONSES = "on,gzip";
    public static final String DEFAULT_COMPRESS_REQUESTS = "on,gzip";
    private static final String PROP = "prop/";
    private static final String ISO_8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    static final DateFormat isoDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
    private static final String CLIENT_MAX_REQUEST_CONTENT_LENGTH = "prop.max_request_content_length";
    private static final int CLIENT_MIN_REQUEST_CONTENT_LENGTH = 0x500000;
    private static final Properties defaultConnectionProperties = new Properties();

    public PropagationManager(IConnectionTemplate connectionTemplate) {
        this.setDtrConnection(new DtrConnection(connectionTemplate));
    }

    public PropagationManager(String serverUrl, String user, String password) throws MalformedURLException {
        this.setDtrConnection(new DtrConnection(serverUrl, user, password, defaultConnectionProperties));
    }

    public PropagationManager(String serverUrl, String user, String password, Properties connectionProperties) throws MalformedURLException {
        this.setDtrConnection(new DtrConnection(serverUrl, user, password, connectionProperties));
    }

    private MkPropagationRequest createMkPropagationRequest(String name, String workspace) {
        MkPropagationRequest request = new MkPropagationRequest(PROP + name);
        request.setWorkspace(workspace);
        return request;
    }

    private String getGuid(String url) throws PropagationException {
        return this.getProperty(url, "oid", "Could not determine OID of PropagationList " + this.quote(url));
    }

    public IPropagatable createPropagatable(String name, IPropagationSource source, int fromVersionSetIntegration, int toVersionSetIntegration) throws PropagationException {
        MkPropagationRequest request = this.createMkPropagationRequest(name, source.getPath());
        request.selectIntegrationSequenceRange(fromVersionSetIntegration, toVersionSetIntegration);
        return this.executeMkPropagationRequest(source, request);
    }

    private IPropagatable executeMkPropagationRequest(IPropagationSource source, MkPropagationRequest request) throws PropagationException, PropagationPreconditionException {
        String errorBase = "Creation of Propagatable failed";
        IResponse response = this.performRequest((IRequest)request, errorBase);
        if (response.getStatus() == 201 || response.getStatus() == 207) {
            this.closePropagationList(request.getPath());
            return new Propagatable(this, this.getDtrConnection(), this.getGuid(request.getPath()));
        }
        IResponseEntity responseEntity = response.getEntity();
        if (response.isContentXML() || responseEntity instanceof ErrorEntity) {
            throw PropagationUtil.getNewPreconditionException((ErrorEntity)responseEntity, response.getStatusDescription());
        }
        if (response.getStatus() == 404) {
            throw new PropagationPreconditionException(source.getPath(), response.getStatusDescription());
        }
        throw new PropagationException(this.getCombinedErrorMessage(errorBase, response));
    }

    public IPropagatable createPropagatable(String name, IPropagationSource source, int fromVersionSetIntegration) throws PropagationException {
        MkPropagationRequest request = this.createMkPropagationRequest(name, source.getPath());
        request.selectIntegrationSequenceRange(fromVersionSetIntegration);
        return this.executeMkPropagationRequest(source, request);
    }

    public IPropagatable createPropagatable(String name, IPropagationSource source, Date from, Date to) throws PropagationException {
        MkPropagationRequest request = this.createMkPropagationRequest(name, source.getPath());
        request.selectIntegrationDate(from == null ? null : isoDateFormatter.format(from), to == null ? null : isoDateFormatter.format(to));
        return this.executeMkPropagationRequest(source, request);
    }

    public IPropagatable createPropagatable(String name, IPropagationSource source, Date from) throws PropagationException {
        return this.createPropagatable(name, source, from, null);
    }

    public IPropagatable createPropagatable(String name, IPropagationSource source) throws PropagationException {
        return this.createPropagatable(name, source, null);
    }

    private void closePropagationList(String url) throws PropagationException {
        String errorBase = "Could not close PropagationList " + this.quote(url);
        ProppatchRequest request = new ProppatchRequest(url);
        request.addPropertySet("XCM:version-set-state", "closed", Requestor.XCM_NAMESPACE);
        IResponse response = this.performRequest((IRequest)request, errorBase);
        int status = response.getStatus();
        if (status != 200) {
            throw new PropagationException(this.getCombinedErrorMessage(errorBase, response));
        }
    }

    public IPropagationCollision[] getCollisions(String[] propagatables, String target) {
        throw new UnsupportedOperationException("Method getCollisions() not yet implemented.");
    }

    public long getCollisionCount(String[] propagatables, String target) {
        throw new UnsupportedOperationException("Method getCollisionCount() not yet implemented.");
    }

    public IPropagatable import_(InputStream contents, byte options, long length) throws PropagationException {
        Importable importable = new Importable(this, this.getDtrConnection(), this.getMaxSegmentSize(), this.supportsSegmentedPropagation());
        return importable.import_(contents, options, length);
    }

    public IPropagatable import_(InputStream contents, byte options) throws PropagationException {
        Importable importable = new Importable(this, this.getDtrConnection());
        return importable.import_(contents, options);
    }

    public IIntegration integrate(IPropagatable propagatable, IPropagationTarget targetWorkspace, EIntegrateOption option) throws PropagationException {
        return propagatable.integrate(targetWorkspace, option);
    }

    public IIntegration integrate(String propagatableId, IPropagationTarget targetWorkspace, EIntegrateOption option) throws PropagationException {
        IPropagatable propagatable = this.getPropagatable(propagatableId);
        return propagatable.integrate(targetWorkspace, option);
    }

    public IIntegration integrate(String propagatbleURL, String targetWorkspace, EIntegrateOption option) throws PropagationException {
        IPropagatable propagatable = this._getPropagatable(propagatbleURL);
        return propagatable.integrate(new Workspace(targetWorkspace), option);
    }

    public IExportable export(String propagatableId, int mode) throws PropagationException {
        IPropagatable propagatable = this.getPropagatable(propagatableId);
        return propagatable.export(mode);
    }

    public IExportable export(String propagatableId) throws PropagationException {
        IPropagatable propagatable = this.getPropagatable(propagatableId);
        return propagatable.export();
    }

    public IPropagatable getPropagatable(String guid) {
        Propagatable propagatable = new Propagatable(this, this.getDtrConnection(), guid);
        return propagatable;
    }

    public IPropagatable _getPropagatable(String url) throws PropagationException {
        Propagatable propagatable = new Propagatable(this, this.getDtrConnection(), this.getGuid(url));
        return propagatable;
    }

    public String getModelId() {
        throw new UnsupportedOperationException("Method getModelId() not yet implemented.");
    }

    public IExportable exportForRelocation(String propagatableId, String targetRepositoryID, int mode) throws PropagationException {
        IPropagatable propagatable = this.getPropagatable(propagatableId);
        return propagatable.exportForRelocation(targetRepositoryID, mode);
    }

    public IPropagatable import_(InputStream contents, byte options, String targetLocation) throws PropagationException {
        Importable importable = new Importable(this, this.getDtrConnection());
        return importable.import_(contents, options, targetLocation);
    }

    public IPropagatable import_(InputStream contents, byte options, long length, String targetLocation) throws PropagationException {
        Importable importable = new Importable(this, this.getDtrConnection(), this.getMaxSegmentSize(), this.supportsSegmentedPropagation());
        return importable.import_(contents, options, length, targetLocation);
    }

    public String getRepositoryID() throws PropagationException {
        return this.getProperty("", "repositoryid");
    }

    public String getOwnerRepositoryID(String url) throws PropagationException {
        return this.getProperty(url, "workspace-owner-repositoryid");
    }

    public boolean supportsSegmentedPropagation() throws PropagationException {
        boolean supports = false;
        try {
            supports = this.getBooleanProperty("", "supports-segmented-propagation");
        }
        catch (PropagationPreconditionException propagationPreconditionException) {
            // empty catch block
        }
        return supports;
    }

    public int getMaxSegmentSize() throws PropagationException {
        int maxSegmentSize = Integer.parseInt(System.getProperty(CLIENT_MAX_REQUEST_CONTENT_LENGTH, DEFAULT_READ_TIMEOUT));
        int maxRequestContentLength = this.getMaxRequestContentLength();
        if (maxSegmentSize > 0) {
            if (maxSegmentSize < 0x500000) {
                maxSegmentSize = 0x500000;
            }
            maxRequestContentLength = Math.min(maxRequestContentLength, maxSegmentSize);
        }
        return maxRequestContentLength;
    }

    public int getMaxRequestContentLength() throws PropagationException {
        int maxRequestLength = 0;
        try {
            maxRequestLength = Integer.parseInt(this.getProperty("", "max-request-content-length"));
        }
        catch (PropagationPreconditionException propagationPreconditionException) {
            // empty catch block
        }
        return maxRequestLength;
    }

    public String[] getPredecessors(String sourceWSPath, String targetWSPath, String[] absoluteRemotePaths, int level, boolean forPropagation) throws PropagationException {
        return this.getPredecessorSet(sourceWSPath, targetWSPath, absoluteRemotePaths, level, forPropagation);
    }

    public String[] getPropagationPredecessors(String sourceWSPath, String[] absoluteRemotePaths, int level) throws PropagationException {
        return this.getPredecessorSet(sourceWSPath, null, absoluteRemotePaths, level, true);
    }

    public IPropagatableBlob getPropagatableBlob(String propagatbleBlobURL) throws PropagationException {
        return this.getPropagatableBlob(this, propagatbleBlobURL);
    }

    public IPropagatableBlobSegment getPropagatableBlobSegment(String propagatbleBlobSegmentURL) throws PropagationException {
        return this.getPropagatableBlobSegment(this, propagatbleBlobSegmentURL);
    }

    public IPropagatableBlobSegment[] getPropagatableBlobSegments(String propagatbleBlobURL) throws PropagationException {
        return this.getPropagatableBlobSegments(this, propagatbleBlobURL);
    }

    public void setSegmentBlob(String propagatbleBlobSegmentURL, InputStream contents, int contentLength) throws PropagationException {
        this.setPropagatableBlobSegment(propagatbleBlobSegmentURL, contents, contentLength);
    }

    public IPropagatableBlob getPropagatableBlobUsingID(String propagatbleBlobID) throws PropagationException {
        return this.getPropagatableBlob(this.getWorkingPropagatablePath(propagatbleBlobID));
    }

    public InputStream getPropagatableBlobSegmentContents(String propagatbleBlobURL) throws PropagationException {
        return this._getPropagatableBlobSegmentContents(propagatbleBlobURL);
    }

    static {
        isoDateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

