/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.propagation;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatableHeaderInfo;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class PropagatableHeaderInfo
implements IPropagatableHeaderInfo {
    private static final Location loc = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$propagation$PropagatableHeaderInfo == null ? (class$com$tssap$dtr$client$lib$propagation$PropagatableHeaderInfo = PropagatableHeaderInfo.class$("com.tssap.dtr.client.lib.propagation.PropagatableHeaderInfo")) : class$com$tssap$dtr$client$lib$propagation$PropagatableHeaderInfo));
    private String propagatableID;
    private String creationDate;
    private String repositoryName;
    private String repositoryID;
    private String exportMode;
    private String partitionType;
    private String formatVersion;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$propagation$PropagatableHeaderInfo;

    public PropagatableHeaderInfo(String propagatableID, String creationDate, String repositoryName, String repositoryID, String exportMode, String partitionType, String formatVersion) {
        this.fillHeaderInformation(propagatableID, creationDate, repositoryName, repositoryID, exportMode, partitionType, formatVersion);
    }

    public PropagatableHeaderInfo(InputStream headerXML) throws PropagationException {
        this.parseHeaderXML(headerXML);
    }

    private void parseHeaderXML(InputStream headerXML) throws PropagationException {
        DocumentBuilder documentBuilder = null;
        Document document = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.parse(headerXML);
        }
        catch (SAXException e) {
            throw new PropagationException(e);
        }
        catch (IOException e) {
            throw new PropagationException(e);
        }
        catch (ParserConfigurationException e) {
            throw new PropagationException(e);
        }
        this.extractHeaderInformation(document);
    }

    protected void extractHeaderInformation(Document document) {
        NodeList tag = document.getElementsByTagName("versionSet");
        this.propagatableID = tag.item(0).getAttributes().item(0).getNodeValue();
        tag = document.getElementsByTagName("format");
        this.formatVersion = tag.item(0).getAttributes().item(0).getNodeValue();
        tag = document.getElementsByTagName("export");
        this.exportMode = tag.item(0).getAttributes().item(0).getNodeValue();
        tag = document.getElementsByTagName("creation");
        this.creationDate = tag.item(0).getAttributes().item(0).getNodeValue();
        tag = document.getElementsByTagName("partitionType");
        if (tag != null) {
            Node partitionIDNode = tag.item(0);
            if (tag.item(0) != null) {
                this.partitionType = tag.item(0).getAttributes().item(0).getNodeValue();
            }
        }
        if ((tag = document.getElementsByTagName("repositoryID")) != null && tag.item(0) != null) {
            this.repositoryID = tag.item(0).getAttributes().item(0).getNodeValue();
        }
        if ((tag = document.getElementsByTagName("repositoryName")) != null && tag.item(0) != null) {
            this.repositoryName = tag.item(0).getAttributes().item(0).getNodeValue();
        }
    }

    private void fillHeaderInformation(String propagatableID, String creationDate, String repositoryName, String repositoryID, String exportMode, String partitionType, String formatVersion) {
        this.propagatableID = propagatableID;
        this.creationDate = creationDate;
        this.repositoryID = repositoryID;
        this.repositoryName = repositoryName;
        this.exportMode = exportMode;
        this.partitionType = partitionType;
        this.formatVersion = formatVersion;
    }

    public String getPropagatableID() {
        return this.propagatableID;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getExportMode() {
        return this.exportMode;
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public String getRepositoryPartitionType() {
        return this.partitionType;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositoryID() {
        return this.repositoryID;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

