/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.propagation;

import com.tssap.dtr.client.lib.deltavlib.xcm.EIntegrateOption;
import com.tssap.dtr.client.lib.propagation.DtrConnection;
import com.tssap.dtr.client.lib.propagation.ExportStream;
import com.tssap.dtr.client.lib.propagation.Integration;
import com.tssap.dtr.client.lib.propagation.PropagationUtil;
import com.tssap.dtr.client.lib.propagation.Requestor;
import com.tssap.dtr.client.lib.propagation.SegmentedExportStream;
import com.tssap.dtr.client.lib.propagation.clientapi.IExportable;
import com.tssap.dtr.client.lib.propagation.clientapi.IIntegration;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatable;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagationTarget;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagator;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.ErrorEntity;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.ProppatchRequest;
import com.tssap.dtr.client.lib.protocol.requests.xcm.ExportRequest;
import com.tssap.dtr.client.lib.protocol.requests.xcm.IntegrateRequest;

public class Propagatable
extends Requestor
implements IPropagatable {
    private String guid;
    private String requestId;
    private IPropagator propagator;
    private static final String CLIENT_PERFORM_SEGMENTED_PROPAGATION = "prop.perform_segmented_propagation";

    Propagatable(IPropagator propagator, DtrConnection connection, String guid) {
        this.setDtrConnection(connection);
        this.guid = guid;
        this.propagator = propagator;
        this.requestId = "nonvresbyid/" + guid;
    }

    public String getId() {
        return this.guid;
    }

    public IExportable export(int mode) throws PropagationException {
        if ((mode & 8) == 8) {
            throw new PropagationException("Cannot relocate devline. Use exportForRelocation()");
        }
        return this._export(new Integer(mode), null);
    }

    public IExportable export() throws PropagationException {
        return this._export(null, null);
    }

    public IIntegration integrate(IPropagationTarget target, EIntegrateOption option) throws PropagationException {
        String errorBase = "Could not integrate " + this.guid;
        if (target == null) {
            throw new PropagationException(errorBase + ": specified target is null");
        }
        errorBase = errorBase + " into " + target.getPath();
        IntegrateRequest integrateRequest = new IntegrateRequest(target.getPath(), this.requestId);
        if (option == EIntegrateOption.KEEP_WORKSPACE_VERSION) {
            integrateRequest.keepActiveVersions();
        } else if (option == EIntegrateOption.FORCE_INTEGRATE_VERSION) {
            integrateRequest.forceIntegratedVersions();
        } else {
            throw new PropagationException("unknown EIntegrationOption ");
        }
        IResponse response = this.performRequest((IRequest)integrateRequest, errorBase);
        int responseStatus = response.getStatus();
        if (response.isMultiStatus()) {
            return new Integration((MultiStatusEntity)response.getEntity());
        }
        if (responseStatus == 204) {
            return new Integration();
        }
        if (responseStatus >= 400 && responseStatus < 500) {
            throw PropagationUtil.getNewPreconditionException((ErrorEntity)response.getEntity(), response.getStatusDescription());
        }
        throw new PropagationException(this.getCombinedErrorMessage(errorBase, response));
    }

    public String getPropagationRequestId() throws PropagationException {
        return this.getProperty(this.requestId, "propagation-request-id", "Getting of PropagationRequestId failed");
    }

    public void setPropagationRequestId(String propagationRequestId) throws PropagationException {
        String errorBase = "Setting of propagation-request-id = \"" + propagationRequestId + "\" for propagatable " + this.getId() + " failed";
        if (propagationRequestId.length() > 80) {
            throw new PropagationException(errorBase + ". String too long: " + propagationRequestId.length() + " instead of max. " + 80 + " characters");
        }
        ProppatchRequest proppatchRequest = new ProppatchRequest(this.requestId);
        proppatchRequest.addPropertySet("XCM:propagation-request-id", propagationRequestId, Requestor.XCM_NAMESPACE);
        IResponse response = this.performRequest((IRequest)proppatchRequest, errorBase);
        int status = response.getStatus();
        if (status != 200) {
            PropertyElement propertyElement = this.getFirstPropertyElement("propagation-request-id", response, proppatchRequest, errorBase);
            switch (propertyElement.getStatusCode()) {
                case 403: {
                    throw new PropagationException(errorBase + ". Propagatable must be closed first.");
                }
                case 409: {
                    String currentValueMessage = "";
                    currentValueMessage = " to value \"" + this.getPropagationRequestId() + "\"";
                    throw new PropagationException(errorBase + ". " + "propagation-request-id" + " can only be set once, but was already set" + currentValueMessage);
                }
            }
            throw new PropagationException(errorBase + ". Response status = " + propertyElement.getStatusCode() + " (" + propertyElement.getStatusDescription() + ")");
        }
    }

    public IExportable exportForRelocation(String targetRepositoryID, int mode) throws PropagationException {
        if (mode != 8 && mode != 12) {
            throw new PropagationException("export mode must be 'EXPORT_MODE_RELOCATE_DEVLINE' or 'EXPORT_MODE_RELOCATE_DEVLINE_INCLUDING_SNAPSHOTS' ");
        }
        return this._export(new Integer(mode), targetRepositoryID);
    }

    private IExportable _export(Integer mode, String targetRepositoryID) throws PropagationException {
        String performSegmentedExport;
        ExportRequest request = new ExportRequest(this.requestId);
        if (mode != null) {
            request.setExportMode(mode.intValue());
        }
        if (targetRepositoryID != null) {
            request.setRelocationRepositoryID(targetRepositoryID);
        }
        request.setAllowSegmentedExport(!"false".equalsIgnoreCase(performSegmentedExport = System.getProperty(CLIENT_PERFORM_SEGMENTED_PROPAGATION, "true")));
        Connection connection = null;
        IResponse response = null;
        try {
            connection = this.getDtrConnection().openConnection();
            response = connection.send((IRequest)request, false);
        }
        catch (Exception ex) {
            throw new PropagationException("Request failed:" + ex.getMessage());
        }
        int status = response.getStatus();
        if (status != 200) {
            this.handleError(connection, request, response);
            return null;
        }
        String propagatbleBlobID = response.getHeaderValue("working-propagatable-id");
        if (propagatbleBlobID != null && propagatbleBlobID.length() > 0) {
            connection.close();
            return new SegmentedExportStream(this.propagator, propagatbleBlobID);
        }
        return new ExportStream(connection, response.getStream());
    }

    private void handleError(Connection connection, ExportRequest request, IResponse response) throws PropagationException {
        int status = response.getStatus();
        try {
            try {
                if (response.isContentXML()) {
                    ErrorEntity error = (ErrorEntity)request.parse(connection.getAbsolutePath(request.getPath()), response);
                    throw PropagationUtil.getNewPreconditionException(error, response.getStatusDescription());
                }
                if (status == 404) {
                    throw new PropagationPreconditionException("/" + request.getPath(), response.getStatusDescription());
                }
                throw new PropagationException(this.getCombinedErrorMessage("Could not perform Export Request", response));
            }
            catch (HTTPException ex) {
                throw new PropagationException(ex.toString());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            connection.close();
            throw throwable;
        }
    }
}

