/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.propagation;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.propagation.DtrConnection;
import com.tssap.dtr.client.lib.propagation.Propagatable;
import com.tssap.dtr.client.lib.propagation.PropagationUtil;
import com.tssap.dtr.client.lib.propagation.clientapi.IImportable;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatable;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatableBlob;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatableBlobSegment;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagator;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.ErrorEntity;
import com.tssap.dtr.client.lib.protocol.entities.StreamEntity;
import com.tssap.dtr.client.lib.protocol.requests.xcm.ImportRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;

public class Importable
implements IImportable {
    private static final Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$propagation$Importable == null ? (class$com$tssap$dtr$client$lib$propagation$Importable = Importable.class$("com.tssap.dtr.client.lib.propagation.Importable")) : class$com$tssap$dtr$client$lib$propagation$Importable));
    private IPropagator propagator;
    private DtrConnection dtrConnection;
    private int segmentSize;
    private boolean supportsSegmentedImport;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$propagation$Importable;

    Importable(IPropagator propagator, DtrConnection connection) {
        this(propagator, connection, Integer.MAX_VALUE, false);
    }

    Importable(IPropagator propagator, DtrConnection connection, int segmentSize, boolean supportSegmentedImport) {
        this.dtrConnection = connection;
        this.propagator = propagator;
        this.segmentSize = segmentSize;
        this.supportsSegmentedImport = supportSegmentedImport;
    }

    public IPropagatable import_(InputStream contents, byte options, long length) throws PropagationException {
        return this.import_(contents, options, length, null);
    }

    public IPropagatable import_(InputStream contents, byte options) throws PropagationException {
        return this.import_(contents, options, -1L);
    }

    public InputStream getInputStream() {
        throw new UnsupportedOperationException("Method getInputStream() not supported in this context.");
    }

    public IPropagatable import_(InputStream contents, byte options, String targetLocation) throws PropagationException {
        return this.import_(contents, options, -1L, targetLocation);
    }

    public IPropagatable import_(InputStream contents, byte options, long length, String targetLocation) throws PropagationException {
        return this._import(contents, options, length, targetLocation);
    }

    private IPropagatable _import(InputStream contents, byte options, long length, String targetLocation) throws PropagationException {
        TRACE.debugT("started import with paramters; blob length {0}, target location {1}.", new Object[]{new Long(length), targetLocation});
        String importedURL = "";
        importedURL = this.supportsSegmentedImport && length > (long)this.segmentSize ? this.doSegmentedImport(contents, options, length, targetLocation) : this.doNormalImport(contents, options, length, targetLocation);
        TRACE.debugT("import completed successfully. Imported versionset {0}.", new Object[]{importedURL});
        try {
            return new Propagatable(this.propagator, new DtrConnection(this.dtrConnection), importedURL);
        }
        catch (MalformedURLException e) {
            throw new PropagationException(e);
        }
    }

    private String doNormalImport(InputStream contents, byte options, long length, String targetLocation) throws PropagationException {
        Connection connection = null;
        IResponse response = null;
        ImportRequest importRequest = null;
        try {
            TRACE.debugT("performing normal import");
            connection = this.dtrConnection.openConnection();
            StreamEntity requestEntity = new StreamEntity(contents, "application/octet-stream");
            requestEntity.setContentLength(length);
            importRequest = new ImportRequest("", (IRequestEntity)requestEntity);
            importRequest.setImportOptions((int)options);
            if (targetLocation != null) {
                importRequest.setWorkspaceTargetLocation(targetLocation);
            }
            TRACE.debugT("Sending IMPORT request to server");
            response = importRequest.perform((IConnection)connection, true);
        }
        catch (HTTPException ex) {
            throw new PropagationException("Invalid or incomplete response from the server " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new PropagationException("An IOException occured " + ex.getMessage());
        }
        TRACE.debugT("Server responded with status {0}; description {1}", new Object[]{new Integer(response.getStatus()), response.getStatusDescription()});
        this.validateResponse(response);
        return importRequest.getImportedURL();
    }

    private void validateResponse(IResponse response) throws PropagationPreconditionException, PropagationException {
        int status = response.getStatus();
        if (status != 207) {
            if (status == 412) {
                ErrorEntity error = (ErrorEntity)response.getEntity();
                throw PropagationUtil.getNewPreconditionException(error, response.getStatusDescription());
            }
            throw new PropagationException("Could not perform Import Request: Status = " + status + " " + response.getStatusDescription());
        }
    }

    private String doSegmentedImport(InputStream contents, byte options, long length, String targetLocation) throws PropagationException {
        TRACE.debugT("performing segmented import");
        WrappedInputStream fullContents = new WrappedInputStream(contents, length);
        String versionSetID = fullContents.extractVersionSetIDFromStream();
        if (versionSetID == null) {
            TRACE.debugT("Cannot proceed with segmented import; Lets try normal import");
            return this.doNormalImport(fullContents, options, length, targetLocation);
        }
        int segmentCount = (int)Math.ceil((double)length / (double)this.segmentSize);
        String propagatableBlobID = this.startSegmentedImport(versionSetID, String.valueOf(segmentCount), String.valueOf(length));
        segmentCount = this.uploadSegments(propagatableBlobID, fullContents, length);
        return this.completeSegmentedImport(versionSetID, String.valueOf(segmentCount), String.valueOf(length), options, targetLocation);
    }

    private int uploadSegments(String propagatableBlobID, InputStream fullContents, long segmentsLength) throws PropagationException {
        TRACE.debugT("retrieving the blob & its segments from the server");
        IPropagatableBlob blob = this.propagator.getPropagatableBlobUsingID(propagatableBlobID);
        if (blob.getBlobLength() != segmentsLength) {
            throw new PropagationPreconditionException("invalid-blob-length", "Propagatable blob length does not match the length of the stream");
        }
        long totalBlobLength = 0L;
        IPropagatableBlobSegment[] segments = blob.getSegments();
        int index = 0;
        while (index < segments.length) {
            totalBlobLength += (long)segments[index].getSegmentLength();
            ++index;
        }
        if (totalBlobLength == 0L || totalBlobLength > 0L && totalBlobLength != segmentsLength) {
            TRACE.debugT("All segments already available on the server.");
            long uploadedBlobLength = 0L;
            int expectedSize = (int)(segmentsLength / (long)segments.length) + 1;
            int index2 = 0;
            while (index2 < segments.length) {
                if (index2 != segments[index2].getSegmentNumber()) {
                    TRACE.debugT("Incorrect order of segments returned by the server. Expected segment {0}, found segment {1}", new Object[]{new Integer(index2), new Integer(segments[index2].getSegmentNumber())});
                }
                int actualSize = (int)Math.min(segmentsLength - uploadedBlobLength, (long)expectedSize);
                TRACE.debugT("Uploading segment number {0} with length {1}.", new Object[]{new Integer(index2), new Integer(actualSize)});
                segments[index2].setSegmentBlob(new WindowedInputStream(fullContents, actualSize), actualSize);
                uploadedBlobLength += (long)actualSize;
                ++index2;
            }
            if (uploadedBlobLength != segmentsLength) {
                throw new PropagationPreconditionException("invalid-blob-length", "Upload of all segments did not complete successfully");
            }
        } else {
            TRACE.debugT("All segments already available on the server.");
        }
        return segments.length;
    }

    protected String startSegmentedImport(String versionSetID, String segmentCount, String segmentsLength) throws PropagationException {
        Connection connection = null;
        IResponse response = null;
        ImportRequest importRequest = null;
        try {
            TRACE.debugT("initiating segmented import on the server");
            connection = this.dtrConnection.openConnection();
            importRequest = new ImportRequest("", null);
            importRequest.startSegmentedImport(versionSetID, segmentCount, segmentsLength);
            TRACE.debugT("sending segmented IMPORT start request to the server");
            response = importRequest.perform((IConnection)connection, true);
        }
        catch (HTTPException ex) {
            throw new PropagationException("Invalid or incomplete response from the server " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new PropagationException("An IOException occured " + ex.getMessage());
        }
        TRACE.debugT("Server responded with status {0}; description {1}", new Object[]{new Integer(response.getStatus()), response.getStatusDescription()});
        this.validateResponse(response);
        return importRequest.getImportedURL();
    }

    protected String completeSegmentedImport(String versionSetID, String segmentCount, String segmentsLength, byte options, String targetLocation) throws PropagationException {
        Connection connection = null;
        IResponse response = null;
        ImportRequest importRequest = null;
        try {
            TRACE.debugT("finalizing segmented import on the server");
            connection = this.dtrConnection.openConnection();
            importRequest = new ImportRequest("", null);
            importRequest.completeSegmentedImport(versionSetID, segmentCount, segmentsLength);
            importRequest.setImportOptions((int)options);
            if (targetLocation != null) {
                importRequest.setWorkspaceTargetLocation(targetLocation);
            }
            TRACE.debugT("sending segmented IMPORT complete request to the server");
            response = importRequest.perform((IConnection)connection, true);
        }
        catch (HTTPException ex) {
            throw new PropagationException("Invalid or incomplete response from the server " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new PropagationException("An IOException occured " + ex.getMessage());
        }
        TRACE.debugT("Server responded with status {0}; description {1}", new Object[]{new Integer(response.getStatus()), response.getStatusDescription()});
        this.validateResponse(response);
        return importRequest.getImportedURL();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static final class WrappedInputStream
    extends WindowedInputStream {
        private InputStream magicValueBytes;
        private static final String VERSION_SET_ID_KEY = "versionSet id=\"";
        private static final int VERSION_SET_ID_LENGTH = 36;
        private static final int MAGIC_BYTES_LENGTH = 38;
        public static final int HEADER_CONTROL_BYTES_LEN = 46;
        public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        private static Set magicValues = new HashSet();

        WrappedInputStream(InputStream contents, long windowLength) {
            super(contents, windowLength);
        }

        public String extractVersionSetIDFromStream() throws PropagationException {
            String versionSetID = null;
            try {
                TRACE.debugT("extracting the versionset information from the blob");
                byte[] headerBytes = this.extractHeaderXMLBytes();
                if (headerBytes != null) {
                    this.magicValueBytes = new ByteArrayInputStream(headerBytes, 0, headerBytes.length);
                    int startPosition = 54;
                    String headerXML = new String(headerBytes, startPosition, headerBytes.length - (startPosition + 8), "UTF-8");
                    TRACE.debugT(headerXML);
                    int index = headerXML.indexOf(VERSION_SET_ID_KEY);
                    if (index > 0) {
                        versionSetID = headerXML.substring(index += VERSION_SET_ID_KEY.length(), index + 36);
                        TRACE.debugT("extracted the versionset id {0} from the blob", new Object[]{versionSetID});
                    } else {
                        TRACE.debugT("blob stream format version is known; Unable to extract '{0}' information from the stream.", new Object[]{VERSION_SET_ID_KEY});
                    }
                } else {
                    TRACE.debugT("blob stream format version is not known; so extraction of the versionset information is not possible.");
                }
            }
            catch (IOException ex) {
                throw new PropagationException("An IOException occured " + ex.getMessage());
            }
            return versionSetID;
        }

        public byte[] extractHeaderXMLBytes() throws IOException {
            TRACE.debugT("extracting the header information from the blob");
            byte[] longBytes = new byte[46];
            int bytesRead = this._readBytes(this, longBytes, 0, longBytes.length);
            Long value = new Long(PropagationUtil.byteToLong(longBytes, 0));
            if (magicValues.contains(value)) {
                TRACE.debugT("blob stream format version is known; extraction of the header information is possible.");
                long sizeOfHeader = PropagationUtil.byteToLong(longBytes, 38);
                byte[] headerBytes = new byte[(int)((long)longBytes.length + sizeOfHeader)];
                System.arraycopy(longBytes, 0, headerBytes, 0, longBytes.length);
                bytesRead = this._readBytes(this, headerBytes, longBytes.length, (int)sizeOfHeader);
                return headerBytes;
            }
            this.magicValueBytes = new ByteArrayInputStream(longBytes, 0, 8);
            TRACE.debugT("blob stream format version is not known; extraction of the header information is not possible.");
            return null;
        }

        protected int _readBytes(InputStream stream, byte[] buf, int pos, int len) throws IOException {
            if (buf == null || len <= 0) {
                return -1;
            }
            if (buf.length < pos + len) {
                len = buf.length - pos;
            }
            int bytesRead = 0;
            int totalByteRead = 0;
            while (totalByteRead < len && bytesRead > -1) {
                bytesRead = stream.read(buf, pos, len - totalByteRead);
                if (bytesRead == -1) continue;
                totalByteRead += bytesRead;
                pos += bytesRead;
            }
            return totalByteRead == 0 ? -1 : totalByteRead;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int bytesRead = -1;
            if (this.magicValueBytes != null) {
                bytesRead = this.magicValueBytes.read(b, off, len);
                if (bytesRead == -1) {
                    this.magicValueBytes = null;
                    bytesRead = this.read(b, off, len);
                }
            } else {
                bytesRead = super.read(b, off, len);
            }
            return bytesRead;
        }

        static {
            magicValues.add(new Long(3694496401L));
            magicValues.add(new Long(1656531294L));
        }
    }

    protected static class WindowedInputStream
    extends InputStream {
        private byte[] singleByte = new byte[1];
        private InputStream contents;
        private long windowLength;
        private long totalBytesRead;

        WindowedInputStream(InputStream contents, long windowLength) {
            this.contents = contents;
            this.windowLength = windowLength == -1L ? Long.MAX_VALUE : windowLength;
        }

        public int read() throws IOException {
            return this.read(this.singleByte) == -1 ? -1 : this.singleByte[1] & 0xFF;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int bytesRead = -1;
            int byteToRead = this.getCountOfBytesToRead(len);
            if (byteToRead > 0) {
                bytesRead = this.contents.read(b, off, byteToRead);
            }
            if (bytesRead > 0) {
                this.totalBytesRead += (long)bytesRead;
            }
            return bytesRead;
        }

        private int getCountOfBytesToRead(int len) {
            if (this.windowLength < this.totalBytesRead + (long)len) {
                len = (int)(this.windowLength - this.totalBytesRead);
            }
            return len;
        }

        public int available() throws IOException {
            return (int)(this.windowLength - this.totalBytesRead);
        }

        public long skip(long n) throws IOException {
            return super.skip(this.getCountOfBytesToRead((int)n));
        }
    }
}

