/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.propagation;

import com.tssap.dtr.client.lib.propagation.PropagatableBlobStream;
import com.tssap.dtr.client.lib.propagation.PropagationUtil;
import com.tssap.dtr.client.lib.propagation.clientapi.IExportable;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.protocol.Connection;
import java.io.IOException;
import java.io.InputStream;

public class ExportStream
extends PropagatableBlobStream
implements IExportable {
    private byte[] catalogBytes = new byte[16];
    private int catalogIndex = 0;
    private static int CATALOG_LENGTH = 8;
    private int lastCopiedBytesLength = 0;

    ExportStream(Connection connection, InputStream contentStream) {
        super(connection, contentStream);
    }

    public InputStream getContents() throws PropagationException {
        return this;
    }

    protected void copyBytesAndValidate(byte[] b, int off, int len) throws IOException {
        if (len == -1) {
            this.validate();
        } else {
            this.copyBytes(b, off, len);
        }
    }

    private void copyBytes(byte[] b, int off, int len) {
        int offset = len > CATALOG_LENGTH ? len - CATALOG_LENGTH : 0;
        int n = this.lastCopiedBytesLength = len > CATALOG_LENGTH ? CATALOG_LENGTH : len;
        if (this.lastCopiedBytesLength == CATALOG_LENGTH) {
            this.catalogIndex = 0;
        }
        System.arraycopy(b, off + offset, this.catalogBytes, this.catalogIndex, this.lastCopiedBytesLength);
        this.catalogIndex += this.lastCopiedBytesLength;
        if (this.catalogIndex > CATALOG_LENGTH) {
            System.arraycopy(this.catalogBytes, this.catalogIndex - CATALOG_LENGTH, this.catalogBytes, 0, CATALOG_LENGTH);
            this.catalogIndex = this.lastCopiedBytesLength = CATALOG_LENGTH;
        }
    }

    private void validate() throws IOException {
        long lengthOfCatalog = PropagationUtil.byteToLong(this.catalogBytes, 0);
        if (lengthOfCatalog <= 0L) {
            throw new IOException("Export contents validation failed (incomplete export detected). Please check the server log files for more information.");
        }
    }
}

