/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.propagation;

import com.tssap.dtr.client.lib.propagation.PropagatableBlobStream;
import com.tssap.dtr.client.lib.propagation.PropagationUtil;
import java.io.IOException;
import java.io.InputStream;

public class ExportContentValidationStream
extends PropagatableBlobStream {
    private static final String END_CATALOG_TAG = "</catalog>";
    private byte[] catalogBytes = new byte[BLOB_END_BYTES_LENGTH];
    private int catalogIndex = 0;
    private static final int BLOB_END_BYTES_LENGTH = "</catalog>".length() + 8 + 1;
    private int lastCopiedBytesLength = 0;

    ExportContentValidationStream(InputStream contentStream) {
        super(null, contentStream);
    }

    protected void copyBytesAndValidate(byte[] b, int off, int len) throws IOException {
        if (len == -1) {
            this.validate();
        } else {
            this.copyBytes(b, off, len);
        }
    }

    private void copyBytes(byte[] b, int off, int len) {
        int offset = len > BLOB_END_BYTES_LENGTH ? len - BLOB_END_BYTES_LENGTH : 0;
        int n = this.lastCopiedBytesLength = len > BLOB_END_BYTES_LENGTH ? BLOB_END_BYTES_LENGTH : len;
        if (this.lastCopiedBytesLength == BLOB_END_BYTES_LENGTH) {
            this.catalogIndex = 0;
        }
        System.arraycopy(b, off + offset, this.catalogBytes, this.catalogIndex, this.lastCopiedBytesLength);
        this.catalogIndex += this.lastCopiedBytesLength;
        if (this.catalogIndex > BLOB_END_BYTES_LENGTH) {
            System.arraycopy(this.catalogBytes, this.catalogIndex - BLOB_END_BYTES_LENGTH, this.catalogBytes, 0, BLOB_END_BYTES_LENGTH);
            this.catalogIndex = this.lastCopiedBytesLength = BLOB_END_BYTES_LENGTH;
        }
    }

    private void validate() throws IOException {
        long lengthOfCatalog = PropagationUtil.byteToLong(this.catalogBytes, END_CATALOG_TAG.length() + 1);
        String catalogTag = new String(this.catalogBytes, 0, END_CATALOG_TAG.length(), "UTF-8");
        if (lengthOfCatalog <= 0L || !catalogTag.equalsIgnoreCase(END_CATALOG_TAG)) {
            throw new IOException("Export contents validation failed (incomplete export detected). Please check the server log files for more information.");
        }
    }
}

