/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.propagation;

import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.requests.http.OptionsRequest;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Properties;

class DtrConnection {
    private String serverUrl;
    private String user;
    private String password;
    private SessionContext context;
    private Connection connection;
    private Properties connectionProperties = null;

    DtrConnection(String serverUrl, String user, String password) throws MalformedURLException {
        this.setConnectionParameters(serverUrl, user, password);
        this.context = new SessionContext(user, password);
        this.connection = new Connection(serverUrl, (ISessionContext)this.context);
    }

    private void setConnectionParameters(String serverUrl, String user, String password) {
        this.serverUrl = serverUrl;
        this.user = user;
        this.password = password;
    }

    DtrConnection(IConnectionTemplate template) {
        this.setConnectionParameters(template.getUrl(), template.getSessionContext().getUser(), template.getSessionContext().getPassword());
        this.connection = new Connection(template);
    }

    DtrConnection(String serverUrl, String user, String password, Properties connectionProperties) throws MalformedURLException {
        this(serverUrl, user, password);
        this.connectionProperties = connectionProperties;
        this.setConnectionProperties(this.connectionProperties);
    }

    DtrConnection(DtrConnection dtrConnection) throws MalformedURLException {
        this(dtrConnection.serverUrl, dtrConnection.user, dtrConnection.password, dtrConnection.connectionProperties);
    }

    void setConnectionProperties(Properties connectionProperties) {
        if (this.connection != null && connectionProperties != null) {
            String compressionRequests;
            String repeatCount = connectionProperties.getProperty("repeat", "1");
            String repeatOnTimeout = connectionProperties.getProperty("repeatOnTimeout", "false");
            this.connection.setRequestRepetitions(Integer.parseInt(repeatCount), Boolean.getBoolean(repeatOnTimeout));
            String readTimeOut = connectionProperties.getProperty("readTimeout", "0");
            this.connection.setSocketReadTimeout(Integer.parseInt(readTimeOut));
            String connectionTimeOut = connectionProperties.getProperty("connectTimeout", "300000");
            this.connection.setSocketConnectTimeout(Integer.parseInt(connectionTimeOut));
            String expireTimeOut = connectionProperties.getProperty("expireTimeout", "10000");
            this.connection.setSocketExpirationTimeout(Integer.parseInt(expireTimeOut));
            String compressionResponses = connectionProperties.getProperty("compressResponses", "on,gzip");
            if (compressionResponses.startsWith("on")) {
                if (compressionResponses.length() > 2) {
                    this.connection.setCompressionAlgorithm(compressionResponses.substring(3));
                }
                this.connection.enableResponseCompression(true);
            }
            if ((compressionRequests = connectionProperties.getProperty("compressResponses", "on,gzip")).startsWith("on")) {
                if (compressionRequests.length() > 2) {
                    this.connection.setCompressionAlgorithm(compressionRequests.substring(3));
                }
                this.connection.enableRequestCompression(true);
            }
        }
    }

    Connection openConnection() throws IOException, HTTPException {
        this.connection.open();
        this.sendOptionsRequest(this.connection);
        return this.connection;
    }

    private void sendOptionsRequest(Connection connection) throws IOException, HTTPException {
        IResponse response = connection.send((IRequest)new OptionsRequest(""));
        int status = response.getStatus();
        if (status != 200 && (status = (response = connection.send((IRequest)new OptionsRequest(""))).getStatus()) != 200) {
            throw new HTTPException("Connection to server failed with status " + response.getStatusDescription());
        }
    }
}

