/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.exceptions;

import com.tssap.dtr.client.lib.exceptions.INestedException;
import com.tssap.dtr.client.lib.exceptions.StackFrame;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;

public final class StackTrace {
    private Throwable _throwable;
    private StackFrame[] _stackframes;
    private static final ThreadLocal tls_lastStackFrames = new ThreadLocal(){

        protected Object initialValue() {
            return new StackFrame[0];
        }
    };
    private static final int BLANKS_PER_INDENTATION = 4;
    private static final String BLANKS;

    private static StackFrame[] getLastStackFrames() {
        return (StackFrame[])tls_lastStackFrames.get();
    }

    private static void setLastStackFrames(StackFrame[] stackFrames) {
        if (stackFrames != null) {
            tls_lastStackFrames.set(stackFrames);
        } else {
            tls_lastStackFrames.set(new StackFrame[0]);
        }
    }

    private static String getIndentation(int level) {
        return BLANKS.substring(0, level * 4);
    }

    public static void printStackTrace(Throwable t) {
        StackTrace.setLastStackFrames(null);
        StackTrace.printStackTrace(t, 0);
    }

    public static void printStackTrace(PrintStream printStream, Throwable t) {
        StackTrace.setLastStackFrames(null);
        StackTrace.printStackTrace(printStream, t, 0);
    }

    public static void printStackTrace(PrintWriter printWriter, Throwable t) {
        StackTrace.setLastStackFrames(null);
        StackTrace.printStackTrace(printWriter, t, 0);
    }

    private static void printStackTrace(Throwable throwable, int level) {
        StackTrace.printStackTrace(System.err, throwable, level);
    }

    private static void printStackTrace(PrintStream printStream, Throwable throwable, int level) {
        PrintWriter printWriter = new PrintWriter(printStream);
        StackTrace.printStackTrace(printWriter, throwable, level);
        printWriter.flush();
    }

    private static void printStackTrace(PrintWriter printWriter, Throwable throwable, int level) {
        if (throwable == null) {
            return;
        }
        StackTrace stackTrace = new StackTrace(throwable);
        printWriter.print(StackTrace.getIndentation(level));
        printWriter.print(stackTrace.getClassname());
        if (stackTrace.getMessage() != null) {
            printWriter.print(": ");
            printWriter.print(stackTrace.getMessage());
        }
        printWriter.println();
        String indent2 = StackTrace.getIndentation(level + 1);
        StackFrame[] stackFrames = stackTrace.getStackFrames();
        StackFrame[] lastStackFrames = StackTrace.getLastStackFrames();
        boolean completePrintout = true;
        int j = 0;
        while (j < stackFrames.length) {
            StackFrame stackFrame = stackFrames[j];
            printWriter.print(indent2);
            printWriter.println(stackFrame.toString());
            if (StackTrace.compareStackFrames(stackFrames, lastStackFrames, j)) {
                printWriter.print(indent2);
                printWriter.println("... " + (stackFrames.length - j - 1) + " more");
                completePrintout = false;
                break;
            }
            ++j;
        }
        if (completePrintout) {
            StackTrace.setLastStackFrames(stackFrames);
        }
        if (throwable instanceof INestedException) {
            Throwable[] throwables = ((INestedException)((Object)throwable)).getCauses();
            int i = 0;
            while (i < throwables.length) {
                StackTrace.printNestedException(printWriter, level + 1, "+++ Nested exception part " + (i + 1) + "/" + throwables.length, throwables[i]);
                ++i;
            }
        } else if (throwable instanceof InvocationTargetException) {
            StackTrace.printNestedException(printWriter, level + 1, "+++ Nested exception", ((InvocationTargetException)throwable).getTargetException());
        }
    }

    private static void printNestedException(PrintWriter printWriter, int level, String headline, Throwable throwable) {
        if (throwable != null) {
            printWriter.println();
            printWriter.print(StackTrace.getIndentation(level));
            printWriter.println(headline);
            StackTrace.printStackTrace(printWriter, throwable, level);
        }
    }

    private static boolean compareStackFrames(StackFrame[] stackFrames, StackFrame[] lastStackFrames, int j) {
        int toCompare = stackFrames.length - j;
        if (lastStackFrames.length < toCompare) {
            return false;
        }
        int lastOffset = lastStackFrames.length - stackFrames.length;
        int i = j;
        while (i < stackFrames.length) {
            StackFrame stackFrame = stackFrames[i];
            if (!stackFrame.equals(lastStackFrames[lastOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public StackTrace(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        this._throwable = t;
    }

    public String getClassname() {
        return this._throwable.getClass().getName();
    }

    public String getMessage() {
        return this._throwable.getMessage();
    }

    public StackFrame[] getStackFrames() {
        if (this._stackframes == null) {
            this._stackframes = this.parseStackFrames();
        }
        return this._stackframes;
    }

    /*
     * WARNING - void declaration
     */
    private StackFrame[] parseStackFrames() {
        int stackFrameEnd;
        StringWriter stringWriter = new StringWriter(4096);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (this._throwable instanceof INestedException) {
            ((INestedException)((Object)this._throwable)).printOriginalStackTrace(printWriter);
        } else {
            this._throwable.printStackTrace(printWriter);
        }
        String completeTrace = stringWriter.toString();
        String eol = System.getProperty("line.separator", "\n");
        String firstFrameMark = eol + "\tat ";
        ArrayList<StackFrame> stackFrames = new ArrayList<StackFrame>();
        int stackFrameStart = completeTrace.indexOf(firstFrameMark) + eol.length();
        while ((stackFrameEnd = completeTrace.indexOf(eol, stackFrameStart)) > 0) {
            void var8_8;
            if (completeTrace.charAt(stackFrameStart) != '\t') break;
            String cl = completeTrace.substring(++stackFrameStart, (int)var8_8);
            stackFrames.add(new StackFrame(cl));
            stackFrameStart = var8_8 + eol.length();
        }
        return stackFrames.toArray(new StackFrame[stackFrames.size()]);
    }

    static {
        char[] blanks = new char[100];
        Arrays.fill(blanks, ' ');
        BLANKS = new String(blanks);
    }
}

