/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.xcm;

import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IFile;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.util.EmptyArray;
import com.tssap.dtr.client.lib.deltavlib.xcm.IResourceResultSet;
import com.tssap.dtr.client.lib.deltavlib.xcm.ISynchronizeResourceCallback;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class ResourceCollector
implements ISynchronizeResourceCallback,
IResourceResultSet {
    private static final ICollection[] NO_COLLECTIONS = new ICollection[0];
    private static final IVersionControlledResource[] NO_VCRS = new IVersionControlledResource[0];
    private static final IWorkspace[] NO_WORSPACES = new IWorkspace[0];
    private static final IFile[] NO_FILES = new IFile[0];
    private static final IResource[] NO_NOT_FOUNDS = new IResource[0];
    private static final IResource[] NO_NOT_APPLICABLES = new IResource[0];
    private static final IResource[] NO_DELETED = new IResource[0];
    private static final IResource[] NO_MOVED = new IResource[0];
    private static final String[] NO_INVALID = new String[0];
    private Collection vcrCollections;
    private Collection vcrFiles;
    private Collection collections;
    private Collection files;
    private Collection workspaces;
    private Collection deletedResources;
    private Collection movedResources;
    private Collection notFoundResources;
    private Collection notApplicableResources;
    private Collection invalidResourcePaths;
    private Collection forbiddenPaths;
    private Date serverTime;
    private boolean requestCompleted;

    private static Collection addResource(Collection collection, IResource resource) {
        if (collection == null) {
            collection = new ArrayList<IResource>();
        }
        collection.add(resource);
        return collection;
    }

    private static int getResourceCount(Collection resourceCollection) {
        if (resourceCollection == null) {
            return 0;
        }
        return resourceCollection.size();
    }

    private void addDeleted(IResource resource) {
        this.deletedResources = ResourceCollector.addResource(this.deletedResources, resource);
    }

    private void addMoved(IResource resource) {
        this.movedResources = ResourceCollector.addResource(this.movedResources, resource);
    }

    private void addNotFound(IResource resource) {
        this.notFoundResources = ResourceCollector.addResource(this.notFoundResources, resource);
    }

    private void addNotApplicable(IResource resource) {
        this.notApplicableResources = ResourceCollector.addResource(this.notApplicableResources, resource);
    }

    private void addInvalid(String resourcePath) {
        if (this.invalidResourcePaths == null) {
            this.invalidResourcePaths = new ArrayList();
        }
        this.invalidResourcePaths.add(resourcePath);
    }

    private void addFile(IFile file) {
        this.files = ResourceCollector.addResource(this.files, file);
    }

    private void addCollection(ICollection collection) {
        this.collections = ResourceCollector.addResource(this.collections, collection);
    }

    private void addVcrFile(IVersionControlledResource vcrFile) {
        this.vcrFiles = ResourceCollector.addResource(this.vcrFiles, vcrFile);
    }

    private void addVcrCollection(IVersionControlledResource vcrCollection) {
        this.vcrCollections = ResourceCollector.addResource(this.vcrCollections, vcrCollection);
    }

    private void addWorkspace(IWorkspace workspace) {
        this.workspaces = ResourceCollector.addResource(this.workspaces, workspace);
    }

    private void readResource(IResource resource) {
        try {
            if (resource.isVersioned()) {
                if (resource.isCollection()) {
                    this.addVcrCollection(resource.getAsVersionControlled());
                } else {
                    this.addVcrFile(resource.getAsVersionControlled());
                }
            } else if (resource.isCollection()) {
                ICollection collection = resource.getAsCollection();
                if (collection.isWorkspace()) {
                    this.addWorkspace(collection.getAsWorkspace());
                } else {
                    this.addCollection(collection);
                }
            } else {
                this.addFile(resource.getAsFile());
            }
        }
        catch (VcmFailure e) {
            throw new IllegalStateException("Should not access not-initialized properties");
        }
    }

    protected boolean readFileContent(String path, InputStream content) {
        return false;
    }

    public void clear() {
        this.vcrCollections = null;
        this.vcrFiles = null;
        this.collections = null;
        this.files = null;
        this.workspaces = null;
        this.deletedResources = null;
        this.movedResources = null;
        this.serverTime = null;
        this.notFoundResources = null;
        this.notApplicableResources = null;
        this.invalidResourcePaths = null;
        this.requestCompleted = false;
    }

    public void currentServerTime(Date time) {
        this.serverTime = time;
    }

    public boolean receivedFile(IResource resource, InputStream content) throws IOException {
        this.readResource(resource);
        this.readFileContent(resource.getPath(), content);
        return false;
    }

    public boolean deleted(IResource resource) {
        this.addDeleted(resource);
        return false;
    }

    public boolean moved(IResource resource) {
        this.addMoved(resource);
        return false;
    }

    public boolean notFound(IResource resource) {
        this.addNotFound(resource);
        return false;
    }

    public boolean receivedCollection(IResource resource) {
        this.readResource(resource);
        return false;
    }

    public int getTotalCount() {
        return this.getFileCount() + this.getCollectionCount() + this.getVcrCollectionCount() + this.getVcrFileCount() + this.getWorkspaceCount();
    }

    public Date getServerTime() {
        return this.serverTime;
    }

    public ICollection[] getCollections() {
        if (this.collections != null) {
            return this.collections.toArray(new ICollection[this.collections.size()]);
        }
        return NO_COLLECTIONS;
    }

    public int getCollectionCount() {
        return ResourceCollector.getResourceCount(this.collections);
    }

    public int getFileCount() {
        return ResourceCollector.getResourceCount(this.files);
    }

    public int getVcrCollectionCount() {
        return ResourceCollector.getResourceCount(this.vcrCollections);
    }

    public IVersionControlledResource[] getVcrCollections() {
        if (this.vcrCollections != null) {
            return this.vcrCollections.toArray(new IVersionControlledResource[this.vcrCollections.size()]);
        }
        return NO_VCRS;
    }

    public int getVcrFileCount() {
        return ResourceCollector.getResourceCount(this.vcrFiles);
    }

    public IVersionControlledResource[] getVcrFiles() {
        if (this.vcrFiles != null) {
            return this.vcrFiles.toArray(new IVersionControlledResource[this.vcrFiles.size()]);
        }
        return NO_VCRS;
    }

    public int getWorkspaceCount() {
        return ResourceCollector.getResourceCount(this.workspaces);
    }

    public IWorkspace[] getWorkspaces() {
        if (this.workspaces != null) {
            return this.workspaces.toArray(new IWorkspace[this.workspaces.size()]);
        }
        return NO_WORSPACES;
    }

    public String[] getForbiddenResourcesPaths() {
        if (this.forbiddenPaths != null) {
            return this.forbiddenPaths.toArray(new String[this.forbiddenPaths.size()]);
        }
        return EmptyArray.STRING_ARRAY;
    }

    public boolean receivedFile(IResource file, IResponseStream content) throws IOException {
        this.readResource(file);
        InputStream is = content != null ? content.asStream() : null;
        this.readFileContent(file.getPath(), is);
        return false;
    }

    public boolean forbidden(String decodedResourcePath) {
        if (this.forbiddenPaths == null) {
            this.forbiddenPaths = new ArrayList();
        }
        this.forbiddenPaths.add(decodedResourcePath);
        return false;
    }

    public IResource[] getNotFoundResources() {
        if (this.notFoundResources != null) {
            return this.notFoundResources.toArray(new IResource[this.notFoundResources.size()]);
        }
        return NO_NOT_FOUNDS;
    }

    public int getNotFoundCount() {
        return ResourceCollector.getResourceCount(this.notFoundResources);
    }

    public boolean notApplicable(IResource resource) {
        this.addNotApplicable(resource);
        return false;
    }

    public IResource[] getNotApplicableResources() {
        if (this.notApplicableResources != null) {
            return this.notApplicableResources.toArray(new IResource[this.notApplicableResources.size()]);
        }
        return NO_NOT_APPLICABLES;
    }

    public int getNotApplicableCount() {
        return ResourceCollector.getResourceCount(this.notApplicableResources);
    }

    public IResource[] getDeletedResources() {
        if (this.deletedResources != null) {
            return this.deletedResources.toArray(new IResource[this.deletedResources.size()]);
        }
        return NO_DELETED;
    }

    public int getDeletedCount() {
        return ResourceCollector.getResourceCount(this.deletedResources);
    }

    public IResource[] getMovedResources() {
        if (this.movedResources != null) {
            return this.movedResources.toArray(new IResource[this.movedResources.size()]);
        }
        return NO_MOVED;
    }

    public int getMovedCount() {
        return ResourceCollector.getResourceCount(this.movedResources);
    }

    public String[] getInvalidResourcePaths() {
        if (this.invalidResourcePaths != null) {
            return this.invalidResourcePaths.toArray(new String[this.invalidResourcePaths.size()]);
        }
        return NO_INVALID;
    }

    public int getInvalidCount() {
        return ResourceCollector.getResourceCount(this.invalidResourcePaths);
    }

    public boolean invalid(String resourcePath) {
        this.addInvalid(resourcePath);
        return false;
    }

    public void requestCompleted() {
        this.requestCompleted = true;
    }

    public boolean getCompleted() {
        return this.requestCompleted;
    }
}

