/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.search;

import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.deltavlib.search.CompareOperator;
import com.tssap.dtr.client.lib.deltavlib.search.Constraint;
import com.tssap.dtr.client.lib.deltavlib.search.IConstraintFactory;
import com.tssap.dtr.client.lib.deltavlib.search.LogicalOperator;
import com.tssap.dtr.client.lib.protocol.requests.dasl.Query;

public class ConstraintFactory
implements IConstraintFactory {
    private static final IConstraintFactory INSTANCE = new ConstraintFactory();

    private ConstraintFactory() {
    }

    public static IConstraintFactory getInstance() {
        return INSTANCE;
    }

    public Constraint createConstraint(String propName, String value, CompareOperator compOperator) {
        if (CompareOperator.EQ == compOperator) {
            return new Constraint(Query.equal((String)propName, (String)PropertyUtil.getNamespaceURI(propName), (String)value));
        }
        if (CompareOperator.GT == compOperator) {
            return new Constraint(Query.greater((String)propName, (String)PropertyUtil.getNamespaceURI(propName), (String)value));
        }
        if (CompareOperator.LT == compOperator) {
            return new Constraint(Query.lower((String)propName, (String)PropertyUtil.getNamespaceURI(propName), (String)value));
        }
        throw new IllegalArgumentException("unknown logical argument");
    }

    public Constraint createConstraint(Constraint left, LogicalOperator operator, Constraint right) {
        return new Constraint(Query.logicalOperator((String)operator.getName(), (Query)left.queryElement(), (Query)right.queryElement()));
    }

    public Constraint createPattternConstraint(String propName, String pattern) {
        return new Constraint(Query.like((String)propName, (String)pattern, (String)PropertyUtil.getNamespaceURI(propName)));
    }

    public Constraint createNegation(Constraint constraint) {
        return new Constraint(Query.not((Query)constraint.queryElement()));
    }

    public Constraint createIsDefined(String propName) {
        return new Constraint(Query.isDefined((String)propName, (String)PropertyUtil.getNamespaceURI(propName)));
    }

    public Constraint createIsCollection() {
        return new Constraint(Query.isCollection());
    }

    public Constraint createContentConstraint(String text) {
        return new Constraint(Query.contains((String)text));
    }
}

