/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.properties;

import com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap;

public class PropertyUtil {
    public static boolean isEqualPropertyName(String propName1, String propName2) {
        if (propName1 == null || propName2 == null) {
            return false;
        }
        int pos1 = propName1.indexOf(58);
        int pos2 = propName2.indexOf(58);
        if (pos1 < 0) {
            if (pos2 == -1 || propName2.startsWith("DAV:")) {
                return propName2.regionMatches(pos2 + 1, propName1, 0, propName1.length());
            }
            return false;
        }
        if (pos2 < 0) {
            if (pos1 == -1 || propName1.startsWith("DAV:")) {
                return propName1.regionMatches(pos1 + 1, propName2, 0, propName2.length());
            }
            return false;
        }
        return propName1.equals(propName2);
    }

    public static int searchProperty(String[] propertyNames, String propertyName) {
        int i = 0;
        while (i < propertyNames.length) {
            if (PropertyUtil.isEqualPropertyName(propertyName, propertyNames[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int searchProperty(String[] propertyNames, String propertyBaseName, String namespaceUri) {
        int i = 0;
        while (i < propertyNames.length) {
            if (PropertyUtil.isEqualPropertyName(propertyNames[i], propertyBaseName, namespaceUri)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isEqualPropertyName(String qualifiedPropName, String propertyBaseName, String namespaceUri) {
        int pos = qualifiedPropName.indexOf(58);
        if (pos < 0) {
            return ("DAV:".equals(namespaceUri) || namespaceUri == null) && qualifiedPropName.equals(propertyBaseName);
        }
        if (namespaceUri != null) {
            return qualifiedPropName.length() == propertyBaseName.length() + namespaceUri.length() && qualifiedPropName.endsWith(propertyBaseName) && qualifiedPropName.startsWith(namespaceUri);
        }
        return qualifiedPropName.startsWith("DAV:") && qualifiedPropName.length() == propertyBaseName.length() + pos + 1 && qualifiedPropName.endsWith(propertyBaseName);
    }

    public static String getNamespaceURI(String propertyName) {
        int pos = propertyName.indexOf(58);
        if (pos < 0) {
            return null;
        }
        String prefix = propertyName.substring(0, pos);
        String uri = NSPrefixToUriMap.getUriForPrefix(prefix);
        if (uri != null) {
            return uri;
        }
        return propertyName.substring(0, pos + 1);
    }

    public static String getNamespacePrefix(String propertyName) {
        int pos = propertyName.indexOf(58);
        if (pos < 0) {
            return null;
        }
        return propertyName.substring(0, pos);
    }

    public static String getLocalName(String propertyName) {
        int pos = propertyName.indexOf(58);
        if (pos < 0) {
            return propertyName;
        }
        return propertyName.substring(++pos);
    }

    public static void getAsQualifiedName(QualifiedName qualifiedNameObject, String propertyName) {
        int pos = propertyName.indexOf(58);
        if (pos < 0) {
            qualifiedNameObject.namespaceUri = null;
            qualifiedNameObject.name = propertyName;
        } else {
            qualifiedNameObject.namespaceUri = propertyName.substring(0, pos + 1);
            qualifiedNameObject.name = propertyName.substring(pos + 1, propertyName.length());
        }
    }

    public static class QualifiedName {
        public String name;
        public String namespaceUri;
    }
}

