/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.properties;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixBindingException;
import com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriBinding;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class NSPrefixToUriMap {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap == null ? (class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap = NSPrefixToUriMap.class$("com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap")) : class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap));
    public static final String DAV_PREFIX = "DAV";
    public static final String XCM_PREFIX = "XCM:".endsWith(":") ? "XCM:".substring(0, "XCM:".length() - 1) : "XCM:";
    private static final HashMap URI_TO_PREFIX_MAP = new HashMap();
    private static final HashMap PREFIX_TO_URI_MAP = new HashMap();
    private static int generatePrefixCount = 0;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap;

    private static void addPrefix2UriBinding(String prefix, String uri) throws NSPrefixBindingException {
        String anotherUri;
        if (prefix != null && (anotherUri = (String)PREFIX_TO_URI_MAP.get(prefix)) != null && !uri.equals(anotherUri)) {
            throw new NSPrefixBindingException(prefix + " prefix already bound to namespace-uri " + anotherUri);
        }
        String[] regEntry = (String[])URI_TO_PREFIX_MAP.get(uri);
        if (regEntry == null) {
            regEntry = new String[]{prefix};
        } else {
            boolean prefixCollision = false;
            if (regEntry.length > 1) {
                if (regEntry[1] == null) {
                    regEntry[1] = regEntry[0];
                    regEntry[0] = prefix;
                } else {
                    prefixCollision = !regEntry[0].equals(prefix);
                }
            } else {
                boolean bl = prefixCollision = !regEntry[0].equals(prefix);
            }
            if (prefixCollision) {
                throw new NSPrefixBindingException(prefix + " prefix already registered for namespace-uri " + uri);
            }
        }
        URI_TO_PREFIX_MAP.put(uri, regEntry);
        PREFIX_TO_URI_MAP.put(prefix, uri);
    }

    private static String[] createExportablePrefixesCopy(String[] prefixesEntryValue) {
        if (prefixesEntryValue.length == 2 && prefixesEntryValue[1] == null) {
            String[] returnPrefixes = new String[]{prefixesEntryValue[0]};
            return returnPrefixes;
        }
        return (String[])prefixesEntryValue.clone();
    }

    private NSPrefixToUriMap() {
    }

    public static String getPrefixForUri(String namespaceUri) {
        String[] prefixes = null;
        Class clazz = class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap == null ? (class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap = NSPrefixToUriMap.class$("com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap")) : class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap;
        synchronized (clazz) {
            prefixes = (String[])URI_TO_PREFIX_MAP.get(namespaceUri);
        }
        return prefixes != null ? prefixes[0] : null;
    }

    public static String getOrGeneratePrefixForUri(String namespaceUri) {
        Class clazz = class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap == null ? (class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap = NSPrefixToUriMap.class$("com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap")) : class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap;
        synchronized (clazz) {
            String[] regEntry = (String[])URI_TO_PREFIX_MAP.get(namespaceUri);
            if (regEntry != null) {
                String string = regEntry[0];
                return string;
            }
            String generatedPrefix = "_PFX" + ++generatePrefixCount;
            regEntry = new String[]{generatedPrefix, null};
            URI_TO_PREFIX_MAP.put(namespaceUri, regEntry);
            PREFIX_TO_URI_MAP.put(generatedPrefix, namespaceUri);
            String string = generatedPrefix;
            return string;
        }
    }

    public static String[] getAllPrefixesForUri(String namespaceUri) {
        Class clazz = class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap == null ? (class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap = NSPrefixToUriMap.class$("com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap")) : class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap;
        synchronized (clazz) {
            String[] prefixes = (String[])URI_TO_PREFIX_MAP.get(namespaceUri);
            if (prefixes != null) {
                String[] stringArray = NSPrefixToUriMap.createExportablePrefixesCopy(prefixes);
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
    }

    public static String getUriForPrefix(String namespacePrefix) {
        Class clazz = class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap == null ? (class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap = NSPrefixToUriMap.class$("com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap")) : class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap;
        synchronized (clazz) {
            String string = (String)PREFIX_TO_URI_MAP.get(namespacePrefix);
            return string;
        }
    }

    public static void bindPrefixToNamespace(String namespacePrefix, String namespaceUri) throws NSPrefixBindingException {
        if (namespaceUri == null || namespacePrefix == null) {
            throw new NullPointerException("null namespace prefix or uri");
        }
        if (namespacePrefix.indexOf(58) >= 0) {
            throw new NSPrefixBindingException(namespacePrefix + " is invalid prefix value");
        }
        String davUri = NSPrefixToUriMap.getUriForPrefix(DAV_PREFIX);
        String xcmUri = NSPrefixToUriMap.getUriForPrefix(XCM_PREFIX);
        if (namespaceUri.equals(davUri) || namespaceUri.equals(xcmUri)) {
            throw new NSPrefixBindingException("Multiple prefix for namespace '" + namespaceUri + "' not allowed");
        }
        Class clazz = class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap == null ? (class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap = NSPrefixToUriMap.class$("com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap")) : class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap;
        synchronized (clazz) {
            NSPrefixToUriMap.addPrefix2UriBinding(namespacePrefix, namespaceUri);
        }
    }

    public static NSPrefixToUriBinding[] getBindings() {
        Class clazz = class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap == null ? (class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap = NSPrefixToUriMap.class$("com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap")) : class$com$tssap$dtr$client$lib$deltavlib$properties$NSPrefixToUriMap;
        synchronized (clazz) {
            Set uri2pfxEntries = URI_TO_PREFIX_MAP.entrySet();
            NSPrefixToUriBinding[] bindings = new NSPrefixToUriBinding[uri2pfxEntries.size()];
            Iterator it = uri2pfxEntries.iterator();
            int i = 0;
            while (it.hasNext()) {
                Map.Entry nextEntry = it.next();
                String[] prefixes = (String[])nextEntry.getValue();
                prefixes = NSPrefixToUriMap.createExportablePrefixesCopy(prefixes);
                bindings[i] = new NSPrefixToUriBinding((String[])nextEntry.getValue(), (String)nextEntry.getKey());
                ++i;
            }
            NSPrefixToUriBinding[] nSPrefixToUriBindingArray = bindings;
            return nSPrefixToUriBindingArray;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            NSPrefixToUriMap.addPrefix2UriBinding(DAV_PREFIX, "DAV:");
            NSPrefixToUriMap.addPrefix2UriBinding(XCM_PREFIX, XCM.NAMESPACE);
        }
        catch (NSPrefixBindingException e) {
            LogUtil.logException((Location)LOC, (Throwable)e);
            throw new IllegalStateException("Failed to register DAV, XCM namespace prefixes." + e.toString());
        }
    }
}

