/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.properties;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IElement;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyFormatException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class Converter {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$properties$Converter == null ? (class$com$tssap$dtr$client$lib$deltavlib$properties$Converter = Converter.class$("com.tssap.dtr.client.lib.deltavlib.properties.Converter")) : class$com$tssap$dtr$client$lib$deltavlib$properties$Converter));
    private static final SimpleDateFormat HTTP_DATE_RFC2068 = new SimpleDateFormat("EEE, d MMM yyyy kk:mm:ss 'GMT'", Locale.ENGLISH);
    private static final SimpleDateFormat[] HTTP_DATE_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("EEE, d MMM yyyy kk:mm:ss 'GMT'", Locale.ENGLISH), new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH), new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.ENGLISH), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.ENGLISH), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH)};
    private static final int[] usage_statistics;
    private static final int[] failure_statistics;
    private static int statistics_counter;
    private static final MRUArray MRU_HTTP_DATE_FORMATs;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$properties$Converter;

    public static synchronized String dateToHTTPDate(Date date) {
        return HTTP_DATE_RFC2068.format(date);
    }

    public static String propertyToHREF(IProperty property) throws PropertyFormatException {
        IElement child = property.getFirstChild();
        if (child == null) {
            return null;
        }
        if (DAV.HREF.localName.equals(child.getName()) && "DAV".equals(property.getNamespace())) {
            return child.getValue();
        }
        throw new PropertyFormatException("Not an DAV:href based property");
    }

    public static String booleanToString(boolean bool) {
        return bool ? "T" : "F";
    }

    public static boolean stringToBoolean(String boolStr) throws PropertyFormatException {
        if (boolStr.equalsIgnoreCase("t") || boolStr.equalsIgnoreCase("true") || boolStr.equals("1")) {
            return true;
        }
        if (boolStr.equalsIgnoreCase("f") || boolStr.equalsIgnoreCase("false") || boolStr.equals("0")) {
            return false;
        }
        throw new PropertyFormatException();
    }

    public static String[] propertyToHREFSet(IProperty property) throws PropertyFormatException {
        IElement child = property.getFirstChild();
        if (child == null) {
            return new String[0];
        }
        if (DAV.HREF.localName.equals(child.getName())) {
            int chidrenNum = property.getChildCount();
            if (chidrenNum > 1) {
                String[] hrefVals = new String[chidrenNum];
                hrefVals[0] = child.getValue();
                int i = 1;
                while (i < chidrenNum) {
                    if (!DAV.HREF.localName.equals((child = child.getNext()).getName())) {
                        throw new PropertyFormatException("not DAV:href based property");
                    }
                    hrefVals[i] = child.getValue();
                    ++i;
                }
                return hrefVals;
            }
            return new String[]{child.getValue()};
        }
        throw new PropertyFormatException("not DAV:href like property");
    }

    public static Date parseHTTPDate(String httpDate) {
        Date date = null;
        SimpleDateFormat format = null;
        MRUArray mRUArray = MRU_HTTP_DATE_FORMATs;
        synchronized (mRUArray) {
            MRUArray.MRUObjectRef mruRef = MRU_HTTP_DATE_FORMATs.getMRUObjRef();
            while (mruRef != null) {
                format = (SimpleDateFormat)mruRef.getObject();
                try {
                    Comparable<Date> statisticsBuf;
                    date = format.parse(httpDate);
                    mruRef.accept();
                    int n = mruRef.getObjectIndex();
                    usage_statistics[n] = usage_statistics[n] + 1;
                    if (LOCATION.beDebug() && (++statistics_counter & 0x7F) == 0) {
                        statisticsBuf = new StringBuffer();
                        ((StringBuffer)statisticsBuf).append("HTTP date format statistics:\n");
                        int j = 0;
                        while (j < usage_statistics.length) {
                            ((StringBuffer)statisticsBuf).append(HTTP_DATE_FORMATS[j].toPattern());
                            ((StringBuffer)statisticsBuf).append(" used:").append(usage_statistics[j]);
                            ((StringBuffer)statisticsBuf).append(" failed:").append(failure_statistics[j]).append("\n");
                            ++j;
                        }
                        LOCATION.debugT(((StringBuffer)statisticsBuf).toString());
                        statistics_counter = 0;
                    }
                    statisticsBuf = date;
                    return statisticsBuf;
                }
                catch (ParseException e) {
                    int n = mruRef.getObjectIndex();
                    failure_statistics[n] = failure_statistics[n] + 1;
                    mruRef = mruRef.next();
                }
            }
        }
        LOCATION.errorT("Unsupported HTTP date conversion: " + httpDate);
        return date;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HTTP_DATE_RFC2068.setTimeZone(TimeZone.getTimeZone("GMT"));
        HTTP_DATE_FORMATS[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        HTTP_DATE_FORMATS[5].setTimeZone(TimeZone.getTimeZone("GMT"));
        usage_statistics = new int[HTTP_DATE_FORMATS.length];
        failure_statistics = new int[HTTP_DATE_FORMATS.length];
        MRU_HTTP_DATE_FORMATs = new MRUArray(HTTP_DATE_FORMATS);
    }

    static class MRUArray {
        private MRUObjectRef[] mruRefs;
        private Object[] objects;

        public MRUArray(Object[] mruObjects) {
            this.objects = (Object[])mruObjects.clone();
            this.mruRefs = new MRUObjectRef[mruObjects.length];
            int i = 0;
            while (i < mruObjects.length) {
                this.mruRefs[i] = new MRUObjectRef(i);
                ++i;
            }
        }

        public MRUObjectRef getMRUObjRef() {
            return this.mruRefs[0];
        }

        public class MRUObjectRef {
            private int index;
            private int referencedObjIndex;

            MRUObjectRef(int index) {
                this.index = index;
                this.referencedObjIndex = index;
            }

            int getObjectIndex() {
                return this.referencedObjIndex;
            }

            public Object getObject() {
                return MRUArray.this.objects[this.referencedObjIndex];
            }

            public MRUObjectRef next() {
                int nextIdx = this.index + 1;
                if (nextIdx < MRUArray.this.mruRefs.length) {
                    return MRUArray.this.mruRefs[nextIdx];
                }
                return null;
            }

            public void accept() {
                if (this.index == 0) {
                    return;
                }
                MRUObjectRef promoted = MRUArray.this.mruRefs[this.index];
                int i = this.index;
                while (i >= 1) {
                    ((MRUArray)MRUArray.this).mruRefs[i] = MRUArray.this.mruRefs[i - 1];
                    ((MRUArray)MRUArray.this).mruRefs[i].index = i;
                    --i;
                }
                ((MRUArray)MRUArray.this).mruRefs[0] = promoted;
                promoted.index = 0;
            }
        }
    }
}

