/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl.util;

import com.tssap.dtr.client.lib.deltavlib.impl.PropertyFactoryImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.IConvertableCachedObj;
import com.tssap.dtr.client.lib.deltavlib.impl.util.CacheablePropertyProvider;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableElement;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;

public abstract class ResourceTypeProperty
extends CacheablePropertyProvider {
    public static final String COLLECTION = "collection";
    public static final String ACTIVITY = "activity";
    public static final String BASELINE = "baseline";
    public static final String VERSION_HISTORY = "version-history";
    public static final String PRINCIPAL = "principal";
    public static final String WORKING_RESOURCE = "working-resource";
    public static final String WORKING_COLLECTION = "working-collection";
    public static final String WORKSPACE = "workspace";
    public static final IConvertableCachedObj TYPE_COLLECTION = ResourceTypeProperty.createTypeProperty("collection");
    public static final IConvertableCachedObj TYPE_ACTIVITY = ResourceTypeProperty.createTypeProperty("activity");
    public static final IConvertableCachedObj TYPE_BASELINE = ResourceTypeProperty.createTypeProperty("baseline");
    public static final IConvertableCachedObj TYPE_VERSION_HISTORY = ResourceTypeProperty.createTypeProperty("version-history");
    public static final IConvertableCachedObj TYPE_PRINCIPAL = ResourceTypeProperty.createTypeProperty("principal");
    public static final IConvertableCachedObj TYPE_FILE = CacheablePropertyProvider.createCacheableObject("DAV", DAV.RESOURCETYPE.localName, null, null);
    public static final IConvertableCachedObj TYPE_WORKING_RESOURCE = ResourceTypeProperty.createTypeProperty("working-resource");
    public static final IConvertableCachedObj TYPE_WORKING_COLLECTION = ResourceTypeProperty.createTypeProperty("working-collection");
    public static final IConvertableCachedObj TYPE_WORKSPACE = ResourceTypeProperty.createTypeProperty("workspace");
    public static final IConvertableCachedObj TYPE_COLLECTION_PRINCIPAL = ResourceTypeProperty.createPrincipalCollectionTypeProperty();

    /*
     * Unable to fully structure code
     */
    public static IConvertableCachedObj getResourceType(PropertyElement element) {
        block16: {
            resourceType = null;
            if (!"DAV:".equals(element.getNamespaceURI())) break block16;
            child = element.firstChild();
            if (child != null) ** GOTO lbl31
            return ResourceTypeProperty.TYPE_FILE;
lbl-1000:
            // 1 sources

            {
                propName = child.getName();
                if (propName.equals("collection")) {
                    resourceType = resourceType == ResourceTypeProperty.TYPE_PRINCIPAL ? ResourceTypeProperty.TYPE_COLLECTION_PRINCIPAL : ResourceTypeProperty.TYPE_COLLECTION;
                } else if (propName.equals("working-resource")) {
                    resourceType = ResourceTypeProperty.TYPE_WORKING_RESOURCE;
                } else if (propName.equals("working-collection")) {
                    resourceType = ResourceTypeProperty.TYPE_WORKING_COLLECTION;
                } else if (propName.equals("workspace")) {
                    resourceType = ResourceTypeProperty.TYPE_WORKSPACE;
                } else if (propName.equals("activity")) {
                    resourceType = ResourceTypeProperty.TYPE_ACTIVITY;
                } else if (propName.equals("version-history")) {
                    resourceType = ResourceTypeProperty.TYPE_VERSION_HISTORY;
                } else if (propName.equals("baseline")) {
                    resourceType = ResourceTypeProperty.TYPE_BASELINE;
                } else if (propName.equals("principal")) {
                    resourceType = resourceType == ResourceTypeProperty.TYPE_COLLECTION ? ResourceTypeProperty.TYPE_COLLECTION_PRINCIPAL : ResourceTypeProperty.TYPE_PRINCIPAL;
                }
                child = child.next();
lbl31:
                // 2 sources

                ** while (child != null)
            }
        }
        return resourceType;
    }

    private static IConvertableCachedObj createTypeProperty(String typeElementName) {
        return CacheablePropertyProvider.createCacheableObject("DAV", DAV.RESOURCETYPE.localName, PropertyFactoryImpl.getInstance().createDavElement(typeElementName), null);
    }

    private static IConvertableCachedObj createPrincipalCollectionTypeProperty() {
        IMutableElement children = PropertyFactoryImpl.getInstance().createDavElement(PRINCIPAL);
        children.addNextChild(PropertyFactoryImpl.getInstance().createDavElement(COLLECTION));
        IConvertableCachedObj resourceType = CacheablePropertyProvider.createCacheableObject("DAV", DAV.RESOURCETYPE.localName, children, null);
        return resourceType;
    }
}

