/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl.util;

import com.tssap.dtr.client.lib.deltavlib.IMemberIterator;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.PathUtil;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.util.IndexTree;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class MemberTree
extends IndexTree {
    static final int ROOT_KEY = -1;
    private String parentPath;
    private IResource[] members;

    public static boolean isDirectChildOfParent(String childPath, String parentPath) {
        int childStartPos = parentPath.length();
        if (parentPath.charAt(childStartPos - 1) != '/') {
            ++childStartPos;
        }
        return childPath.length() > childStartPos && childPath.charAt(childStartPos - 1) == '/' && childPath.startsWith(parentPath);
    }

    private void performDepthFirstSort() {
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                int len2;
                String path1 = ((IResource)o1).getEncodedPath();
                String path2 = ((IResource)o2).getEncodedPath();
                int len1 = path1.length();
                if (len1 == (len2 = path2.length())) {
                    return path1.equals(path2) ? 0 : 1;
                }
                if (len1 > len2) {
                    return path1.startsWith(path2) ? -1 : 1;
                }
                return path2.startsWith(path1) ? -1 : 1;
            }
        };
        Arrays.sort(this.members, comp);
    }

    private int buildSubTree(int parentIndex) throws VcmFailure {
        String currentParentPath = parentIndex == -1 ? this.parentPath : this.members[parentIndex].getEncodedPath();
        int i = parentIndex + 1;
        while (i < this.members.length) {
            if (MemberTree.isDirectChildOfParent(this.members[i].getEncodedPath(), currentParentPath)) {
                this.addChild(parentIndex, i);
                if (this.members[i].isCollection()) {
                    i = this.buildSubTree(i);
                }
            } else {
                return i - 1;
            }
            ++i;
        }
        return this.members.length;
    }

    private void writeTree(PrintStream stream, int parentKey, int depth) {
        int delta = 8;
        char[] depthAlign = new char[(depth + 1) * delta];
        Arrays.fill(depthAlign, ' ');
        int i = 0;
        while (i < depthAlign.length) {
            if (i % delta == 0) {
                depthAlign[i] = 124;
            } else if (i / delta >= depth) {
                depthAlign[i] = 46;
            }
            ++i;
        }
        IndexTree.IndexIterator it = this.getChildrenIterator(parentKey);
        if (it == null) {
            return;
        }
        boolean i2 = false;
        while (it.hasNext()) {
            int parentIndex = it.next();
            IResource resource = this.members[parentIndex];
            stream.print(depthAlign);
            stream.println(resource.getName());
            try {
                if (!resource.isCollection()) continue;
                this.writeTree(stream, parentIndex, depth + 1);
            }
            catch (VcmFailure e) {
                throw new IllegalStateException("expected intialized resource");
            }
        }
    }

    public MemberTree(IResource[] members) throws VcmFailure {
        super(-1, members.length + 1);
        this.setMembers(members);
    }

    private void setMembers(IResource[] members) throws VcmFailure {
        if (members == null) {
            throw new NullPointerException();
        }
        if (members.length > 0) {
            this.members = members;
            this.parentPath = PathUtil.getParentPath(members[0].getEncodedPath());
            this.performDepthFirstSort();
            this.buildSubTree(-1);
        } else {
            this.members = null;
            this.parentPath = null;
        }
    }

    public IMemberIterator getTopLevelMembers() {
        if (this.members == null) {
            return null;
        }
        IndexTree.IndexIterator indexIt = this.getChildrenIterator(-1);
        if (indexIt == null) {
            return null;
        }
        return new Iterator(indexIt);
    }

    public void printTree(PrintStream stream) {
        this.writeTree(stream, -1, 0);
    }

    private class Iterator
    implements IMemberIterator {
        private IndexTree.IndexIterator indexIt;
        private int currentKey = -1;

        private Iterator(IndexTree.IndexIterator memberIndexIt) {
            if (memberIndexIt == null) {
                throw new NullPointerException();
            }
            this.indexIt = memberIndexIt;
        }

        public boolean hasNext() {
            return this.indexIt.hasNext();
        }

        public IResource nextMember() {
            if (this.indexIt.hasNext()) {
                this.currentKey = this.indexIt.next();
                return MemberTree.this.members[this.currentKey];
            }
            throw new NoSuchElementException();
        }

        public IMemberIterator membersOfCurrent() {
            if (this.currentKey < 0) {
                throw new NoSuchElementException();
            }
            IndexTree.IndexIterator it = MemberTree.this.getChildrenIterator(this.currentKey);
            if (it == null) {
                return null;
            }
            return new Iterator(it);
        }

        public int memberCount() {
            return this.indexIt.count();
        }
    }
}

