/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl.util;

import java.util.NoSuchElementException;

public class IndexTree {
    int[] keys;
    char[] leftChildren;
    char[] rightSiblings;
    char nextIndex = (char)2;

    public IndexTree(int rootKey, int size) {
        this.keys = new int[size + 1];
        this.leftChildren = new char[size + 1];
        this.rightSiblings = new char[size + 1];
        this.keys[1] = rootKey;
        this.leftChildren[1] = '\u0000';
        this.rightSiblings[1] = '\u0000';
    }

    public void addChild(int parentKey, int newKey) {
        char parentIndex = this.findKey(parentKey, '\u0001');
        if (parentIndex == '\u0000') {
            throw new IllegalArgumentException("Parent key " + parentKey + " not found when adding child " + newKey + ".");
        }
        this.keys[this.nextIndex] = newKey;
        this.leftChildren[this.nextIndex] = '\u0000';
        this.rightSiblings[this.nextIndex] = '\u0000';
        if (this.leftChildren[parentIndex] == '\u0000') {
            this.leftChildren[parentIndex] = this.nextIndex;
        } else {
            char siblingIndex = this.leftChildren[parentIndex];
            while (this.rightSiblings[siblingIndex] != '\u0000') {
                siblingIndex = this.rightSiblings[siblingIndex];
            }
            this.rightSiblings[siblingIndex] = this.nextIndex;
        }
        this.nextIndex = (char)(this.nextIndex + '\u0001');
    }

    public int getParent(int childKey) {
        if (this.keys[1] == childKey) {
            return -1;
        }
        char childIndex = this.findKey(childKey, '\u0001');
        if (childIndex == '\u0000') {
            return -1;
        }
        char leftSiblingIndex = this.getLeftSiblingIndex(childIndex);
        while (leftSiblingIndex != '\u0000') {
            childIndex = leftSiblingIndex;
            leftSiblingIndex = this.getLeftSiblingIndex(childIndex);
        }
        int i = childIndex - '\u0001';
        while (i >= 0) {
            if (this.leftChildren[i] == childIndex) {
                return this.keys[i];
            }
            --i;
        }
        int i2 = childIndex + '\u0001';
        while (i2 <= this.leftChildren.length) {
            if (this.leftChildren[i2] == childIndex) {
                return this.keys[i2];
            }
            ++i2;
        }
        return -1;
    }

    public int getChild(int parentKey, int index) {
        char parentIndex = this.findKey(parentKey, '\u0001');
        if (parentIndex == '\u0000') {
            return -1;
        }
        char siblingIndex = this.leftChildren[parentIndex];
        if (siblingIndex == '\uffffffff') {
            return -1;
        }
        int i = index;
        while (i > 0) {
            if ((siblingIndex = this.rightSiblings[siblingIndex]) == '\u0000') {
                return -1;
            }
            --i;
        }
        return this.keys[siblingIndex];
    }

    public int getChildCount(int parentKey) {
        int count = 0;
        char parentIndex = this.findKey(parentKey, '\u0001');
        if (parentIndex == '\u0000') {
            return 0;
        }
        char siblingIndex = this.leftChildren[parentIndex];
        while (siblingIndex != '\u0000') {
            ++count;
            siblingIndex = this.rightSiblings[siblingIndex];
        }
        return count;
    }

    public int[] getChildren(int parentKey) {
        int childCount = this.getChildCount(parentKey);
        if (childCount == 0) {
            return new int[0];
        }
        int[] children = new int[childCount];
        int i = 0;
        char parentIndex = this.findKey(parentKey, '\u0001');
        char siblingIndex = this.leftChildren[parentIndex];
        while (siblingIndex != '\u0000') {
            children[i] = this.keys[siblingIndex];
            ++i;
            siblingIndex = this.rightSiblings[siblingIndex];
        }
        return children;
    }

    public IndexIterator getChildrenIterator(int parentKey) {
        final int childCount = this.getChildCount(parentKey);
        if (childCount == 0) {
            return null;
        }
        final char parentIndex = this.findKey(parentKey, '\u0001');
        IndexIterator it = new IndexIterator(){
            private char childIndex;
            {
                this.childIndex = IndexTree.this.leftChildren[parentIndex];
            }

            public boolean hasNext() {
                return this.childIndex != '\u0000';
            }

            public int count() {
                return childCount;
            }

            public int next() {
                if (this.childIndex != '\u0000') {
                    int returnIndex = IndexTree.this.keys[this.childIndex];
                    this.childIndex = IndexTree.this.rightSiblings[this.childIndex];
                    return returnIndex;
                }
                throw new NoSuchElementException();
            }
        };
        return it;
    }

    /*
     * Unable to fully structure code
     */
    public int getIndexOfChild(int parentKey, int childKey) {
        parentIndex = this.findKey(parentKey, '\u0001');
        index = 0;
        siblingIndex = this.leftChildren[parentIndex];
        if (siblingIndex != '\u0000') ** GOTO lbl9
        return -1;
lbl-1000:
        // 1 sources

        {
            ++index;
            if ((siblingIndex = this.rightSiblings[siblingIndex]) != '\u0000') continue;
            return -1;
lbl9:
            // 2 sources

            ** while (this.keys[siblingIndex] != childKey)
        }
lbl10:
        // 1 sources

        return index;
    }

    public int getDepth(int key) {
        int[] depth = new int[]{0};
        if (this.findDepth(key, '\u0001', depth) == '\u0000') {
            return -1;
        }
        return depth[0];
    }

    public int[] getRecursiveChildren(int parentKey) {
        char startIndex = this.findKey(parentKey, '\u0001');
        int[] depthKeys = new int[this.nextIndex - '\u0001'];
        int cursor = 0;
        char siblingIndex = this.leftChildren[startIndex];
        while (siblingIndex != '\u0000') {
            cursor = this.fillDepthKeys(siblingIndex, depthKeys, cursor);
            siblingIndex = this.rightSiblings[siblingIndex];
        }
        int[] dKeys = new int[cursor];
        int i = 0;
        while (i < cursor) {
            dKeys[i] = depthKeys[i];
            ++i;
        }
        return dKeys;
    }

    public boolean isLeaf(int key) {
        char keyIndex = this.findKey(key, '\u0001');
        if (keyIndex == '\u0000') {
            return false;
        }
        return this.leftChildren[keyIndex] == '\u0000';
    }

    public int[] keys() {
        int[] k = new int[this.nextIndex - '\u0001'];
        int i = 0;
        while (i < k.length) {
            k[i] = this.keys[i];
            ++i;
        }
        return k;
    }

    private char findKey(int value, char startIndex) {
        if (startIndex == '\u0000') {
            return '\u0000';
        }
        if (this.keys[startIndex] == value) {
            return startIndex;
        }
        char siblingIndex = this.leftChildren[startIndex];
        while (siblingIndex != '\u0000') {
            char recursiveIndex = this.findKey(value, siblingIndex);
            if (recursiveIndex != '\u0000') {
                return recursiveIndex;
            }
            siblingIndex = this.rightSiblings[siblingIndex];
        }
        return '\u0000';
    }

    private char findDepth(int value, char startIndex, int[] depth) {
        if (startIndex == '\u0000') {
            return '\u0000';
        }
        if (this.keys[startIndex] == value) {
            return startIndex;
        }
        char siblingIndex = this.leftChildren[startIndex];
        while (siblingIndex != '\u0000') {
            depth[0] = depth[0] + 1;
            char recursiveIndex = this.findDepth(value, siblingIndex, depth);
            if (recursiveIndex != '\u0000') {
                return recursiveIndex;
            }
            depth[0] = depth[0] - 1;
            siblingIndex = this.rightSiblings[siblingIndex];
        }
        return '\u0000';
    }

    private int fillDepthKeys(char startIndex, int[] depthKeys, int cursor) {
        depthKeys[cursor] = this.keys[startIndex];
        ++cursor;
        char siblingIndex = this.leftChildren[startIndex];
        while (siblingIndex != '\u0000') {
            cursor = this.fillDepthKeys(siblingIndex, depthKeys, cursor);
            siblingIndex = this.rightSiblings[siblingIndex];
        }
        return cursor;
    }

    private char getLeftSiblingIndex(char index) {
        int i = index - '\u0001';
        while (i >= 0) {
            if (this.rightSiblings[i] == index) {
                return (char)i;
            }
            --i;
        }
        int i2 = index + '\u0001';
        while (i2 < this.rightSiblings.length) {
            if (this.rightSiblings[i2] == index) {
                return (char)i2;
            }
            ++i2;
        }
        return '\u0000';
    }

    public static interface IndexIterator {
        public boolean hasNext();

        public int next();

        public int count();
    }
}

