/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl.util;

import com.tssap.dtr.client.lib.deltavlib.ForkPolicy;
import com.tssap.dtr.client.lib.deltavlib.impl.PropertyFactoryImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.IConvertableCachedObj;
import com.tssap.dtr.client.lib.deltavlib.impl.util.CacheablePropertyProvider;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import java.util.Hashtable;

public abstract class ForkPolicyProperty
extends CacheablePropertyProvider {
    public static final IConvertableCachedObj CHECKIN_FORK_FORBIDDEN = ForkPolicyProperty.createCheckinForkProperty(ForkPolicy.FORBIDDEN.getName());
    public static final IConvertableCachedObj CHECKIN_FORK_DISCOURAGED = ForkPolicyProperty.createCheckinForkProperty(ForkPolicy.DISCOURAGED.getName());
    public static final IConvertableCachedObj CHECKIN_FORK_OK = ForkPolicyProperty.createCheckinForkProperty(ForkPolicy.FORK_OK.getName());
    public static final IConvertableCachedObj CHECKOUT_FORK_FORBIDDEN = ForkPolicyProperty.createCheckoutForkProperty(ForkPolicy.FORBIDDEN.getName());
    public static final IConvertableCachedObj CHECKOUT_FORK_DISCOURAGED = ForkPolicyProperty.createCheckoutForkProperty(ForkPolicy.FORBIDDEN.getName());
    public static final IConvertableCachedObj CHECKOUT_FORK_OK = ForkPolicyProperty.createCheckoutForkProperty(ForkPolicy.FORK_OK.getName());
    private static final Hashtable FORK_NAME_TO_CI_PROPERTY = new Hashtable(5);
    private static final Hashtable FORK_NAME_TO_CO_PROPERTY = new Hashtable(5);

    private static IConvertableCachedObj createCheckinForkProperty(String forkType) {
        return CacheablePropertyProvider.createCacheableObject("DAV", DAV.CHECKIN_FORK.localName, PropertyFactoryImpl.getInstance().createDavElement(forkType), null);
    }

    private static IConvertableCachedObj createCheckoutForkProperty(String forkType) {
        return CacheablePropertyProvider.createCacheableObject("DAV", DAV.CHECKOUT_FORK.localName, PropertyFactoryImpl.getInstance().createDavElement(forkType), null);
    }

    private ForkPolicyProperty() {
    }

    public static IConvertableCachedObj getCachedForkPolicy(PropertyElement element) {
        Object resourceType = null;
        String forkPropertyName = element.getName();
        Element child = element.firstChild();
        if (child == null || element.countChildren() > 1) {
            return null;
        }
        if ("DAV:".equals(element.getNamespaceURI())) {
            String forkTypeName = child.getName();
            if (DAV.CHECKIN_FORK.localName.equals(forkPropertyName)) {
                return (IConvertableCachedObj)FORK_NAME_TO_CI_PROPERTY.get(forkTypeName);
            }
            if (DAV.CHECKOUT_FORK.localName.equals(forkPropertyName)) {
                return (IConvertableCachedObj)FORK_NAME_TO_CO_PROPERTY.get(forkTypeName);
            }
        }
        return null;
    }

    public static int getForkPolicyIntEnumByName(String forkName) {
        if (forkName == null) {
            throw new NullPointerException("null fork policy");
        }
        if (ForkPolicy.FORK_OK.getName().equals(forkName)) {
            return 1;
        }
        if (ForkPolicy.FORBIDDEN.getName().equals(forkName)) {
            return 4;
        }
        if (ForkPolicy.DISCOURAGED.getName().equals(forkName)) {
            return 2;
        }
        return 1;
    }

    public static String getForkPolicyByIntEnum(int forkPolicy) {
        if (forkPolicy == 1) {
            return ForkPolicy.FORK_OK.getName();
        }
        if (4 == forkPolicy) {
            return ForkPolicy.FORBIDDEN.getName();
        }
        if (2 == forkPolicy) {
            return ForkPolicy.DISCOURAGED.getName();
        }
        return ForkPolicy.FORK_OK.getName();
    }

    static {
        FORK_NAME_TO_CI_PROPERTY.put(ForkPolicy.FORK_OK.getName(), CHECKIN_FORK_OK);
        FORK_NAME_TO_CI_PROPERTY.put(ForkPolicy.FORBIDDEN.getName(), CHECKIN_FORK_FORBIDDEN);
        FORK_NAME_TO_CI_PROPERTY.put(ForkPolicy.DISCOURAGED.getName(), CHECKIN_FORK_DISCOURAGED);
        FORK_NAME_TO_CO_PROPERTY.put(ForkPolicy.FORK_OK.getName(), CHECKOUT_FORK_OK);
        FORK_NAME_TO_CO_PROPERTY.put(ForkPolicy.FORBIDDEN.getName(), CHECKOUT_FORK_FORBIDDEN);
        FORK_NAME_TO_CO_PROPERTY.put(ForkPolicy.DISCOURAGED.getName(), CHECKOUT_FORK_DISCOURAGED);
    }
}

