/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl.util;

import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.factory.PropertyFactoryAccess;
import com.tssap.dtr.client.lib.deltavlib.properties.IElement;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableElement;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyFactory;
import com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixBindingException;
import com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;

public abstract class DataUtil {
    private DataUtil() {
    }

    public static String[] getAsHrefs(IResource[] resources) {
        if (resources == null) {
            throw new NullPointerException();
        }
        String[] hrefs = new String[resources.length];
        int i = 0;
        while (i < resources.length) {
            if (resources[i] == null) {
                throw new NullPointerException();
            }
            hrefs[i] = resources[i].getEncodedPath();
            ++i;
        }
        return hrefs;
    }

    public static IProperty protocolToApiProperty(PropertyElement property) {
        IPropertyFactory propertyFactory = PropertyFactoryAccess.getFactory();
        String nsURI = property.getNamespaceURI();
        String nsPrefix = NSPrefixToUriMap.getOrGeneratePrefixForUri(nsURI);
        IMutableProperty apiProp = propertyFactory.createProperty(nsPrefix, property.getName());
        if (property.firstChild() != null) {
            Element child = property.firstChild();
            while (child != null) {
                apiProp.addNextChild(DataUtil.protocolToApiElement(child));
                child = child.next();
            }
        } else {
            apiProp.setValue(property.getValue());
        }
        return apiProp;
    }

    public static IMutableElement protocolToApiElement(Element property) {
        IPropertyFactory propertyFactory = PropertyFactoryAccess.getFactory();
        String nsURI = property.getNamespaceURI();
        String nsPrefix = NSPrefixToUriMap.getOrGeneratePrefixForUri(nsURI);
        IMutableElement apiElement = propertyFactory.createElement(nsPrefix, property.getName());
        if (property.firstChild() != null) {
            Element child = property.firstChild();
            while (child != null) {
                apiElement.addNextChild(DataUtil.protocolToApiElement(child));
                child = child.next();
            }
        } else {
            apiElement.setValue(property.getValue());
        }
        return apiElement;
    }

    public static Element apiToProtocolElement(IElement apiElement, StringBuffer buf, INSPrefixResolver nsPrefixResolver) throws NSPrefixBindingException {
        StringBuffer tempBuf = buf != null ? buf : new StringBuffer();
        tempBuf.setLength(0);
        String nsPrefix = apiElement.getNamespace();
        if (nsPrefix != null) {
            tempBuf.append(nsPrefix).append(':');
        } else {
            tempBuf.append("DAV:");
        }
        tempBuf.append(apiElement.getName());
        String qualifiedName = tempBuf.toString();
        String nsUri = null;
        nsUri = nsPrefixResolver != null ? nsPrefixResolver.onNamespacePrefix(nsPrefix) : PropertyUtil.getNamespaceURI(qualifiedName);
        Element element = new Element(qualifiedName, nsUri);
        if (apiElement.getFirstChild() == null) {
            element.setValue(apiElement.getValue());
        } else {
            IElement child = apiElement.getFirstChild();
            while (child != null) {
                element.addChild(DataUtil.apiToProtocolElement(child, tempBuf, nsPrefixResolver));
                child = child.getNext();
            }
        }
        return element;
    }

    public static Element apiToProtocolElement(IElement apiElement, StringBuffer buf) {
        try {
            return DataUtil.apiToProtocolElement(apiElement, buf, null);
        }
        catch (NSPrefixBindingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static PropertyElement apiToProtocolProperty(IProperty apiProp, StringBuffer buf, INSPrefixResolver nsPrefixResolver) throws NSPrefixBindingException {
        StringBuffer tempBuf = buf != null ? buf : new StringBuffer();
        tempBuf.setLength(0);
        String nsPrefix = apiProp.getNamespace();
        if (nsPrefix != null) {
            tempBuf.append(nsPrefix).append(':');
        } else {
            tempBuf.append("DAV:");
        }
        tempBuf.append(apiProp.getName());
        String qualifiedName = tempBuf.toString();
        String nsUri = null;
        if (nsPrefixResolver != null) {
            nsUri = nsPrefixResolver.onNamespacePrefix(nsPrefix);
            if (nsUri == null) {
                throw new NSPrefixBindingException("Namespace prefix: " + nsPrefix + " is not bound to uri");
            }
        } else {
            nsUri = PropertyUtil.getNamespaceURI(qualifiedName);
        }
        PropertyElement prop = new PropertyElement(qualifiedName, nsUri);
        prop.setStatusCode(200);
        if (apiProp.getFirstChild() == null) {
            prop.setValue(apiProp.getValue());
        } else {
            IElement child = apiProp.getFirstChild();
            while (child != null) {
                prop.addChild(DataUtil.apiToProtocolElement(child, tempBuf, nsPrefixResolver));
                child = child.getNext();
            }
        }
        return prop;
    }

    public static PropertyElement apiToProtocolProperty(IProperty apiProp, StringBuffer buf) {
        try {
            return DataUtil.apiToProtocolProperty(apiProp, buf, null);
        }
        catch (NSPrefixBindingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static void checkArrayForNull(Object[] objs) {
        if (objs == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (i < objs.length) {
            if (objs[i] == null) {
                throw new NullPointerException();
            }
            ++i;
        }
    }

    public static interface INSPrefixResolver {
        public String onNamespacePrefix(String var1);
    }
}

