/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl.util;

import com.tssap.dtr.client.lib.deltavlib.impl.PropertyFactoryImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.IConvertableCachedObj;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyFormatException;
import java.util.Date;

public class CacheableDate
extends PropertyFactoryImpl
implements IConvertableCachedObj {
    private String httpDateStr;
    private Date date;

    public CacheableDate(String httpDateStr) throws PropertyFormatException {
        this.httpDateStr = httpDateStr;
        if (!this.parseRawDate(httpDateStr)) {
            this.date = Converter.parseHTTPDate(httpDateStr);
            if (this.date == null) {
                throw new PropertyFormatException("Failed to parse HTTP date property value");
            }
        }
    }

    public IProperty toProperty(String namespace, String name) {
        return this.createStringProperty(namespace, name, this.httpDateStr);
    }

    public Date getDateObject() {
        return this.date;
    }

    public String getHttpDateStr() {
        return this.httpDateStr;
    }

    public String toString() {
        return this.httpDateStr;
    }

    private boolean parseRawDate(String s) {
        if (s == null) {
            return false;
        }
        int radix = 10;
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max > 0) {
            int digit;
            long limit;
            if (s.charAt(0) == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            long multmin = limit / 10L;
            if (i < max) {
                if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                    return false;
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                    return false;
                }
                if (result < multmin) {
                    return false;
                }
                if ((result *= 10L) < limit + (long)digit) {
                    return false;
                }
                result -= (long)digit;
            }
        } else {
            return false;
        }
        if (negative) {
            if (i > 1) {
                this.date = new Date(result);
                return true;
            }
            return false;
        }
        this.date = new Date(-result);
        return true;
    }
}

