/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl.util;

import com.tssap.dtr.client.lib.deltavlib.impl.PropertyFactoryImpl;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IElement;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyFactory;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import java.util.Hashtable;
import java.util.Map;

public abstract class AutoversionProperty {
    private static final Map AUTO_VERSION_ENUM_MAP = new Hashtable();
    public static final String CHECKOUT_CHECKIN = "checkout-checkin";
    public static final String CHECKOUT_UNLOCKED_CHECKIN = "checkout-unlocked-checkin";
    public static final String CHECKOUT = "checkout";
    public static final String LOCKED_CHECKOUT = "locked-checkout";
    public static final IProperty AUTOVERSION_CHECKOUT_CHECKIN = AutoversionProperty.createAutoVersionProperty("checkout-checkin", 1);
    public static final IProperty AUTOVERSION_CHECKOUT_UNLOCKED_CHECKIN = AutoversionProperty.createAutoVersionProperty("checkout-unlocked-checkin", 3);
    public static final IProperty AUTOVERSION_CHECKOUT = AutoversionProperty.createAutoVersionProperty("checkout", 2);
    public static final IProperty AUTOVERSION_LOCKED_CHECKOUT = AutoversionProperty.createAutoVersionProperty("locked-checkout", 4);

    public static IProperty getAutoversionPolicy(PropertyElement element) {
        IProperty resourceType = null;
        if ("DAV:".equals(element.getNamespaceURI()) && DAV.AUTO_VERSION.localName.equals(element.getName())) {
            Element child = element.firstChild();
            if (child == null || element.countChildren() > 1) {
                return null;
            }
            String childElementName = child.getName();
            if (childElementName.equals(CHECKOUT_CHECKIN)) {
                resourceType = AUTOVERSION_CHECKOUT_CHECKIN;
            } else if (childElementName.equals(CHECKOUT)) {
                resourceType = AUTOVERSION_CHECKOUT;
            } else if (childElementName.equals(CHECKOUT_UNLOCKED_CHECKIN)) {
                resourceType = AUTOVERSION_CHECKOUT_UNLOCKED_CHECKIN;
            } else if (childElementName.equals(LOCKED_CHECKOUT)) {
                resourceType = AUTOVERSION_LOCKED_CHECKOUT;
            }
        }
        return resourceType;
    }

    public static int autoVersionToEnumInt(IProperty autoVerElement) {
        IElement child = autoVerElement.getFirstChild();
        if (child == null) {
            return 0;
        }
        String autoVerElementName = child.getName();
        if (AUTOVERSION_CHECKOUT_CHECKIN.getName().equals(autoVerElementName)) {
            return 1;
        }
        if (AUTOVERSION_CHECKOUT_UNLOCKED_CHECKIN.getName().equals(autoVerElement)) {
            return 3;
        }
        if (AUTOVERSION_LOCKED_CHECKOUT.getName().equals(autoVerElement)) {
            return 4;
        }
        if (AUTOVERSION_CHECKOUT.getName().equals(autoVerElement)) {
            return 2;
        }
        return 0;
    }

    public static IProperty getAutoVersionFromEnumInt(int autoVersionPolicy) {
        Object autoverProp = AUTO_VERSION_ENUM_MAP.get(new Integer(autoVersionPolicy));
        return autoverProp != null ? (IProperty)autoverProp : null;
    }

    private static IProperty createAutoVersionProperty(String name, int enumInt) {
        IPropertyFactory propFy = PropertyFactoryImpl.getInstance();
        IMutableProperty prop = propFy.createDavProperty(DAV.AUTO_VERSION.localName);
        prop.addNextChild(propFy.createDavElement(name));
        AUTO_VERSION_ENUM_MAP.put(new Integer(enumInt), prop);
        return prop;
    }
}

