/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl.cache;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.IPropertyCache;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.IPropertyCacheHandler;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.ISelectivePropertyLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.util.DataUtil;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyCacheControl;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HashmapPropCache
extends HashMap
implements IPropertyCache,
IPropertyCacheControl {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$impl$cache$HashmapPropCache == null ? (class$com$tssap$dtr$client$lib$deltavlib$impl$cache$HashmapPropCache = HashmapPropCache.class$("com.tssap.dtr.client.lib.deltavlib.impl.cache.HashmapPropCache")) : class$com$tssap$dtr$client$lib$deltavlib$impl$cache$HashmapPropCache));
    private static final Object UNDEF_VALUE = new Object();
    private static final Object NOT_FOUND = new Object();
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$impl$cache$HashmapPropCache;

    private HashmapPropCache() {
    }

    private HashmapPropCache(IPropertyNameIterator initialPropeties) {
        while (initialPropeties.hasNext()) {
            this.setPropertyUndefined(initialPropeties.next());
        }
    }

    private void createPropertyInCache(PropertyElement property, IPropertyCacheHandler handler) {
        String uri = property.getNamespaceURI();
        String prefix = NSPrefixToUriMap.getPrefixForUri(uri);
        String key = prefix != null ? prefix + ":" + property.getName() : uri + property.getName();
        Object val = null;
        if (property.getStatusCode() != 200) {
            val = NOT_FOUND;
        } else {
            val = handler.convertToCachedObject(property);
            if (val == null) {
                val = IPropertyCacheHandler.NULL_PROPERTY_VALUE;
            }
        }
        this.put(key, val);
    }

    private void setPropertyUndefined(String propertyName) {
        String qualifiedName = propertyName;
        if (propertyName.indexOf(58) < 0) {
            qualifiedName = "DAV:" + propertyName;
        }
        this.put(qualifiedName, UNDEF_VALUE);
    }

    public Object put(Object key, Object value) {
        if (key instanceof String) {
            key = ((String)key).intern();
        }
        if (value instanceof String) {
            value = ((String)value).intern();
        }
        return super.put(key, value);
    }

    private boolean findCachedProperties(String[] propertyNames, IProperty[] propObjects, IPropertyCacheHandler handler) {
        Object value = null;
        String namespace = null;
        String baseName = null;
        String qualifiedName = null;
        boolean needsRefresh = false;
        int resultIdx = 0;
        int i = 0;
        while (i < propertyNames.length) {
            qualifiedName = propertyNames[i];
            namespace = PropertyUtil.getNamespacePrefix(qualifiedName);
            baseName = PropertyUtil.getLocalName(qualifiedName);
            if (namespace == null) {
                qualifiedName = "DAV:" + baseName;
            }
            if (null == (value = this.get(qualifiedName))) {
                handler.uncachedPropertyAccess(qualifiedName);
                needsRefresh = true;
                this.setPropertyUndefined(qualifiedName);
            } else if (value == UNDEF_VALUE) {
                needsRefresh = true;
            } else if (value != NOT_FOUND) {
                propObjects[resultIdx++] = handler.convertFromCachedObject(namespace, baseName, value);
            }
            ++i;
        }
        return !needsRefresh;
    }

    public static IPropertyCache createInstance(IPropertyNameIterator initialProperties) {
        return new HashmapPropCache(initialProperties);
    }

    public static IPropertyCache createInstance(Iterator protocolPropertyIt, IPropertyCacheHandler handler) {
        HashmapPropCache cache = new HashmapPropCache();
        while (protocolPropertyIt.hasNext()) {
            cache.createPropertyInCache((PropertyElement)protocolPropertyIt.next(), handler);
        }
        return cache;
    }

    public Object getPropertyValue(String propertyName, IPropertyCacheHandler handler) throws VcmFailure {
        Object val;
        String qualifiedName = propertyName;
        if (propertyName.indexOf(58) < 0) {
            qualifiedName = "DAV:" + propertyName;
        }
        if (null == (val = this.get(qualifiedName))) {
            handler.uncachedPropertyAccess(propertyName);
            this.put(qualifiedName, UNDEF_VALUE);
            val = UNDEF_VALUE;
        }
        if (UNDEF_VALUE == val) {
            this.refresh(handler);
            val = this.get(qualifiedName);
            if (val == UNDEF_VALUE) {
                VcmFailure e = new VcmFailure("client internal error");
                LogUtil.logException((Location)LOC, (Throwable)e);
                throw e;
            }
        }
        if (val == NOT_FOUND) {
            return null;
        }
        return val;
    }

    public void refresh(IPropertyCacheHandler handler) throws VcmFailure {
        if (this.isEmpty()) {
            return;
        }
        Iterator propNames = this.keySet().iterator();
        ISelectivePropertyLoader loader = handler.getPropertyLoader();
        while (propNames.hasNext()) {
            loader.addPropertyToLoad((String)propNames.next());
        }
        Iterator newProperties = loader.load();
        this.clear();
        PropertyElement nextProp = null;
        while (newProperties.hasNext()) {
            nextProp = (PropertyElement)newProperties.next();
            this.storeProperty(nextProp, handler);
        }
    }

    public void clearProperty(String propertyName) {
        if (propertyName.indexOf(58) < 0) {
            this.remove("DAV:" + propertyName);
        } else {
            this.remove(propertyName);
        }
    }

    public Object checkPropertyValue(String propertyName) {
        String qualifiedName = null;
        qualifiedName = propertyName.indexOf(58) < 0 ? "DAV:" + propertyName : propertyName;
        Object val = this.get(qualifiedName);
        if (UNDEF_VALUE == val || NOT_FOUND == val || IPropertyCacheHandler.NULL_PROPERTY_VALUE == val) {
            return null;
        }
        return val;
    }

    public void storeProperty(PropertyElement property, IPropertyCacheHandler handler) {
        String uri = property.getNamespaceURI();
        String prefix = NSPrefixToUriMap.getPrefixForUri(uri);
        String key = prefix != null ? prefix + ":" + property.getName() : uri + property.getName();
        Object val = null;
        if (property.getStatusCode() != 200) {
            val = NOT_FOUND;
        } else {
            val = handler.convertToCachedObject(property);
            if (val == null) {
                val = IPropertyCacheHandler.NULL_PROPERTY_VALUE;
            }
        }
        Object prevObj = this.put(key, val);
    }

    public IProperty[] getPropertyObjects(String[] properyNames, IPropertyCacheHandler handler) throws VcmFailure {
        Object[] resultProp = new IProperty[properyNames.length];
        boolean needsRefresh = this.findCachedProperties(properyNames, (IProperty[])resultProp, handler);
        if (!needsRefresh) {
            this.refresh(handler);
        }
        this.findCachedProperties(properyNames, (IProperty[])resultProp, handler);
        if (resultProp.length > 0 && resultProp[resultProp.length - 1] == null) {
            Arrays.fill(resultProp, null);
            this.findCachedProperties(properyNames, (IProperty[])resultProp, handler);
            int resultEndPos = resultProp.length - 1;
            while (resultEndPos >= 0 && null == resultProp[resultEndPos]) {
                --resultEndPos;
            }
            IProperty[] shrunkResult = new IProperty[resultEndPos + 1];
            System.arraycopy(resultProp, 0, shrunkResult, 0, shrunkResult.length);
            resultProp = shrunkResult;
        }
        return resultProp;
    }

    public int getSize() {
        return this.size();
    }

    public void setDirectCachedValue(String propertyName, Object val) {
        Object valToSet = val == null ? IPropertyCacheHandler.NULL_PROPERTY_VALUE : val;
        String qualifiedName = propertyName;
        if (propertyName.indexOf(58) < 0) {
            qualifiedName = "DAV:" + propertyName;
        }
        this.put(qualifiedName, valToSet);
    }

    public void addPropertyToCache(String propertyName) {
        Object prev;
        if (propertyName == null) {
            throw new NullPointerException();
        }
        String qualifiedName = propertyName;
        if (propertyName.indexOf(58) < 0) {
            qualifiedName = "DAV:" + propertyName;
        }
        if (null != (prev = this.put(qualifiedName, UNDEF_VALUE)) && UNDEF_VALUE != prev) {
            this.put(qualifiedName, prev);
        }
    }

    public void clearAll() {
        this.clear();
    }

    public String[] getPropertiesToCache() {
        return this.keySet().toArray(new String[this.size()]);
    }

    public int getPropertyState(String propertyName) {
        Object val = null;
        val = propertyName.indexOf(58) < 0 ? this.get("DAV:" + propertyName) : this.get(propertyName);
        if (NOT_FOUND == val) {
            return 2;
        }
        if (UNDEF_VALUE == val) {
            return 3;
        }
        if (val == null) {
            return 4;
        }
        return 1;
    }

    public IPropertyCacheControl getCacheControl() {
        return this;
    }

    public void setPropertiesToCache(String[] propertyNames) {
        DataUtil.checkArrayForNull(propertyNames);
        String[] qualifiedNames = propertyNames;
        int i = 0;
        while (i < propertyNames.length) {
            if (propertyNames[i].indexOf(58) < 0) {
                if (propertyNames[i] == qualifiedNames[i]) {
                    qualifiedNames = (String[])qualifiedNames.clone();
                }
                qualifiedNames[i] = "DAV:" + propertyNames[i];
            }
            ++i;
        }
        this.keySet().retainAll(Arrays.asList(qualifiedNames));
        int i2 = 0;
        while (i2 < qualifiedNames.length) {
            if (this.get(qualifiedNames[i2]) == null) {
                this.put(qualifiedNames[i2], UNDEF_VALUE);
            }
            ++i2;
        }
    }

    public void resetProperty(String propertyName) {
        this.setPropertyUndefined(propertyName);
    }

    public void resetAllProperties() {
        Iterator propIt = this.entrySet().iterator();
        while (propIt.hasNext()) {
            Map.Entry nextEntry = propIt.next();
            nextEntry.setValue(UNDEF_VALUE);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

