/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.IAssociatedResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IFile;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkingResource;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.AbstractResource;
import com.tssap.dtr.client.lib.deltavlib.impl.ActivityContentMemberImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.VersionImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.VersionRelationFactory;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.IConvertableCachedObj;
import com.tssap.dtr.client.lib.deltavlib.impl.util.ForkPolicyProperty;
import com.tssap.dtr.client.lib.deltavlib.impl.util.PropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICreatedResource;
import com.tssap.dtr.client.lib.deltavlib.xcm.VersionRelation;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.CheckinRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyReport;
import com.tssap.dtr.client.lib.protocol.util.Encoder;

class WorkingResourceImpl
extends ActivityContentMemberImpl
implements IWorkingResource,
ICreatedResource {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$impl$WorkingResourceImpl == null ? (class$com$tssap$dtr$client$lib$deltavlib$impl$WorkingResourceImpl = WorkingResourceImpl.class$("com.tssap.dtr.client.lib.deltavlib.impl.WorkingResourceImpl")) : class$com$tssap$dtr$client$lib$deltavlib$impl$WorkingResourceImpl));
    private String m_checkedOutVersionPath = null;
    private boolean m_isWorkingResource = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$impl$WorkingResourceImpl;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$IWorkingResource;

    WorkingResourceImpl(int conTemplID, String encodedPath) throws InvalidPathException {
        super(conTemplID, encodedPath);
    }

    WorkingResourceImpl(ActivityContentMemberImpl resource) {
        super(resource);
    }

    protected IPropertyNameIterator getInitialPropertyNames() {
        IPropertyNameIterator propNameIt = AbstractResource.PROPERTY_MANAGER.getResourceCachedProperties(class$com$tssap$dtr$client$lib$deltavlib$IWorkingResource == null ? (class$com$tssap$dtr$client$lib$deltavlib$IWorkingResource = WorkingResourceImpl.class$("com.tssap.dtr.client.lib.deltavlib.IWorkingResource")) : class$com$tssap$dtr$client$lib$deltavlib$IWorkingResource);
        if (propNameIt == null) {
            return PropertyNameIterator.EMPTY_ITERATOR;
        }
        return propNameIt;
    }

    public IConvertableCachedObj onSetNonPrimitiveCachedProperty(PropertyElement property) {
        String propertyName = property.getName();
        String namespaceURI = property.getNamespaceURI();
        if ((DAV.CHECKOUT_FORK.localName.equals(propertyName) || DAV.CHECKIN_FORK.localName.equals(propertyName)) && "DAV:".equals(namespaceURI)) {
            return ForkPolicyProperty.getCachedForkPolicy(property);
        }
        return null;
    }

    public IVersion getCheckedOut() throws VcmFailure {
        String verHref = this.getPropertyHrefValue(DAV.CHECKED_OUT.qualifiedName);
        if (verHref == null) {
            return null;
        }
        IResourceFactory pxyFactory = this.getResourceFactoryManager().getProxyFactory();
        return pxyFactory.createVersion(this.getConnectionTemplID(), verHref, PathEncodingFlag.ENCODED);
    }

    public String getXCMPath() throws VcmFailure {
        return this.getPropertyStringValue(XCM.PATH.qualifiedName);
    }

    public String getXCMDecodedPath() throws VcmFailure {
        return this.getPropertyStringValue(XCM.PATH.qualifiedName);
    }

    public String getXCMEncodedPath() throws VcmFailure {
        String path = this.getPropertyStringValue(XCM.PATH.qualifiedName);
        return path != null ? Encoder.encodePath((String)path) : null;
    }

    public IVersion[] getPredecessorSet() throws VcmFailure {
        IAssociatedResourceFactory factory = this.getResourceFactoryManager().getAssocFactory();
        return factory.createVersionsFromReference(this, DAV.PREDECESSOR_SET.qualifiedName);
    }

    public int getCheckinFork() throws VcmFailure {
        IProperty fork = this.getProperty(DAV.CHECKIN_FORK.qualifiedName);
        if (fork != null && fork.getFirstChild() != null) {
            String forkPolicyName = fork.getFirstChild().getName();
            return ForkPolicyProperty.getForkPolicyIntEnumByName(forkPolicyName);
        }
        return 1;
    }

    public void setCheckinFork(int forkType) throws VcmFailure {
        String forkTypeName = ForkPolicyProperty.getForkPolicyByIntEnum(forkType);
        if (forkTypeName == null) {
            throw new VcmFailure("Invalid checkin fork type");
        }
        IMutableProperty forkTypeProp = AbstractResource.PROPERTY_FACTORY.createProperty(DAV.CHECKIN_FORK.namespacePrefix, DAV.CHECKIN_FORK.localName);
        forkTypeProp.setValue(forkTypeName);
        this.setProperties(new IProperty[]{forkTypeProp});
    }

    public int getCheckoutFork() throws VcmFailure {
        IProperty fork = this.getProperty(DAV.CHECKOUT_FORK.qualifiedName);
        if (fork != null && fork.getFirstChild() != null) {
            String forkPolicyName = fork.getFirstChild().getName();
            return ForkPolicyProperty.getForkPolicyIntEnumByName(forkPolicyName);
        }
        return 1;
    }

    public IVersion[] getMergeSet() throws VcmFailure {
        IAssociatedResourceFactory factory = this.getResourceFactoryManager().getAssocFactory();
        return factory.createVersionsFromReference(this, "merge-set");
    }

    public IVersion[] getAutoMergeSet() throws VcmFailure {
        IAssociatedResourceFactory factory = this.getResourceFactoryManager().getAssocFactory();
        return factory.createVersionsFromReference(this, "auto-merge-set");
    }

    public void confirmMerge() {
        throw new UnsupportedOperationException("not imlemented");
    }

    public IActivity[] getActivitySet() throws VcmFailure {
        IAssociatedResourceFactory factory = this.getResourceFactoryManager().getAssocFactory();
        return factory.createActivitiesFromReference(this, "activity-set");
    }

    public void setUnreserved(boolean unreserved) throws VcmFailure {
        this.setProperty(DAV.UNRESERVED.qualifiedName, Converter.booleanToString(unreserved));
    }

    public boolean getUnreserved() throws VcmFailure {
        Boolean bool = this.getPropertyBooleanValue(DAV.UNRESERVED.qualifiedName);
        return bool != null ? bool : false;
    }

    public void checkin(int flags) throws VcmFailure {
        CheckinRequest ci = new CheckinRequest(this.getEncodedPath());
        ci.setAllowForks((flags & 2) != 0);
        ci.setKeepCheckedOut((flags & 1) != 0);
        this.executeRequest((IRequest)ci);
    }

    public void uncheckout() throws VcmFailure {
        this.remove();
    }

    public IVersionControlledResource getUpdatedResource() throws VcmFailure {
        String vcrHref = this.getPropertyHrefValue(DAV.AUTO_UPDATE.qualifiedName);
        if (vcrHref != null) {
            IResourceFactory pxyFactory = this.getResourceFactoryManager().getProxyFactory();
            return pxyFactory.createVCR(this.getConnectionTemplID(), vcrHref, PathEncodingFlag.ENCODED);
        }
        return null;
    }

    public void setPredecessorSet(IVersion[] newPredSet) throws VcmFailure {
        this.setHrefProperty(DAV.PREDECESSOR_SET.qualifiedName, newPredSet);
    }

    public boolean isWorkingResource() throws VcmFailure {
        if (this.m_isWorkingResource) {
            return true;
        }
        this.m_isWorkingResource = super.isWorkingResource();
        return this.m_isWorkingResource;
    }

    void markAsWorkingResource() {
        this.m_isWorkingResource = true;
    }

    public IWorkingResource getAsWorkingResource() throws VcmFailure {
        return this.isWorkingResource() ? this : null;
    }

    public boolean isFile() throws VcmFailure {
        return !this.isCollection();
    }

    public IFile getAsFile() throws VcmFailure {
        return this.isFile() ? this : null;
    }

    public boolean isCollection() throws VcmFailure {
        this.getProperty(DAV.RESOURCETYPE.qualifiedName);
        return this.testFLAG(2);
    }

    public VersionRelation[] getPredecessorRelationSet() throws VcmFailure {
        PropertyElement expandedProp;
        ExpandPropertyReport report = new ExpandPropertyReport(this.getEncodedPath());
        ExpandPropertyDef incomingRelSet = VersionRelationFactory.expandIncomingRelSet();
        report.addPropertyExpand(incomingRelSet, null);
        DeltavCommand.execute(this.getConnectionTemplID(), (IRequest)report);
        Object relationResourceIt = null;
        ResourceElement resourceElement = report.getResource(0);
        if (resourceElement != null && (expandedProp = resourceElement.getProperty(XCM.INCOMING_RELATION_SET.localName, XCM.NAMESPACE_URI)) != null) {
            return VersionRelationFactory.createIncommingRelationSet(this.getConnectionTemplID(), expandedProp);
        }
        return new VersionRelation[0];
    }

    public boolean markedForDeletion() throws VcmFailure {
        Boolean bool = this.getPropertyBooleanValue(XCM.DELETED.qualifiedName);
        return bool != null ? bool : false;
    }

    public void setExclusiveCheckout(boolean isExclusive) throws VcmFailure {
        this.setProperty(XCM.IS_EXCLUSIVE_CHECKOUT.qualifiedName, Converter.booleanToString(isExclusive));
    }

    public boolean hasExclusiveCheckout() throws VcmFailure {
        Boolean bool = this.getPropertyBooleanValue(XCM.IS_EXCLUSIVE_CHECKOUT.qualifiedName);
        return bool != null ? bool : false;
    }

    public IVersion getAsOpenVersion() throws VcmFailure {
        return new VersionImpl(this);
    }

    public String getUpdatedResourceDecodedPath() throws VcmFailure {
        String path = this.getPropertyHrefValue(DAV.AUTO_UPDATE.qualifiedName);
        if (path != null) {
            path = this.usePathTrailSlash() ? AbstractResource.ensureTrailSlash(path) : path;
            return Encoder.decodePath((String)path);
        }
        return null;
    }

    public String getCheckedOutVersionPath() throws VcmFailure {
        return this.m_checkedOutVersionPath;
    }

    void setCheckedOutVersionPath(String versionPath) {
        this.m_checkedOutVersionPath = versionPath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

