/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionHistory;
import com.tssap.dtr.client.lib.deltavlib.PathUtil;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.AbstractResourceLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.IVersionGraph;
import com.tssap.dtr.client.lib.deltavlib.impl.IVersionGraphNode;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.ResourceMetaClass;
import com.tssap.dtr.client.lib.deltavlib.impl.VersionHistoryImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.VersionImpl;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.VersionTreeReport;

public class VersionTreeLoader
extends AbstractResourceLoader {
    private VersionTreeReport report;
    private boolean enhanced = false;

    protected void addPropertyNS(String nsPrefix, String nsUri) {
        this.report.addNamespace(nsPrefix, nsUri);
    }

    protected void addPropertyToLoad(String qualifiedName) {
        if (this.enhanced) {
            this.report.addPropertyExpand(qualifiedName, PropertyUtil.getNamespaceURI(qualifiedName), null);
        } else {
            this.report.addPropertyGet(qualifiedName);
        }
    }

    protected IRequest getRequest() {
        return this.report;
    }

    protected ResourceMetaClass getResourceMetaClass() {
        return ResourceMetaClass.MC_VERSION;
    }

    public VersionTreeLoader(VersionTreeReport report, boolean enhanced) {
        if (report == null) {
            throw new NullPointerException();
        }
        this.report = report;
        this.enhanced = enhanced;
    }

    public void execute(int conTemplID) throws VcmFailure {
        if (this.enhanced) {
            VersionImpl.setupEnhancedVersionTreeReport(this.report);
        }
        super.execute(conTemplID);
    }

    public static void initializeVersionGraph(IVersionGraph graph, boolean isEnhanced) throws VcmFailure {
        if (graph == null) {
            throw new NullPointerException();
        }
        IVersionHistory history = graph.getHistory();
        int conTemplID = history.getConnectionTemplID();
        VersionTreeLoader loader = new VersionTreeLoader(new VersionTreeReport(history.getEncodedPath()), isEnhanced);
        loader.execute(conTemplID);
        IVersionGraphNode[] versions = new IVersionGraphNode[loader.size()];
        try {
            ResourceElement nextResource = null;
            VersionImpl ver = null;
            int i = 0;
            while (i < versions.length) {
                nextResource = loader.getNextResource();
                ver = new VersionImpl(conTemplID, nextResource.getPath());
                ver.enhancedInitialize(loader.getAsProvider());
                versions[i] = ver;
                ++i;
            }
            graph.setVersions(versions);
        }
        catch (InvalidPathException e) {
            throw new VcmFailure("client internal error", e);
        }
    }

    public static void initializeEnhancedVersionGraph(IVersionGraph graph) throws VcmFailure {
        if (graph == null) {
            throw new NullPointerException();
        }
        IVersionHistory history = graph.getHistory();
        int conTemplID = history.getConnectionTemplID();
        VersionTreeReport report = new VersionTreeReport(history.getEncodedPath());
        VersionTreeLoader loader = new VersionTreeLoader(report, true);
        loader.execute(conTemplID);
        IVersionGraphNode[] versions = new IVersionGraphNode[loader.size()];
        try {
            ResourceElement nextResource = null;
            VersionImpl ver = null;
            int i = 0;
            while (i < versions.length) {
                nextResource = loader.getNextResource();
                ver = new VersionImpl(conTemplID, nextResource.getPath());
                ver.enhancedInitialize(loader.getAsProvider());
                versions[i] = ver;
                ++i;
            }
            graph.setVersions(versions);
        }
        catch (InvalidPathException e) {
            throw new VcmFailure("client internal error", e);
        }
    }

    public static IVersionGraphNode createVersionGraphNode(int connectionTemplID, String versionEncodedPath) throws InvalidPathException {
        return new VersionImpl(connectionTemplID, versionEncodedPath);
    }

    public static IVersionHistory createHistoryFromVCR(int conTemplID, String vcrPath) throws VcmFailure {
        if (vcrPath == null) {
            throw new NullPointerException();
        }
        VersionTreeLoader resourceLoader = new VersionTreeLoader(new VersionTreeReport(vcrPath), true);
        resourceLoader.addPropertyToLoad(DAV.VERSION_HISTORY.qualifiedName);
        resourceLoader.addPropertyNS("DAV", "DAV:");
        resourceLoader.execute(conTemplID);
        IVersionGraphNode[] versions = new IVersionGraphNode[resourceLoader.size()];
        VersionHistoryImpl resultHistory = null;
        try {
            ResourceElement nextResource = null;
            String encodedVHPath = null;
            int i = 0;
            while (i < versions.length) {
                nextResource = resourceLoader.getNextResource();
                VersionImpl ver = new VersionImpl(conTemplID, nextResource.getPath());
                ver.enhancedInitialize(resourceLoader.getAsProvider());
                versions[i] = ver;
                if (encodedVHPath == null) {
                    encodedVHPath = ver.getVersionHistoryEncodedPath();
                }
                ++i;
            }
            if (versions.length > 0) {
                VersionHistoryImpl vhr = new VersionHistoryImpl(conTemplID, encodedVHPath);
                vhr.setVersions(versions);
                resultHistory = vhr;
            }
        }
        catch (InvalidPathException e) {
            throw new VcmFailure("client internal error", e);
        }
        if (resultHistory == null) {
            throw new VcmFailure("client internal error");
        }
        return resultHistory;
    }

    public static IVersionGraph createVersionGraph(IVersionGraphNode versionNode) throws VcmFailure {
        if (versionNode == null) {
            throw new NullPointerException();
        }
        IVersion verResource = versionNode.getVersion();
        int conTemplID = verResource.getConnectionTemplID();
        VersionTreeLoader resourceLoader = new VersionTreeLoader(new VersionTreeReport(verResource.getEncodedPath()), true);
        resourceLoader.addPropertyToLoad(DAV.VERSION_HISTORY.qualifiedName);
        resourceLoader.addPropertyNS("DAV", "DAV:");
        resourceLoader.execute(conTemplID);
        IVersionGraphNode[] versions = new IVersionGraphNode[resourceLoader.size()];
        try {
            String encodedVerHistoryPath = null;
            ResourceElement nextResource = null;
            int i = 0;
            while (i < versions.length) {
                String xcmResourceType;
                nextResource = resourceLoader.getNextResource();
                if (PathUtil.equalWebDAVpaths(nextResource.getPath(), verResource.getEncodedPath())) {
                    versionNode.update(resourceLoader.getAsProvider());
                    versions[i] = versionNode;
                } else {
                    VersionImpl ver = new VersionImpl(conTemplID, nextResource.getPath());
                    ver.enhancedInitialize(resourceLoader.getAsProvider());
                    versions[i] = ver;
                }
                if (encodedVerHistoryPath == null && "VERSION".equals(xcmResourceType = versions[i].getVersion().getProperty(XCM.RESOURCE_TYPE.qualifiedName).getValue())) {
                    encodedVerHistoryPath = versions[i].getVersion().getVersionHistoryEncodedPath();
                }
                ++i;
            }
            if (encodedVerHistoryPath == null) {
                encodedVerHistoryPath = verResource.getVersionHistoryEncodedPath();
            }
            VersionHistoryImpl graph = new VersionHistoryImpl(conTemplID, encodedVerHistoryPath);
            graph.setVersions(versions);
            return graph;
        }
        catch (InvalidPathException e) {
            throw new VcmFailure("client internal error", e);
        }
    }

    protected IPropertyNameIterator getPropertiesToLoad() {
        return VersionImpl.getNonExpandableProperties();
    }
}

