/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.AbstractCompositeLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.ActivityVSetCompositeLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.PropagationListCompositeLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.ResourceMetaClass;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.deltavlib.xcm.ActivityCompositeDef;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityComposite;
import com.tssap.dtr.client.lib.deltavlib.xcm.IPropagationListComposite;
import com.tssap.dtr.client.lib.deltavlib.xcm.IVersionSetHolder;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import com.tssap.dtr.client.lib.protocol.requests.xcm.ActivityReport;
import java.util.BitSet;

public abstract class VersionSetLoader
extends AbstractCompositeLoader {
    private ActivityCompositeDef definition;
    protected AbstractCompositeLoader currentLoader;

    VersionSetLoader(int conTemplID) {
        super(conTemplID);
    }

    public void setCompositeDefinition(ActivityCompositeDef compositeDef) {
        if (compositeDef == null) {
            throw new NullPointerException();
        }
        this.definition = compositeDef;
        PropertyUtil.QualifiedName componentRef = new PropertyUtil.QualifiedName();
        AbstractCompositeLoader.ComponentDef componentDef = null;
        if (compositeDef.checkedOutSetProperties != null) {
            componentRef.name = DAV.ACTIVITY_CHECKOUT_SET.localName;
            componentRef.namespaceUri = null;
            this.addExpandedProperty(componentRef, compositeDef.checkedOutSetProperties, new String[]{DAV.RESOURCETYPE.localName, DAV.AUTO_UPDATE.localName});
        }
        if (compositeDef.versionSetProperties != null) {
            componentRef.name = XCM.VERSION_SET.localName;
            componentRef.namespaceUri = XCM.NAMESPACE_URI;
            this.addExpandedProperty(componentRef, compositeDef.versionSetProperties, null);
        }
        if (compositeDef.currentWorkspaceSetProperties != null) {
            componentDef = new AbstractCompositeLoader.ComponentDef(DAV.CURRENT_WORKSPACE_SET.localName);
            componentDef.addPropertySet(compositeDef.currentWorkspaceSetProperties);
            this.addComponentDef(componentDef);
        }
        if (compositeDef.subActivityProperties != null) {
            componentRef.name = DAV.SUBACTIVITY_SET.localName;
            componentRef.namespaceUri = null;
            this.addExpandedProperty(componentRef, compositeDef.subActivityProperties, null);
        }
        if (compositeDef.activityContentProperties != null) {
            componentRef.name = XCM.ACTIVITY_CONTENT_SET.localName;
            componentRef.namespaceUri = XCM.NAMESPACE_URI;
            this.addExpandedProperty(componentRef, compositeDef.activityContentProperties, new String[]{XCM.PATH.qualifiedName, DAV.RESOURCETYPE.localName, DAV.AUTO_UPDATE.localName});
        }
        if (compositeDef.activityProperties != null) {
            int i = 0;
            while (i < compositeDef.activityProperties.length) {
                String propName = compositeDef.activityProperties[i];
                this.addCompositeProperty(propName);
                ++i;
            }
        }
    }

    private void addExpandedProperty(PropertyUtil.QualifiedName expandedProperty, String[] propsToGet, String[] implicitProps) {
        AbstractCompositeLoader.ComponentDef componentDef = null;
        componentDef = expandedProperty.namespaceUri == null ? new AbstractCompositeLoader.ComponentDef(expandedProperty.name) : new AbstractCompositeLoader.ComponentDef(expandedProperty.name, expandedProperty.namespaceUri);
        componentDef.addPropertySet(propsToGet);
        if (implicitProps != null) {
            this.ensureDefaultPropertiesAdded(componentDef, implicitProps);
        }
        this.addComponentDef(componentDef);
    }

    private void ensureDefaultPropertiesAdded(AbstractCompositeLoader.ComponentDef componentDef, String[] defaultProps) {
        BitSet flags = new BitSet(defaultProps.length);
        ExpandPropertyDef child = componentDef.firstChild;
        int i = 0;
        while (child != null) {
            int pos = PropertyUtil.searchProperty(defaultProps, child.name, child.namespaceURI);
            if (pos >= 0) {
                flags.set(pos);
            }
            child = child.next;
            ++i;
        }
        int i2 = 0;
        while (i2 < defaultProps.length) {
            if (!flags.get(i2)) {
                componentDef.addChild(new ExpandPropertyDef(defaultProps[i2], PropertyUtil.getNamespaceURI(defaultProps[i2])));
            }
            ++i2;
        }
    }

    protected void addCompositeProperty(String compositeProperty) {
    }

    static class ActivityVsetLoader
    extends VersionSetLoader {
        private ActivityReport report;
        private AbstractCompositeLoader activityLoader;
        private AbstractCompositeLoader propagationLoader;
        private ResourceMetaClass compositeType;

        ActivityVsetLoader(int conTemplID, ActivityReport report) {
            super(conTemplID);
            this.report = report;
            this.activityLoader = new ActivityVSetCompositeLoader(conTemplID);
            this.propagationLoader = new PropagationListCompositeLoader(conTemplID);
        }

        IVersionSetHolder execute() throws VcmFailure {
            this.execute((IRequest)this.report);
            VSetHolder result = new VSetHolder();
            result.activityComposites = ((ActivityVSetCompositeLoader)this.activityLoader).getResult();
            result.propListComposites = ((PropagationListCompositeLoader)this.propagationLoader).getResult();
            return result;
        }

        protected void onCompositeLoaded(ResourceElement compositeResource) throws VcmFailure {
            String xcmResourceType = compositeResource.getProperty(XCM.RESOURCE_TYPE.localName, XCM.NAMESPACE_URI).getValue();
            this.currentLoader = xcmResourceType.equals("ACTIVITY") ? this.activityLoader : this.propagationLoader;
            this.currentLoader.onCompositeLoaded(compositeResource);
        }

        public void addComponentDef(AbstractCompositeLoader.ComponentDef component) {
            this.report.addPropertyExpand((ExpandPropertyDef)component, null);
        }

        protected void addCompositeProperty(String compositeProperty) {
            if (compositeProperty == null) {
                throw new NullPointerException();
            }
            this.report.addPropertyExpand(compositeProperty, PropertyUtil.getNamespaceURI(compositeProperty), null);
        }

        protected ResourceMetaClass onGetComponentType(PropertyElement componentRefProperty) {
            return this.currentLoader.onGetComponentType(componentRefProperty);
        }

        protected ResourceMetaClass onGetCompositeType() {
            return this.currentLoader.onGetCompositeType();
        }

        protected void onStoreComponent(IResource[] components) {
            this.currentLoader.onStoreComponent(components);
        }

        protected void onStoreComposite(IResource compositeResource) {
            this.currentLoader.onStoreComposite(compositeResource);
        }

        public void addSecondLevelComponentDef(AbstractCompositeLoader.ComponentDef componentDef, AbstractCompositeLoader.ComponentDef parentComponentDef) {
            this.report.addPropertyExpand((ExpandPropertyDef)componentDef, (ExpandPropertyDef)parentComponentDef);
        }
    }

    static class VSetHolder
    implements IVersionSetHolder {
        public IActivityComposite[] activityComposites;
        public IPropagationListComposite[] propListComposites;

        VSetHolder() {
        }

        public IActivityComposite[] getActivityComposite() {
            return this.activityComposites;
        }

        public IPropagationListComposite[] getPropagationListComposite() {
            return this.propListComposites;
        }
    }
}

