/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.CollisionFactory;
import com.tssap.dtr.client.lib.deltavlib.impl.CollisionImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.PropertyExpander;
import com.tssap.dtr.client.lib.deltavlib.impl.PropertyFactoryImpl;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableElement;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollisionState;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollisionProxy;
import com.tssap.dtr.client.lib.deltavlib.xcm.IPersistentCollision;
import com.tssap.dtr.client.lib.deltavlib.xcm.VersionRelation;
import com.tssap.dtr.client.lib.deltavlib.xcm.VersionRelationType;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public abstract class VersionRelationFactory {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$impl$VersionRelationFactory == null ? (class$com$tssap$dtr$client$lib$deltavlib$impl$VersionRelationFactory = VersionRelationFactory.class$("com.tssap.dtr.client.lib.deltavlib.impl.VersionRelationFactory")) : class$com$tssap$dtr$client$lib$deltavlib$impl$VersionRelationFactory));
    private static final String[] INCOMING_RELATION_SET_PROPS = new String[]{XCM.CREATING_ACTIVITY.qualifiedName, DAV.CREATOR_DISPLAYNAME.qualifiedName, DAV.CREATIONDATE.qualifiedName, XCM.RELATION_TYPE.qualifiedName, XCM.RELATION_SOURCE.qualifiedName, XCM.RELATION_TARGET.qualifiedName, XCM.COLLISION_STATE.qualifiedName, XCM.COLLIDING_VERSION.qualifiedName, DAV.WORKSPACE.qualifiedName};
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$impl$VersionRelationFactory;

    static ExpandPropertyDef expandIncomingRelSet() {
        ExpandPropertyDef incomingRelSet = PropertyExpander.expandProperty(XCM.INCOMING_RELATION_SET.qualifiedName, INCOMING_RELATION_SET_PROPS);
        ExpandPropertyDef epandedVsetSet = PropertyExpander.expandProperty(XCM.VSET_SET.qualifiedName, new String[]{XCM.RESOURCE_TYPE.qualifiedName});
        incomingRelSet.addChild(epandedVsetSet);
        return incomingRelSet;
    }

    public static Relation[] createIncommingRelationSet(int conTemplId, PropertyElement expandedIncommingRelSet) throws VcmFailure {
        int resourceCount = expandedIncommingRelSet.countExpandedResources();
        if (resourceCount == 0) {
            return null;
        }
        Iterator resourceIt = expandedIncommingRelSet.getExpandedResources();
        Relation[] relationSet = new Relation[resourceCount];
        boolean hasBranchVirtualPred = false;
        ArrayList<Relation> collisions = null;
        int countSkippedRelations = 0;
        int i = 0;
        while (i < relationSet.length) {
            try {
                relationSet[i] = VersionRelationFactory.createRelationFromResource(conTemplId, (ResourceElement)resourceIt.next());
            }
            catch (IllegalArgumentException e) {
                LOC.errorT("failed to creation version-relation");
                throw new VcmFailure("internal error", e);
            }
            if (relationSet[i].getRelationType() == VersionRelationType.BRANCH && relationSet[i].getSourceHref() == null) {
                relationSet[i] = null;
                hasBranchVirtualPred = true;
                ++countSkippedRelations;
            } else if (relationSet[i].getCollisionProxy() != null) {
                if (collisions == null) {
                    collisions = new ArrayList<Relation>();
                }
                collisions.add(relationSet[i]);
                relationSet[i] = null;
                ++countSkippedRelations;
            }
            ++i;
        }
        if (collisions != null) {
            int i2 = 0;
            while (i2 < relationSet.length) {
                Relation relation = relationSet[i2];
                if (relation != null && (relation.getRelationType() == VersionRelationType.COLLISION_PRED_SUCC || relation.getRelationType() == VersionRelationType.COLLISION_CYCLIC_MERGE)) {
                    Object collision = null;
                    int j = 0;
                    while (j < collisions.size()) {
                        CollisionPxy collisionPxy = (CollisionPxy)((VersionRelation)collisions.get(j)).getCollisionProxy();
                        if (relation.getTargetHref().equals(collisionPxy.getCollidingVersionHref())) {
                            relation.setCollisionProxy(collisionPxy);
                            ((AbstractCollection)collisions).remove(collisions.get(j));
                            break;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }
        if (countSkippedRelations > 0) {
            int size = relationSet.length - countSkippedRelations;
            if (size == 0) {
                return null;
            }
            Relation[] reducedRelSet = new Relation[size];
            int countReturned = 0;
            int i3 = 0;
            while (i3 < relationSet.length) {
                if (relationSet[i3] != null) {
                    reducedRelSet[countReturned++] = relationSet[i3];
                }
                ++i3;
            }
            return reducedRelSet;
        }
        return relationSet;
    }

    private static Relation createRelationFromResource(int connectionTemplID, ResourceElement incomingRelationResource) {
        if (incomingRelationResource == null) {
            throw new NullPointerException();
        }
        VersionRelationType relationType = null;
        Date creationDate = null;
        Object versionPath = null;
        String creator = null;
        String collisionState = null;
        String creatingActivityPath = null;
        String sourceId = null;
        String targetId = null;
        Object discardMergeWsSet = null;
        Object collisionWorkspacePath = null;
        PropertyElement vsetSetProp = null;
        Iterator propertyIt = incomingRelationResource.getProperties();
        while (propertyIt.hasNext()) {
            PropertyElement nextProperty = (PropertyElement)propertyIt.next();
            if (nextProperty.getStatusCode() != 200) continue;
            if ("DAV:".equals(nextProperty.getNamespaceURI())) {
                if (DAV.CREATIONDATE.localName.equals(nextProperty.getName())) {
                    creationDate = Converter.parseHTTPDate(nextProperty.getValue());
                    continue;
                }
                if (!DAV.CREATOR_DISPLAYNAME.localName.equals(nextProperty.getName())) continue;
                creator = nextProperty.getValue();
                continue;
            }
            if (!XCM.NAMESPACE_URI.equals(nextProperty.getNamespaceURI())) continue;
            if (XCM.RELATION_TYPE.localName.equals(nextProperty.getName())) {
                relationType = VersionRelationType.getTypeFromName(nextProperty.getValue());
                continue;
            }
            if (XCM.ACTIVITY_SET.localName.equals(nextProperty.getName())) {
                creatingActivityPath = VersionRelationFactory.decodeChildHref(nextProperty);
                continue;
            }
            if (XCM.CREATOR.localName.equals(nextProperty.getName())) {
                creator = nextProperty.getValue();
                continue;
            }
            if (XCM.RELATION_SOURCE.localName.equals(nextProperty.getName())) {
                sourceId = VersionRelationFactory.getChildHref(nextProperty);
                continue;
            }
            if (XCM.RELATION_TARGET.localName.equals(nextProperty.getName())) {
                targetId = VersionRelationFactory.getChildHref(nextProperty);
                continue;
            }
            if (XCM.VSET_SET.localName.equals(nextProperty.getName())) {
                vsetSetProp = nextProperty;
                continue;
            }
            if (!XCM.COLLISION_STATE.localName.equals(nextProperty.getName())) continue;
            collisionState = nextProperty.getValue();
        }
        String targetVersionPath = targetId != null ? Encoder.decodePath(targetId) : "";
        Relation relation = new Relation(targetVersionPath, relationType, creationDate);
        if (collisionState != null) {
            relation.setCollisionProxy(CollisionPxy.createCollisionProxy(connectionTemplID, incomingRelationResource));
        } else {
            relation.relationResourcePath = Encoder.decodePath((String)incomingRelationResource.getPath());
        }
        relation.setCreator(creator);
        relation.setCreatingActivityPath(creatingActivityPath);
        relation.setSourceHref(sourceId);
        relation.setTargetHref(targetId);
        if (VersionRelationType.DISCARD_MERGE == relationType && vsetSetProp != null) {
            VersionRelationFactory.readWorkspacesFromVsetSet(vsetSetProp, relation);
        }
        return relation;
    }

    private static IMutableElement createHref(String hrefVal) {
        IMutableElement href = PropertyFactoryImpl.getInstance().createElement("DAV", DAV.HREF.localName);
        href.setValue(hrefVal);
        return href;
    }

    private static IMutableElement createHrefSet(String[] hrefs) {
        IMutableElement hrefElement = null;
        int i = 0;
        while (i < hrefs.length) {
            if (hrefElement == null) {
                hrefElement = VersionRelationFactory.createHref(hrefs[i]);
            } else {
                hrefElement.addNextChild(VersionRelationFactory.createHref(hrefs[i]));
            }
            ++i;
        }
        return hrefElement;
    }

    private static String[] decodePathFromHrefElements(Element hrefElementsHolder) {
        Element href = hrefElementsHolder.firstChild();
        if (href == null) {
            return null;
        }
        String[] decodedPaths = new String[hrefElementsHolder.countChildren()];
        int i = 0;
        while (href != null) {
            String hrefVal = href.getValue();
            if (hrefVal == null || !DAV.HREF.localName.equals(href.getName())) {
                LOC.errorT("'href' like structured element expected: ", hrefElementsHolder.getValue());
                return null;
            }
            decodedPaths[i] = Encoder.decodePath((String)hrefVal);
            href = href.next();
            ++i;
        }
        return decodedPaths;
    }

    private static String decodeChildHref(PropertyElement property) {
        Element child = property.firstChild();
        return child != null ? Encoder.decodePath((String)child.getValue()) : null;
    }

    private static String getChildHref(PropertyElement property) {
        Element child = property.firstChild();
        return child != null ? child.getValue() : null;
    }

    private static void readWorkspacesFromVsetSet(PropertyElement vsetSet, Relation relation) {
        if (vsetSet.getStatusCode() != 200 || vsetSet.countExpandedResources() == 0) {
            return;
        }
        ArrayList<String> workspaceSet = null;
        Iterator resourceIt = vsetSet.getExpandedResources();
        while (resourceIt.hasNext()) {
            ResourceElement nextResource = (ResourceElement)resourceIt.next();
            PropertyElement resourceType = nextResource.getProperty(XCM.RESOURCE_TYPE.localName, XCM.NAMESPACE_URI);
            if (resourceType == null || !"WORKSPACE".equals(resourceType.getValue())) continue;
            if (workspaceSet == null) {
                workspaceSet = new ArrayList<String>();
            }
            workspaceSet.add(Encoder.decodePath((String)nextResource.getPath()));
        }
        if (workspaceSet != null && !workspaceSet.isEmpty()) {
            relation.setDiscardMergeWsSet(workspaceSet.toArray(new String[workspaceSet.size()]));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Relation
    extends VersionRelation {
        private String relationResourcePath;
        private ICollisionProxy collisionPxy;

        Relation(String versionPath, VersionRelationType relationType, Date creationDate) {
            super(versionPath, relationType, creationDate);
        }

        public ICollisionProxy getCollisionProxy() {
            return this.collisionPxy;
        }

        public String getRelationResourcePath() {
            return this.relationResourcePath;
        }

        void setCollisionProxy(ICollisionProxy collisionProxy) {
            this.collisionPxy = collisionProxy;
        }

        void setCreatingActivityPath(String creatingActivityPath) {
            this.creatingActivityPath = creatingActivityPath;
        }

        void setCreator(String creator) {
            this.creator = creator;
        }

        void setDiscardMergeWsSet(String[] workspaces) {
            this.discardMergeWsSet = workspaces;
        }

        void setSourceId(String id) {
            this.sourceId = id;
        }

        void setTargetId(String id) {
            this.targetId = id;
        }

        void setSourceHref(String href) {
            this.sourceHref = href;
        }

        void setTargetHref(String href) {
            this.targetHref = href;
        }
    }

    private static class CollisionPxy
    implements ICollisionProxy {
        private final String[] COLLISION_PROPS;
        private String collidingVersionHref;
        private String collisionHref;
        private String workspacePath;
        private CollisionState state;
        private IPersistentCollision collision;
        private int conTemplID;

        private CollisionPxy(int conTemplID, String collisionHref, String workspaceHref, CollisionState state, String collidingVersionHref) {
            this.COLLISION_PROPS = new String[]{DAV.WORKSPACE.qualifiedName, DAV.CREATIONDATE.qualifiedName, DAV.CREATOR_DISPLAYNAME.qualifiedName, XCM.ACTIVE_VERSION.qualifiedName, XCM.WORKSPACE_VERSION.qualifiedName, XCM.COLLIDING_VERSION.qualifiedName, XCM.VCR.qualifiedName, XCM.COLLISION_TYPE.qualifiedName, XCM.COLLISION_STATE.qualifiedName, XCM.INACTIVE_VCR.qualifiedName, XCM.INTEGRATED_VSET.qualifiedName};
            this.conTemplID = -1;
            if (collisionHref == null) {
                throw new NullPointerException("null collision path");
            }
            if (workspaceHref == null) {
                throw new NullPointerException("null workspace");
            }
            if (state == null) {
                throw new NullPointerException("null collision state");
            }
            if (collidingVersionHref == null) {
                throw new NullPointerException("null colliding-version");
            }
            this.conTemplID = conTemplID;
            this.collisionHref = collisionHref;
            this.workspacePath = Encoder.decodePath((String)workspaceHref);
            this.state = state;
            this.collidingVersionHref = collidingVersionHref;
        }

        public static ICollisionProxy createCollisionProxy(int conTemplID, ResourceElement collision) {
            String workspaceHref = null;
            String collidingVersionHref = null;
            CollisionState state = null;
            Iterator propIt = collision.getProperties();
            while (propIt.hasNext()) {
                PropertyElement nextProp = (PropertyElement)propIt.next();
                String localName = nextProp.getName();
                String nsUri = nextProp.getNamespaceURI();
                if (XCM.NAMESPACE_URI.equals(nsUri)) {
                    if (XCM.COLLISION_STATE.localName.equals(localName)) {
                        state = CollisionState.getEnumFromName(nextProp.getValue());
                        continue;
                    }
                    if (!XCM.COLLIDING_VERSION.localName.equals(localName)) continue;
                    collidingVersionHref = VersionRelationFactory.getChildHref(nextProp);
                    continue;
                }
                if (!"DAV:".equals(nsUri) || !DAV.WORKSPACE.localName.equals(localName)) continue;
                workspaceHref = VersionRelationFactory.getChildHref(nextProp);
            }
            try {
                return new CollisionPxy(conTemplID, collision.getPath(), workspaceHref, state, collidingVersionHref);
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("invalid collision collision element");
            }
        }

        public IPersistentCollision getCollision() throws VcmFailure {
            if (this.collision == null) {
                try {
                    CollisionImpl collision = new CollisionImpl(this.conTemplID, this.collisionHref);
                    collision.getPropertyCacheControl().setPropertiesToCache(this.COLLISION_PROPS);
                    collision.refresh();
                    this.collision = CollisionFactory.createPersistentCollision(collision);
                }
                catch (Exception e) {
                    throw new VcmFailure("internal error", e);
                }
            }
            return this.collision;
        }

        public String getCollisionPath() {
            return Encoder.decodePath((String)this.collisionHref);
        }

        public CollisionState getState() {
            return this.state;
        }

        public String getWorkspacePath() {
            return this.workspacePath;
        }

        public String getCollidingVersionHref() {
            return this.collidingVersionHref;
        }
    }
}

