/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IFile;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IVersionHistory;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathUtil;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.AbstractResource;
import com.tssap.dtr.client.lib.deltavlib.impl.BaseResource;
import com.tssap.dtr.client.lib.deltavlib.impl.IProtocolPropertyProvider;
import com.tssap.dtr.client.lib.deltavlib.impl.IVersionGraph;
import com.tssap.dtr.client.lib.deltavlib.impl.IVersionGraphNode;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.VersionTreeLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.util.PropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.xcm.IEnhancedVersion;
import com.tssap.dtr.client.lib.deltavlib.xcm.VersionRelation;
import com.tssap.dtr.client.lib.deltavlib.xcm.VersionRelationType;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.VersionTreeReport;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class VersionHistoryImpl
extends BaseResource
implements IVersionHistory,
IVersionGraph {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$impl$VersionHistoryImpl == null ? (class$com$tssap$dtr$client$lib$deltavlib$impl$VersionHistoryImpl = VersionHistoryImpl.class$("com.tssap.dtr.client.lib.deltavlib.impl.VersionHistoryImpl")) : class$com$tssap$dtr$client$lib$deltavlib$impl$VersionHistoryImpl));
    private boolean isEnhancedVersionTree = true;
    private String rootVersionHref;
    private IVersion rootVersion;
    private boolean expired;
    private Map versionGraph;
    private Map versionIdMap;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$impl$VersionHistoryImpl;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$IVersionHistory;

    private void checkVersionGraphInitialized() throws VcmFailure {
        if (this.versionGraph == null) {
            this.loadVersionGraphForVersionHistory();
        }
    }

    private void loadVersionGraphForVersionHistory() throws VcmFailure {
        VersionTreeLoader.initializeVersionGraph(this, this.isEnhancedVersionTree);
    }

    private void setRoot(IVersionGraphNode root) {
        this.rootVersion = root.getVersion();
        this.rootVersionHref = this.rootVersion.getEncodedPath();
    }

    protected IPropertyNameIterator getInitialPropertyNames() {
        IPropertyNameIterator propNameIt = AbstractResource.PROPERTY_MANAGER.getResourceCachedProperties(class$com$tssap$dtr$client$lib$deltavlib$IVersionHistory == null ? (class$com$tssap$dtr$client$lib$deltavlib$IVersionHistory = VersionHistoryImpl.class$("com.tssap.dtr.client.lib.deltavlib.IVersionHistory")) : class$com$tssap$dtr$client$lib$deltavlib$IVersionHistory);
        if (propNameIt == null) {
            return new PropertyNameIterator(new String[0]);
        }
        return propNameIt;
    }

    public VersionHistoryImpl(int conTemplID, String path) throws InvalidPathException {
        super(conTemplID, path);
    }

    void setIsEnhancedVersionTree(boolean isEnhancedVerTree) {
        this.isEnhancedVersionTree = isEnhancedVerTree;
    }

    public void releaseVersionSet() {
        this.rootVersion = null;
        this.rootVersionHref = null;
        this.versionGraph = null;
        this.versionIdMap = null;
    }

    public IVersion getRootVersion() throws VcmFailure {
        if (this.rootVersion == null) {
            this.checkVersionGraphInitialized();
            this.rootVersion = this.findNodeByVersionPath(this.rootVersionHref).getVersion();
        }
        return this.rootVersion;
    }

    public IVersion[] getVersionSet() throws VcmFailure {
        this.checkVersionGraphInitialized();
        Iterator verIt = this.versionGraph.values().iterator();
        IVersion[] versions = new IVersion[this.versionGraph.size()];
        int i = 0;
        while (verIt.hasNext()) {
            IVersionGraphNode versionNode = (IVersionGraphNode)verIt.next();
            versions[i] = versionNode.getVersion();
            ++i;
        }
        return versions;
    }

    public IEnhancedVersion[] getEnhancedVersionSet() throws VcmFailure {
        if (!this.isEnhancedVersionTree) {
            this.setIsEnhancedVersionTree(true);
            this.releaseVersionSet();
        }
        this.checkVersionGraphInitialized();
        Iterator verIt = this.versionGraph.values().iterator();
        IEnhancedVersion[] versions = new IEnhancedVersion[this.versionGraph.size()];
        int i = 0;
        while (verIt.hasNext()) {
            IVersionGraphNode versionNode = (IVersionGraphNode)verIt.next();
            if (!versionNode.hasEnhancedVersion()) {
                LOC.errorT("expected enhanced version in the version-graph");
                throw new VcmFailure("client internal error");
            }
            versions[i] = versionNode.getEnhancedVersion();
            ++i;
        }
        return versions;
    }

    public IVersion getLatestVersion(IActivity activity) {
        throw new UnsupportedOperationException("not imlemented");
    }

    public IVersion getVersion(String label) throws VcmFailure {
        if (label == null) {
            throw new NullPointerException();
        }
        this.checkVersionGraphInitialized();
        Collection versions = this.versionGraph.values();
        Iterator verIt = versions.iterator();
        while (verIt.hasNext()) {
            IVersionGraphNode nextVer = (IVersionGraphNode)verIt.next();
            if (!nextVer.hasLabel(label)) continue;
            return nextVer.getVersion();
        }
        return null;
    }

    public IVersion getVersionByPath(String versionPath) throws VcmFailure {
        if (versionPath == null) {
            throw new NullPointerException("null version path");
        }
        String encodedPath = Encoder.encodePath((String)versionPath);
        IVersionGraphNode node = (IVersionGraphNode)this.versionGraph.get(encodedPath);
        return node != null ? node.getVersion() : null;
    }

    public IVersion getActiveVersionInWorkspace(IWorkspace workspace) throws VcmFailure {
        this.checkVersionGraphInitialized();
        String activeWorkspacePath = workspace.getDecodedPath();
        Iterator verIt = this.versionGraph.keySet().iterator();
        while (verIt.hasNext()) {
            VersionRelation[] predRelSet;
            IVersion[] succSet;
            IVersionGraphNode nextNode = (IVersionGraphNode)verIt.next();
            IVersion nextVersion = nextNode.getVersion();
            String workspacePath = nextVersion.getCreatorWorkspaceDecodedPath();
            if (!PathUtil.equalWebDAVpaths(workspacePath, activeWorkspacePath) || (succSet = nextVersion.getSuccessorSet()) != null && succSet.length != 0 || (predRelSet = nextVersion.getPredecessorRelationSet()) == null) continue;
            boolean isColliding = false;
            int j = 0;
            while (j < predRelSet.length) {
                if (VersionRelationType.COLLISION_PRED_SUCC == predRelSet[j].getRelationType()) {
                    isColliding = true;
                    break;
                }
                ++j;
            }
            if (isColliding) continue;
            return nextVersion;
        }
        return null;
    }

    public IVersionGraphNode findNodeByVersionPath(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (this.versionGraph == null) {
            throw new IllegalStateException("version history not loaded");
        }
        return (IVersionGraphNode)this.versionGraph.get(path);
    }

    public IVersionGraphNode findNodeByVersionId(String versionId) {
        if (this.versionIdMap == null) {
            this.versionIdMap = new HashMap();
            Iterator entryIt = this.versionGraph.entrySet().iterator();
            while (entryIt.hasNext()) {
                Map.Entry nextEntry = entryIt.next();
                IVersionGraphNode node = (IVersionGraphNode)nextEntry.getValue();
                try {
                    this.versionIdMap.put(node.getVersion().getVersionId(), node);
                }
                catch (VcmFailure e) {
                    throw new IllegalStateException("resourceId must be loaded");
                }
            }
        }
        return (IVersionGraphNode)this.versionIdMap.get(versionId);
    }

    public void setVersions(IVersionGraphNode[] versions) {
        if (versions == null) {
            throw new NullPointerException();
        }
        if (this.versionGraph == null) {
            this.versionGraph = new HashMap(versions.length);
        } else {
            this.versionGraph.clear();
        }
        int i = 0;
        while (i < versions.length) {
            if (versions[i] == null) {
                throw new NullPointerException();
            }
            this.versionGraph.put(versions[i].getVersion().getEncodedPath(), versions[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < versions.length) {
            versions[i2].setVersionGraph(this);
            if (!versions[i2].hasPredecessors()) {
                this.setRoot(versions[i2]);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < versions.length) {
            versions[i3].notifyIncomingNodes();
            ++i3;
        }
    }

    public void refreshVersionSet() throws VcmFailure {
        if (this.versionGraph == null) {
            return;
        }
        Iterator verIt = this.versionGraph.values().iterator();
        IVersionGraphNode nextVer = null;
        while (verIt.hasNext()) {
            nextVer = (IVersionGraphNode)verIt.next();
            nextVer.setVersionGraph(null);
        }
        VersionTreeLoader loader = new VersionTreeLoader(new VersionTreeReport(this.getEncodedPath()), this.isEnhancedVersionTree);
        loader.execute(this.getConnectionTemplID());
        IVersionGraphNode existVersionNode = null;
        int i = 0;
        while (i < loader.size()) {
            ResourceElement nextVerResource = loader.getNextResource();
            IProtocolPropertyProvider loadedVersionProvider = loader.getAsProvider();
            existVersionNode = this.findNodeByVersionPath(nextVerResource.getPath());
            if (existVersionNode == null) {
                try {
                    existVersionNode = VersionTreeLoader.createVersionGraphNode(this.getConnectionTemplID(), nextVerResource.getPath());
                    this.versionGraph.put(nextVerResource.getPath(), existVersionNode);
                }
                catch (InvalidPathException e) {
                    LOC.errorT("Invalid path in received version resource {0}", new Object[]{e});
                    throw new VcmFailure("client internal error", e);
                }
            }
            existVersionNode.update(loadedVersionProvider);
            existVersionNode.setVersionGraph(this);
            ++i;
        }
        this.versionIdMap = null;
        verIt = this.versionGraph.values().iterator();
        while (verIt.hasNext()) {
            nextVer = (IVersionGraphNode)verIt.next();
            if (nextVer.getVersionGraph() == null) {
                verIt.remove();
                continue;
            }
            if (!nextVer.hasPredecessors()) {
                this.setRoot(nextVer);
            }
            nextVer.notifyIncomingNodes();
        }
    }

    public IFile getAsFile() {
        return null;
    }

    public ICollection getAsCollection() {
        return null;
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public IVersionControlledResource getAsVersionControlled() {
        return null;
    }

    public void setExpired() {
        this.expired = true;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public IVersionHistory getHistory() {
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

