/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.IAssociatedResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.ICheckedInResource;
import com.tssap.dtr.client.lib.deltavlib.ICheckedOutResource;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IMergePreview;
import com.tssap.dtr.client.lib.deltavlib.IPrincipal;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IVersionHistory;
import com.tssap.dtr.client.lib.deltavlib.IWorkingResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.PathUtil;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.AbstractResource;
import com.tssap.dtr.client.lib.deltavlib.impl.CollectionImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.impl.FileImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.MergeImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.PropertyExpander;
import com.tssap.dtr.client.lib.deltavlib.impl.ResourceMetaClass;
import com.tssap.dtr.client.lib.deltavlib.impl.SelectivePropertyExpander;
import com.tssap.dtr.client.lib.deltavlib.impl.UpdateResponseLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.VersionTreeLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.WorkingResourceImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.IConvertableCachedObj;
import com.tssap.dtr.client.lib.deltavlib.impl.util.AutoversionProperty;
import com.tssap.dtr.client.lib.deltavlib.impl.util.DataUtil;
import com.tssap.dtr.client.lib.deltavlib.impl.util.ForkPolicyProperty;
import com.tssap.dtr.client.lib.deltavlib.impl.util.PropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyCacheControl;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.MergePreviewEntity;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.CheckinRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.CheckoutRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.MergePreviewReport;
import com.tssap.dtr.client.lib.protocol.requests.dav.MergeRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.MkColRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.UncheckoutRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.UpdateRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.VersionControlRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.Iterator;
import java.util.Stack;

class VersionControlledImpl
extends FileImpl
implements IVersionControlledResource,
ICheckedOutResource,
ICheckedInResource {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$impl$VersionControlledImpl == null ? (class$com$tssap$dtr$client$lib$deltavlib$impl$VersionControlledImpl = VersionControlledImpl.class$("com.tssap.dtr.client.lib.deltavlib.impl.VersionControlledImpl")) : class$com$tssap$dtr$client$lib$deltavlib$impl$VersionControlledImpl));
    private static final String HEADER_LOCATION = "Location";
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$impl$VersionControlledImpl;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$IVersionControlledResource;

    protected IPropertyNameIterator getInitPropertyNames() {
        IPropertyNameIterator propNameIt = AbstractResource.PROPERTY_MANAGER.getResourceCachedProperties(class$com$tssap$dtr$client$lib$deltavlib$IVersionControlledResource == null ? (class$com$tssap$dtr$client$lib$deltavlib$IVersionControlledResource = VersionControlledImpl.class$("com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource")) : class$com$tssap$dtr$client$lib$deltavlib$IVersionControlledResource);
        if (propNameIt == null) {
            return PropertyNameIterator.EMPTY_ITERATOR;
        }
        return propNameIt;
    }

    protected String getActiveVersionHref() throws VcmFailure {
        String activeVerHref = this.getPropertyHrefValue(DAV.CHECKED_IN.qualifiedName);
        if (activeVerHref == null) {
            activeVerHref = this.getPropertyHrefValue(DAV.CHECKED_OUT.qualifiedName);
        }
        return activeVerHref;
    }

    protected final void setActiveVersionHref(String verHref, boolean isCheckin) {
        if (verHref == null) {
            IPropertyCacheControl cacheControl = this.getPropertyCacheControl();
            cacheControl.clearProperty(DAV.CHECKED_IN.qualifiedName);
            cacheControl.clearProperty(DAV.CHECKED_OUT.qualifiedName);
            return;
        }
        if (isCheckin) {
            this.setPropertyHrefValue(DAV.CHECKED_IN.qualifiedName, verHref);
        } else {
            this.setPropertyHrefValue(DAV.CHECKED_OUT.qualifiedName, verHref);
        }
    }

    public VersionControlledImpl(int conTemplID, String path) throws InvalidPathException {
        super(conTemplID, path);
    }

    public VersionControlledImpl(FileImpl base) throws InvalidPathException, VcmFailure {
        super(base);
    }

    public IConvertableCachedObj onSetNonPrimitiveCachedProperty(PropertyElement prop) {
        if ("DAV:".equals(prop.getNamespaceURI()) && (DAV.CHECKOUT_FORK.localName.equals(prop.getName()) || DAV.CHECKIN_FORK.localName.equals(prop.getName()))) {
            return ForkPolicyProperty.getCachedForkPolicy(prop);
        }
        return null;
    }

    public ICollection getAsCollection() throws VcmFailure {
        if (this.isCollection()) {
            return new CollectionImpl(this);
        }
        return null;
    }

    public String getVersionHistoryPath() throws VcmFailure {
        String href = this.getPropertyHrefValue(DAV.VERSION_HISTORY.qualifiedName);
        return href != null ? Encoder.decodePath((String)href) : null;
    }

    public String getVersionHistoryDecodedPath() throws VcmFailure {
        String href = this.getPropertyHrefValue(DAV.VERSION_HISTORY.qualifiedName);
        return href != null ? Encoder.decodePath((String)href) : null;
    }

    public String getVersionHistoryEncodedPath() throws VcmFailure {
        return this.getPropertyHrefValue(DAV.VERSION_HISTORY.qualifiedName);
    }

    public IVersionHistory getVersionHistory() throws VcmFailure {
        return VersionTreeLoader.createHistoryFromVCR(this.getConnectionTemplID(), this.getEncodedPath());
    }

    public IVersion getActiveVersion() throws VcmFailure {
        IResourceFactory proxyFactory = this.getResourceFactoryManager().getProxyFactory();
        return proxyFactory.createVersion(this.getConnectionTemplID(), this.getActiveVersionHref(), PathEncodingFlag.ENCODED);
    }

    public void setPredecessorSet(IVersion[] predSet) throws VcmFailure {
        this.setHrefProperty(DAV.PREDECESSOR_SET.qualifiedName, predSet);
    }

    public int getAutoVersion() throws VcmFailure {
        IProperty autoversion = this.getProperty(DAV.AUTO_VERSION.qualifiedName);
        if (autoversion != null) {
            return AutoversionProperty.autoVersionToEnumInt(autoversion);
        }
        return 0;
    }

    public void setAutoVersion(int autoVersionType) throws VcmFailure {
        IProperty autoVersionProp = AutoversionProperty.getAutoVersionFromEnumInt(autoVersionType);
        if (autoVersionProp != null) {
            throw new VcmFailure("Invalid auto-version type");
        }
        this.setProperties(new IProperty[]{autoVersionProp});
    }

    public String[] merge(IResource mergeSource, int flags) throws VcmFailure {
        if (mergeSource == null) {
            throw new NullPointerException();
        }
        MergeRequest merge = new MergeRequest(this.getEncodedPath(), mergeSource.getEncodedPath());
        if ((flags & 2) != 0) {
            merge.prohibitAutoMerge(true);
        }
        if ((flags & 1) != 0) {
            merge.prohibitAutoCheckout(true);
        }
        if (merge instanceof IActivity) {
            merge.checkinActivity(true);
        }
        IResponse response = this.executeRequest((IRequest)merge);
        MultiStatusEntity entity = (MultiStatusEntity)merge.getResponseEntity();
        int size = entity.countResources();
        if (size > 0) {
            String[] targetHrefs = new String[size];
            Iterator resources = entity.getResources();
            int i = 0;
            while (resources.hasNext()) {
                ResourceElement nextRes = (ResourceElement)resources.next();
                targetHrefs[i] = nextRes.getPath();
                ++i;
            }
            return targetHrefs;
        }
        return new String[0];
    }

    public IMergePreview mergePreview(IResource mergeSource) throws VcmFailure {
        if (mergeSource == null) {
            throw new NullPointerException();
        }
        MergePreviewReport mergePrev = new MergePreviewReport(this.getEncodedPath(), mergeSource.getEncodedPath());
        IResponse response = this.executeRequest((IRequest)mergePrev);
        return new MergeImpl(this.getConnectionTemplID(), (MergePreviewEntity)mergePrev.getResponseEntity());
    }

    public IVersion getCheckedOut() throws VcmFailure {
        String verHref = this.getActiveVersionHref();
        if (!this.isCheckedOut() || verHref == null) {
            return null;
        }
        IResourceFactory pxyFactory = this.getResourceFactoryManager().getProxyFactory();
        return pxyFactory.createVersion(this.getConnectionTemplID(), verHref, PathEncodingFlag.ENCODED);
    }

    public IVersion[] getPredecessorSet() throws VcmFailure {
        return this.expandVersionProperty("predecessor-set");
    }

    public int getCheckinFork() throws VcmFailure {
        IProperty fork = this.getProperty(DAV.CHECKIN_FORK.qualifiedName);
        if (fork != null && fork.getFirstChild() != null) {
            String forkPolicyName = fork.getFirstChild().getName();
            return ForkPolicyProperty.getForkPolicyIntEnumByName(forkPolicyName);
        }
        return 1;
    }

    public void setCheckinFork(int forkType) throws VcmFailure {
        String forkTypeName = ForkPolicyProperty.getForkPolicyByIntEnum(forkType);
        if (forkTypeName == null) {
            throw new VcmFailure("Invalid checkin fork type");
        }
        IMutableProperty forkTypeProp = AbstractResource.PROPERTY_FACTORY.createProperty(DAV.CHECKIN_FORK.namespacePrefix, DAV.CHECKIN_FORK.localName);
        forkTypeProp.setValue(forkTypeName);
        this.setProperties(new IProperty[]{forkTypeProp});
    }

    public void setCheckOutFork(int forkType) throws VcmFailure {
        String forkTypeName = ForkPolicyProperty.getForkPolicyByIntEnum(forkType);
        if (forkTypeName == null) {
            throw new VcmFailure("Invalid checkout fork type");
        }
        IMutableProperty forkTypeProp = AbstractResource.PROPERTY_FACTORY.createProperty(DAV.CHECKOUT_FORK.namespacePrefix, DAV.CHECKOUT_FORK.localName);
        forkTypeProp.setValue(forkTypeName);
        this.setProperties(new IProperty[]{forkTypeProp});
    }

    public int getCheckoutFork() throws VcmFailure {
        IProperty fork = this.getProperty(DAV.CHECKOUT_FORK.qualifiedName);
        if (fork != null && fork.getFirstChild() != null) {
            String forkPolicyName = fork.getFirstChild().getName();
            return ForkPolicyProperty.getForkPolicyIntEnumByName(forkPolicyName);
        }
        return 1;
    }

    public IVersion[] getMergeSet() throws VcmFailure {
        return this.expandVersionProperty("merge-set");
    }

    public IVersion[] getAutoMergeSet() throws VcmFailure {
        return this.expandVersionProperty("auto-merge-set");
    }

    public void confirmMerge() {
        throw new UnsupportedOperationException("not implemented");
    }

    public IActivity[] getActivitySet() throws VcmFailure {
        IAssociatedResourceFactory factory = this.getResourceFactoryManager().getAssocFactory();
        return factory.createActivitiesFromReference(this, DAV.ACTIVITY_SET.qualifiedName);
    }

    public void setUnreserved(boolean unreserved) throws VcmFailure {
        this.setProperty(DAV.UNRESERVED.qualifiedName, Converter.booleanToString(unreserved));
    }

    public boolean getUnreserved() throws VcmFailure {
        Boolean bool = this.getPropertyBooleanValue(DAV.UNRESERVED.qualifiedName);
        return bool != null ? bool : false;
    }

    public void checkin(int flags) throws VcmFailure {
        CheckinRequest ci = new CheckinRequest(this.getEncodedPath());
        ci.setAllowForks((flags & 2) != 0);
        ci.setKeepCheckedOut((flags & 1) != 0);
        IResponse response = this.executeRequest((IRequest)ci);
        this.setActiveVersionHref(ci.getNewVersion(), true);
        this.getPropertyCacheControl().clearProperty(DAV.CHECKED_OUT.qualifiedName);
    }

    public void uncheckout() throws VcmFailure {
        UncheckoutRequest uncheckoutRequest = new UncheckoutRequest(this.getEncodedPath());
        this.executeRequest((IRequest)uncheckoutRequest);
        this.setActiveVersionHref(this.getActiveVersionHref(), true);
    }

    public ICheckedOutResource checkout(IActivity[] activities, int flags) throws VcmFailure {
        String[] activityHrefs = null;
        if (activities != null) {
            activityHrefs = new String[activities.length];
            int i = 0;
            while (i < activityHrefs.length) {
                activityHrefs[i] = activities[i].getEncodedPath();
                ++i;
            }
        }
        CheckoutRequest co = new CheckoutRequest(this.getEncodedPath());
        if (activities != null) {
            co.addActivitySet(activityHrefs);
        }
        co.setAllowForks((flags & 4) != 0);
        co.setApplyToVersion((flags & 2) != 0);
        co.setCreateNewActivity((flags & 8) != 0);
        co.setCheckoutUnreserved((flags & 1) != 0);
        co.setCheckoutExclusive((flags & 0x10) != 0);
        IResponse response = this.executeRequest((IRequest)co);
        String checkedOutVersionPath = co.getCheckedoutVersionURL();
        if ((flags & 2) != 0) {
            String wrUrl = response.getHeaderValue(HEADER_LOCATION);
            IResourceFactory pxyFactory = this.getResourceFactoryManager().getProxyFactory();
            IWorkingResource workingResource = pxyFactory.createWorkingResource(this.getConnectionTemplID(), wrUrl, PathEncodingFlag.ENCODED);
            ((WorkingResourceImpl)workingResource).setCheckedOutVersionPath(checkedOutVersionPath);
            ((WorkingResourceImpl)workingResource).markAsWorkingResource();
            return workingResource;
        }
        if (!this.isPropertyInitialized(DAV.CHECKED_IN.qualifiedName)) {
            this.setPropertyHrefValue(DAV.CHECKED_OUT.qualifiedName, this.getEncodedPath());
        } else {
            this.getPropertyCacheControl().clearProperty(DAV.CHECKED_IN.qualifiedName);
        }
        this.setActiveVersionHref(null, true);
        return this;
    }

    public boolean isCheckedOut() throws VcmFailure {
        if (this.isPropertyInitialized(DAV.CHECKED_IN.qualifiedName) && this.getPropertyHrefValue(DAV.CHECKED_IN.qualifiedName) != null) {
            return false;
        }
        return this.getPropertyHrefValue(DAV.CHECKED_OUT.qualifiedName) != null;
    }

    public boolean isCheckedIn() throws VcmFailure {
        return this.getPropertyHrefValue(DAV.CHECKED_IN.qualifiedName) != null;
    }

    public ICheckedOutResource getAsCheckedOut() throws VcmFailure {
        if (this.isCheckedOut()) {
            return this;
        }
        return null;
    }

    public IVersionControlledResource getAsVersionControlled() throws VcmFailure {
        return this;
    }

    public IVersion getCheckedIn() throws VcmFailure {
        String verHref = this.getActiveVersionHref();
        if (this.isCheckedOut() || verHref == null) {
            return null;
        }
        IResourceFactory factory = this.getResourceFactoryManager().getProxyFactory();
        return factory.createVersion(this.getConnectionTemplID(), verHref, PathEncodingFlag.ENCODED);
    }

    public void update(IVersion ver) throws VcmFailure {
        UpdateResponseLoader loader = new UpdateResponseLoader(new UpdateRequest(this.getEncodedPath(), ver.getEncodedPath()));
        loader.execute(this.getConnectionTemplID());
        if (!loader.hasMoreResources()) {
            throw new VcmFailure("Failed to update resource from repository ");
        }
        this.initialize(loader);
    }

    public ICheckedInResource getAsCheckedIn() throws VcmFailure {
        if (this.isCheckedIn()) {
            return this;
        }
        return null;
    }

    public IVersionControlledResource createNewFromVersionHistory(IWorkspace destination, IVersion selected) throws VcmFailure {
        if (destination == null || selected == null) {
            throw new NullPointerException();
        }
        String myWorkspacePath = this.getWorkspaceHref();
        String wsRelPath = this.getEncodedPath();
        if (wsRelPath.startsWith(myWorkspacePath)) {
            wsRelPath = wsRelPath.substring(myWorkspacePath.length());
        } else {
            int pos = wsRelPath.indexOf(47, 1);
            if (pos > 0) {
                wsRelPath = wsRelPath.substring(pos, wsRelPath.length());
            }
        }
        String parentPath = PathUtil.getParentPath(wsRelPath);
        if (!parentPath.equals("/")) {
            this.makeCollectionPath(destination.getEncodedPath(), parentPath);
        }
        StringBuffer newVcrPathBuf = new StringBuffer(destination.getEncodedPath());
        newVcrPathBuf.setLength(newVcrPathBuf.length() - 1);
        newVcrPathBuf.append(wsRelPath);
        String newVcrPath = newVcrPathBuf.toString();
        VersionControlRequest vcrReq = new VersionControlRequest(newVcrPath, selected.getEncodedPath());
        this.executeRequest((IRequest)vcrReq);
        this.setActiveVersionHref(this.getActiveVersionHref(), false);
        if (this.getActiveVersionHref() == null) {
            throw new IllegalStateException();
        }
        IResourceFactory proxyFactory = this.getResourceFactoryManager().getProxyFactory();
        return proxyFactory.createVCR(this.getConnectionTemplID(), newVcrPath, PathEncodingFlag.ENCODED);
    }

    private IVersion[] expandVersionProperty(String propertyName) throws VcmFailure {
        IAssociatedResourceFactory factory = this.getResourceFactoryManager().getAssocFactory();
        return factory.createVersionsFromReference(this, propertyName);
    }

    private void makeCollectionPath(String parentPath, String targetPath) throws VcmFailure {
        String subPath = targetPath;
        String localParent = parentPath;
        if (parentPath.endsWith("/")) {
            localParent = parentPath.substring(0, parentPath.length() - 1);
        }
        int endPos = targetPath.length() - 1;
        if (targetPath.endsWith("/")) {
            --endPos;
        }
        if (endPos < 0) {
            return;
        }
        Stack<String> elementsToCreate = new Stack<String>();
        while ((endPos = subPath.lastIndexOf(47)) > 0) {
            subPath = subPath.substring(0, endPos);
            MkColRequest mkcol = new MkColRequest(localParent + subPath);
            IResponse response = DeltavCommand.uncheckedExecute(this.getConnectionTemplID(), (IRequest)mkcol);
            if (response.getStatus() == 409) {
                elementsToCreate.push(mkcol.getPath());
                continue;
            }
            if (response.getStatus() == 405 || DeltavCommand.isStatusSuccess(response.getStatus())) continue;
            throw new VcmFailure(response.getStatusDescription(), response.getStatus());
        }
        while (!elementsToCreate.empty()) {
            String collectionPath = (String)elementsToCreate.pop();
            MkColRequest mkcol = new MkColRequest(collectionPath);
            IResponse response = this.executeRequest((IRequest)mkcol);
            if (DeltavCommand.isStatusSuccess(response.getStatus())) continue;
            throw new VcmFailure(response.getStatusDescription(), response.getStatus());
        }
    }

    public IWorkingResource getAsWorkingResource() throws VcmFailure {
        return null;
    }

    public boolean isWorkingResource() throws VcmFailure {
        return false;
    }

    public Boolean isCheckedOutByOthers() throws VcmFailure {
        return this.getPropertyBooleanValue(XCM.HAS_FOREIGN_CHECKOUT.qualifiedName);
    }

    public String[] getOtherCheckoutersDisplayNames() throws VcmFailure {
        SelectivePropertyExpander expander = new SelectivePropertyExpander(this.getEncodedPath(), XCM.FOREIGN_CHECKOUTERS.qualifiedName, new String[]{DAV.DISPLAYNAME.qualifiedName}, ResourceMetaClass.MC_PRINCIPAL);
        IResource[] checkouters = expander.loadResources(this.getConnectionTemplID());
        if (checkouters != null) {
            String[] displaynames = new String[checkouters.length];
            int i = 0;
            while (i < displaynames.length) {
                displaynames[i] = checkouters[i].getDisplayName();
                ++i;
            }
            return displaynames;
        }
        return null;
    }

    public IPrincipal[] getOtherCheckouters() throws VcmFailure {
        PropertyExpander propExpander = new PropertyExpander(this.getEncodedPath(), XCM.FOREIGN_CHECKOUTERS.qualifiedName, ResourceMetaClass.MC_PRINCIPAL);
        return (IPrincipal[])propExpander.loadResources(this.getConnectionTemplID());
    }

    public void localUpdate(IVersion checkedInVersion, boolean isFirstVersion, IActivity checkedInActivity) throws VcmFailure {
        if (checkedInVersion == null || checkedInActivity == null) {
            throw new NullPointerException();
        }
        boolean isDeletedVersion = checkedInVersion.markedAsDeleted();
        if (isFirstVersion || isDeletedVersion) {
            this.syncProperty(checkedInVersion, XCM.PATH.qualifiedName, true);
            this.syncProperty(checkedInActivity, DAV.WORKSPACE.qualifiedName, false);
            IProperty wsProperty = VersionControlledImpl.tryGetPropertyFromCache(checkedInVersion, DAV.GETLASTMODIFIED.qualifiedName);
            if (wsProperty != null) {
                this.setPropertyStringValue(DAV.CREATIONDATE.qualifiedName, wsProperty.getValue());
            }
            this.setPropertyStringValue(XCM.HAS_FOREIGN_CHECKOUT.qualifiedName, Converter.booleanToString(false));
        }
        this.setPropertyNotFound(XCM.EXCLUSIVE_CHECKOUT.qualifiedName);
        this.syncProperty(checkedInVersion, DAV.CREATOR_DISPLAYNAME.qualifiedName, false);
        this.syncProperty(checkedInVersion, DAV.RESOURCETYPE.qualifiedName, false);
        this.syncProperty(checkedInVersion, XCM.OID.qualifiedName, false);
        this.syncProperty(checkedInActivity, DAV.GETLASTMODIFIED.qualifiedName, true);
        this.syncProperty(checkedInVersion, DAV.GETCONTENTLENGTH.qualifiedName, true);
        this.syncProperty(checkedInVersion, DAV.GETCONTENTTYPE.qualifiedName, true);
        this.syncProperty(checkedInVersion, DAV.DISPLAYNAME.qualifiedName, true);
        this.syncProperty(checkedInVersion, DAV.GETETAG.qualifiedName, true);
        this.syncProperty(checkedInVersion, XCM.DELETED.qualifiedName, true);
        this.setCheckedInVersion(checkedInVersion);
    }

    public void localExlusiveCheckoutUpdate(String activityDecodedPath) {
        if (activityDecodedPath == null) {
            this.setPropertyNotFound(XCM.EXCLUSIVE_CHECKOUT.qualifiedName);
        } else {
            this.setPropertyHrefValue(XCM.EXCLUSIVE_CHECKOUT.qualifiedName, Encoder.encodePath((String)activityDecodedPath));
        }
    }

    public String getExclusiveCheckoutActivityLockPath() throws VcmFailure {
        String activityHref = this.getPropertyHrefValue(XCM.EXCLUSIVE_CHECKOUT.qualifiedName);
        return activityHref == null ? null : Encoder.decodePath((String)activityHref);
    }

    private void setCheckedInVersion(IVersion activeVersion) {
        PropertyElement propertyElement = new PropertyElement(DAV.CHECKED_IN.qualifiedName, "DAV:");
        Element href = new Element(DAV.HREF.qualifiedName, "DAV:", activeVersion.getEncodedPath());
        href.setValue(activeVersion.getEncodedPath());
        propertyElement.addChild(href);
        propertyElement.setStatusCode(200);
        this.localSetProperty(propertyElement);
    }

    private boolean syncProperty(IResource fromResource, String qualifiedName, boolean resetInitialized) {
        IProperty property = VersionControlledImpl.tryGetPropertyFromCache(fromResource, qualifiedName);
        if (property != null) {
            PropertyElement propertyElement = DataUtil.apiToProtocolProperty(property, null);
            if (!resetInitialized && this.isPropertyInitialized(qualifiedName)) {
                return false;
            }
            this.localSetProperty(propertyElement);
            return true;
        }
        this.getPropertyCacheControl().clearProperty(qualifiedName);
        return false;
    }

    private void setPropertyNotFound(String propertyName) {
        PropertyElement property = new PropertyElement(propertyName, PropertyUtil.getNamespaceURI(propertyName));
        property.setStatusCode(404);
        this.localSetProperty(property);
    }

    private static IProperty tryGetPropertyFromCache(IResource fromResource, String propertyName) {
        if (1 == fromResource.getPropertyCacheControl().getPropertyState(propertyName)) {
            try {
                return fromResource.getProperty(propertyName);
            }
            catch (VcmFailure e) {
                throw new IllegalStateException(propertyName + " property must have been initialized in resource: " + fromResource.getEncodedPath());
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

