/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.lock.ILock;
import com.tssap.dtr.client.lib.deltavlib.lock.IResourceLockManager;
import com.tssap.dtr.client.lib.deltavlib.lock.LockSupport;
import com.tssap.dtr.client.lib.deltavlib.lock.LockType;
import com.tssap.dtr.client.lib.deltavlib.lock.TimeOutVal;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.dav.LockRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.LockScope;
import com.tssap.dtr.client.lib.protocol.requests.dav.LockTimeout;
import com.tssap.dtr.client.lib.protocol.requests.dav.PropfindRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.UnlockRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;

public class ResourceLockManagerImpl
implements IResourceLockManager {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$impl$ResourceLockManagerImpl == null ? (class$com$tssap$dtr$client$lib$deltavlib$impl$ResourceLockManagerImpl = ResourceLockManagerImpl.class$("com.tssap.dtr.client.lib.deltavlib.impl.ResourceLockManagerImpl")) : class$com$tssap$dtr$client$lib$deltavlib$impl$ResourceLockManagerImpl));
    private String resourcePath;
    private int conTemplID;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$impl$ResourceLockManagerImpl;

    ResourceLockManagerImpl(int conTemplID, String resourcePath) {
        this.conTemplID = conTemplID;
        this.resourcePath = resourcePath;
    }

    private LockSupport[] createLockSupportEntries(PropertyElement supportedLock) {
        LockSupport[] supportedLocks = new LockSupport[supportedLock.countChildren()];
        Object lockSupport = null;
        com.tssap.dtr.client.lib.deltavlib.lock.LockScope scope = null;
        LockType type = null;
        Element child = supportedLock.firstChild();
        int i = 0;
        while (child != null) {
            type = this.getLockType(child);
            scope = this.getLockScope(child);
            supportedLocks[i] = new LockSupport(type, scope);
            ++i;
        }
        return supportedLocks;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ILock[] createActiveLocks(PropertyElement lockDiscovery) {
        Element activeLock = lockDiscovery.firstChild();
        if (activeLock == null) {
            return new ILock[0];
        }
        ILock[] locks = new ILock[lockDiscovery.countChildren()];
        int i = 0;
        while (activeLock != null) {
            LockImpl lock = new LockImpl();
            lock.path = this.resourcePath;
            Element child = activeLock.firstChild();
            while (child != null) {
                if ("locktype".equals(child.getName())) {
                    lock.type = this.getLockType(child);
                } else if ("lockscope".equals(child.getName())) {
                    lock.scope = this.getLockScope(child);
                } else if ("owner".equals(child.getName())) {
                    lock.owner = child.firstChild().getValue();
                } else if ("timeout".equals(child.getName())) {
                    String timeoutVal = child.getValue();
                    if ("Infinite".equals(timeoutVal)) {
                        lock.timeout = TimeOutVal.INFINITE;
                    } else {
                        if (!timeoutVal.startsWith("Second-")) throw new IllegalArgumentException("invalid timeout format");
                        String seconds = timeoutVal.substring("Second-".length());
                        try {
                            lock.timeout = TimeOutVal.createInSeconds(Long.parseLong(seconds));
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("invalid timeout format");
                        }
                    }
                } else if ("locktoken".equals(child.getName())) {
                    lock.token = child.firstChild().getValue();
                } else if ("depth".equals(child.getName()) && "Inifinity".equals(child.getName())) {
                    lock.isRecursive = true;
                }
                child = child.next();
            }
            locks[i] = lock;
            activeLock = activeLock.next();
            ++i;
        }
        return locks;
    }

    private LockType getLockType(Element type) {
        String typeName = type.firstChild().getName();
        if (LockType.WRITE.getName().equals(typeName)) {
            return LockType.WRITE;
        }
        return null;
    }

    private com.tssap.dtr.client.lib.deltavlib.lock.LockScope getLockScope(Element scope) {
        String scopeName = scope.firstChild().getName();
        if (com.tssap.dtr.client.lib.deltavlib.lock.LockScope.EXCLUSIVE.getName().equals(scopeName)) {
            return com.tssap.dtr.client.lib.deltavlib.lock.LockScope.EXCLUSIVE;
        }
        if (com.tssap.dtr.client.lib.deltavlib.lock.LockScope.SHARED.getName().equals(scopeName)) {
            return com.tssap.dtr.client.lib.deltavlib.lock.LockScope.SHARED;
        }
        return null;
    }

    public ILock[] discoverActiveLocks() throws VcmFailure {
        MultiStatusEntity entity;
        ResourceElement resourceElement;
        PropfindRequest pfind = new PropfindRequest(Encoder.encodePath((String)this.resourcePath), Depth.DEPTH_0);
        pfind.addPropertyGet("lockdiscovery");
        IResponse response = DeltavCommand.execute(this.conTemplID, (IRequest)pfind);
        if (response.getEntityType().equals("MultiStatusEntity") && (resourceElement = (entity = (MultiStatusEntity)response.getEntity()).getResource(0)) != null) {
            PropertyElement lockDiscovery = resourceElement.getProperty("lockdiscovery");
            try {
                return this.createActiveLocks(lockDiscovery);
            }
            catch (IllegalArgumentException e) {
                LOC.errorT(e.toString());
                throw new VcmFailure("invalid server response", e);
            }
        }
        String errorMsg = "invalid server response";
        LOC.errorT(errorMsg);
        throw new VcmFailure(errorMsg);
    }

    public ILock refreshLock(String lockToken) throws VcmFailure {
        if (lockToken == null) {
            throw new NullPointerException();
        }
        LockRequest lock = new LockRequest(this.resourcePath, true);
        DeltavCommand.execute(this.conTemplID, (IRequest)lock);
        PropertyElement lockDiscovery = null;
        ILock[] locks = null;
        try {
            locks = this.createActiveLocks(lockDiscovery);
        }
        catch (IllegalArgumentException e) {
            LOC.errorT(e.toString());
            throw new VcmFailure("invalid server response", e);
        }
        if (locks.length > 0) {
            return locks[0];
        }
        LOC.errorT("no active lock found");
        throw new VcmFailure("client internal error");
    }

    public void releaseLock(String lockToken) throws VcmFailure {
        if (lockToken == null) {
            throw new NullPointerException();
        }
        UnlockRequest unlock = new UnlockRequest(this.resourcePath, lockToken);
        DeltavCommand.execute(this.conTemplID, (IRequest)unlock);
    }

    public ILock acquireLock(com.tssap.dtr.client.lib.deltavlib.lock.LockScope scope, TimeOutVal timeout) throws VcmFailure {
        LockScope protocolScope = null;
        if (com.tssap.dtr.client.lib.deltavlib.lock.LockScope.EXCLUSIVE == scope) {
            protocolScope = LockScope.EXCLUSIVE;
        } else if (com.tssap.dtr.client.lib.deltavlib.lock.LockScope.SHARED == scope) {
            protocolScope = LockScope.SHARED;
        }
        LockRequest lock = new LockRequest(this.resourcePath, protocolScope);
        if (TimeOutVal.INFINITE != timeout) {
            lock.addTimeout(LockTimeout.SECONDS, (int)timeout.getSeconds());
        } else {
            lock.addTimeout(LockTimeout.INFINITE, -1);
        }
        DeltavCommand.execute(this.conTemplID, (IRequest)lock);
        PropertyElement lockDiscovery = null;
        ILock[] locks = null;
        try {
            locks = this.createActiveLocks(lockDiscovery);
        }
        catch (IllegalArgumentException e) {
            LOC.errorT(e.toString());
            throw new VcmFailure("invalid server response", e);
        }
        if (locks.length > 0) {
            return locks[0];
        }
        LOC.errorT("no active lock received");
        throw new VcmFailure("client internal error");
    }

    public LockSupport[] getSupportedLocks() throws VcmFailure {
        MultiStatusEntity entity;
        ResourceElement resourceElement;
        PropfindRequest pfind = new PropfindRequest(Encoder.encodePath((String)this.resourcePath), Depth.DEPTH_0);
        pfind.addPropertyGet("supportedlock");
        IResponse response = DeltavCommand.execute(this.conTemplID, (IRequest)pfind);
        if (response.isMultiStatus() && (resourceElement = (entity = (MultiStatusEntity)response.getEntity()).getResource(0)) != null) {
            PropertyElement lockDiscovery = resourceElement.getProperty("lockdiscovery");
            try {
                return this.createLockSupportEntries(lockDiscovery);
            }
            catch (IllegalArgumentException e) {
                LOC.errorT(e.toString());
                throw new VcmFailure("invalid server response", e);
            }
        }
        String errorMsg = "invalid server response";
        LOC.errorT(errorMsg);
        throw new VcmFailure(errorMsg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class LockImpl
    implements ILock {
        String owner;
        String path;
        String token;
        com.tssap.dtr.client.lib.deltavlib.lock.LockScope scope;
        LockType type;
        TimeOutVal timeout;
        boolean isRecursive;

        LockImpl() {
        }

        public String getOwner() {
            return this.owner;
        }

        public String getResourcePath() {
            return this.path;
        }

        public com.tssap.dtr.client.lib.deltavlib.lock.LockScope getScope() {
            return this.scope;
        }

        public TimeOutVal getTimeout() {
            return this.timeout;
        }

        public String getToken() {
            return this.token;
        }

        public LockType getType() {
            return this.type;
        }

        public boolean isRecursive() {
            return this.isRecursive;
        }
    }
}

