/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.IAssociatedResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.ICheckedOutResource;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.impl.PropFindLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.ResFactoryMgrImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.util.EmptyArray;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.dav.PropfindRequest;
import java.util.Iterator;

public class ResourceByRefFactoryImpl
implements IAssociatedResourceFactory {
    private String[] getPropertyHrefs(IResource source, String propertyName) throws VcmFailure {
        PropertyElement nextProp;
        int size;
        ResourceElement res;
        PropfindRequest pfind = new PropfindRequest(source.getEncodedPath());
        pfind.setDepth(Depth.DEPTH_0);
        String namespaceURI = PropertyUtil.getNamespaceURI(propertyName);
        if (namespaceURI == null) {
            pfind.addPropertyGet(propertyName);
        } else {
            pfind.addPropertyGet(propertyName, namespaceURI);
        }
        DeltavCommand.execute(source.getConnectionTemplID(), (IRequest)pfind);
        Iterator resources = pfind.getResources();
        ResourceElement resourceElement = res = resources != null && resources.hasNext() ? (ResourceElement)resources.next() : null;
        if (res == null) {
            return EmptyArray.STRING_ARRAY;
        }
        Iterator props = res.getProperties();
        if (props == null) {
            return null;
        }
        String[] hrefs = null;
        if (props.hasNext() && (size = (nextProp = (PropertyElement)props.next()).countChildren()) > 0) {
            hrefs = new String[size];
            Element child = nextProp.firstChild();
            int i = 0;
            while (child != null) {
                hrefs[i] = child.getValue();
                child = child.next();
                ++i;
            }
        }
        return hrefs;
    }

    public ICheckedOutResource[] createCoResourcesFromReference(IResource source, String referenceName) throws VcmFailure {
        String[] hrefs = this.getPropertyHrefs(source, referenceName);
        if (hrefs != null) {
            ICheckedOutResource[] coResources = new ICheckedOutResource[hrefs.length];
            IResourceFactory pxyFactory = ResFactoryMgrImpl.getInstance().getProxyFactory();
            int i = 0;
            while (i < hrefs.length) {
                coResources[i] = pxyFactory.createCheckedOutResource(source.getConnectionTemplID(), hrefs[i], PathEncodingFlag.ENCODED);
                ++i;
            }
            return coResources;
        }
        return EmptyArray.CHECKOUT_SET;
    }

    public IWorkspace[] createWorkspacesFromReference(IResource source, String referenceName) throws VcmFailure {
        String[] hrefs = this.getPropertyHrefs(source, referenceName);
        if (hrefs != null) {
            IWorkspace[] wrksps = new IWorkspace[hrefs.length];
            IResourceFactory pxyFactory = ResFactoryMgrImpl.getInstance().getProxyFactory();
            int i = 0;
            while (i < hrefs.length) {
                wrksps[i] = pxyFactory.createWorkspace(source.getConnectionTemplID(), hrefs[i], PathEncodingFlag.ENCODED);
                ++i;
            }
            return wrksps;
        }
        return new IWorkspace[0];
    }

    public IVersion[] createVersionsFromReference(IResource source, String referenceName) throws VcmFailure {
        String[] hrefs = this.getPropertyHrefs(source, referenceName);
        if (hrefs != null) {
            IVersion[] versions = new IVersion[hrefs.length];
            IResourceFactory pxyFactory = ResFactoryMgrImpl.getInstance().getProxyFactory();
            int i = 0;
            while (i < hrefs.length) {
                versions[i] = pxyFactory.createVersion(source.getConnectionTemplID(), hrefs[i], PathEncodingFlag.ENCODED);
                ++i;
            }
            return versions;
        }
        return EmptyArray.VERSION_SET;
    }

    public IActivity[] createActivitiesFromReference(IResource source, String referenceName) throws VcmFailure {
        String[] hrefs = this.getPropertyHrefs(source, referenceName);
        if (hrefs != null) {
            IActivity[] activities = new IActivity[hrefs.length];
            IResourceFactory pxyFactory = ResFactoryMgrImpl.getInstance().getProxyFactory();
            int i = 0;
            while (i < hrefs.length) {
                activities[i] = pxyFactory.createActivity(source.getConnectionTemplID(), hrefs[i], PathEncodingFlag.ENCODED);
                ++i;
            }
            return activities;
        }
        return EmptyArray.ACTIVITY_SET;
    }

    public IVersionControlledResource[] createVcrResourcesFromReference(IResource source, String referenceName) throws VcmFailure {
        String[] hrefs = this.getPropertyHrefs(source, referenceName);
        if (hrefs != null) {
            IVersionControlledResource[] vcrs = new IVersionControlledResource[hrefs.length];
            IResourceFactory pxyFactory = ResFactoryMgrImpl.getInstance().getProxyFactory();
            int i = 0;
            while (i < hrefs.length) {
                vcrs[i] = pxyFactory.createVCR(source.getConnectionTemplID(), hrefs[i], PathEncodingFlag.ENCODED);
                ++i;
            }
            return vcrs;
        }
        return new IVersionControlledResource[0];
    }

    public ICollection[] createCollectionsFromReference(IResource source, String referenceName) throws VcmFailure {
        String[] hrefs = this.getPropertyHrefs(source, referenceName);
        if (hrefs != null) {
            ICollection[] collections = new ICollection[hrefs.length];
            IResourceFactory pxyFactory = ResFactoryMgrImpl.getInstance().getProxyFactory();
            int i = 0;
            while (i < hrefs.length) {
                collections[i] = pxyFactory.createCollection(source.getConnectionTemplID(), hrefs[i], PathEncodingFlag.ENCODED);
                ++i;
            }
            return collections;
        }
        return new ICollection[0];
    }

    public String[] createResourcePathsFromReference(IResource source, String referenceName) throws VcmFailure {
        return PropFindLoader.findHrefProperty(source.getConnectionTemplID(), source.getEncodedPath(), referenceName);
    }
}

