/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.IActivityCollection;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IPrincipalCollection;
import com.tssap.dtr.client.lib.deltavlib.IRepositoryFunctionality;
import com.tssap.dtr.client.lib.deltavlib.IRepositoryOptions;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.PrincipalImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.ResFactoryMgrImpl;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.dav.PropfindRequest;
import com.tssap.dtr.client.lib.protocol.requests.http.OptionsRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RepositoryOptionsImpl
implements IRepositoryOptions {
    private String[] getHrefChildren(Element hrefSet) {
        int numOfChild = hrefSet.countChildren();
        String[] hrefs = new String[numOfChild];
        if (numOfChild == 0) {
            return null;
        }
        Element child = hrefSet.firstChild();
        int i = 0;
        while (child != null) {
            hrefs[i] = child.getValue();
            child = child.next();
            ++i;
        }
        return hrefs;
    }

    public ICollection[] getWorskpaceCollectionSet(int conTemplID, String requestUri) throws VcmFailure {
        return this.getOptionsCollectionSet(conTemplID, requestUri, 1);
    }

    public IActivityCollection[] getActivityCollectionSet(int conTemplID, String requestUri) throws VcmFailure {
        return (IActivityCollection[])this.getOptionsCollectionSet(conTemplID, requestUri, 4);
    }

    public ICollection[] getVersionHistoryCollectionSet(int conTemplID, String requestUri) throws VcmFailure {
        return this.getOptionsCollectionSet(conTemplID, requestUri, 2);
    }

    public IPrincipalCollection[] getPrincipalCollectionSet(int conTemplID, String requestUri) throws VcmFailure {
        String pcolSeTagName = "principal-collection-set";
        PropfindRequest pfind = new PropfindRequest(requestUri, Depth.DEPTH_0);
        pfind.addPropertyGet(pcolSeTagName);
        DeltavCommand.execute(conTemplID, (IRequest)pfind);
        String[] hrefs = null;
        Iterator resources = pfind.getResources();
        if (resources != null && resources.hasNext()) {
            ResourceElement res = (ResourceElement)resources.next();
            Iterator props = res.getProperties();
            while (props.hasNext()) {
                PropertyElement nextProp = (PropertyElement)props.next();
                if (!nextProp.getNamespaceURI().equals("DAV:") || !nextProp.getName().equals(pcolSeTagName) || (hrefs = this.getHrefChildren((Element)nextProp)) != null) continue;
                return new IPrincipalCollection[0];
            }
        }
        if (hrefs != null) {
            IPrincipalCollection[] pcols = new IPrincipalCollection[hrefs.length];
            int i = 0;
            while (i < hrefs.length) {
                try {
                    pcols[i] = new PrincipalImpl(conTemplID, (String)hrefs[i]);
                }
                catch (InvalidPathException e) {
                    throw new VcmFailure("client internal error", e);
                }
                ++i;
            }
            return pcols;
        }
        return new IPrincipalCollection[0];
    }

    private ICollection[] getOptionsCollectionSet(int conTemplID, String reqestURI, int optionsFlag) throws VcmFailure {
        OptionsRequest options = new OptionsRequest(reqestURI, optionsFlag);
        DeltavCommand.execute(conTemplID, (IRequest)options);
        Element colSetElement = options.getCollectionSet(optionsFlag);
        if (colSetElement == null) {
            return null;
        }
        ICollection[] colset = null;
        int size = colSetElement.countChildren();
        IResourceFactory pxyFactory = ResFactoryMgrImpl.getInstance().getProxyFactory();
        int i = 0;
        Element child = colSetElement.firstChild();
        while (child != null) {
            String path = child.getValue();
            switch (optionsFlag) {
                case 4: {
                    if (colset == null) {
                        colset = new IActivityCollection[size];
                    }
                    colset[i++] = pxyFactory.createActivityCollection(conTemplID, path);
                    break;
                }
                default: {
                    if (colset == null) {
                        colset = new ICollection[size];
                    }
                    colset[i++] = pxyFactory.createCollection(conTemplID, path, PathEncodingFlag.ENCODED);
                }
            }
            child = child.next();
        }
        return colset;
    }

    public IRepositoryFunctionality[] getFunctionalitySet(int conTemplID, List functionalityNames) throws VcmFailure {
        OptionsRequest optionsRequest = new OptionsRequest("", functionalityNames, false);
        DeltavCommand.execute(conTemplID, (IRequest)optionsRequest);
        List functionalityNameList = optionsRequest.getFunctionalitySet();
        if (functionalityNameList == null || functionalityNameList.size() == 0) {
            return new IRepositoryFunctionality[0];
        }
        IRepositoryFunctionality[] functionalitySet = new IRepositoryFunctionality[functionalityNameList.size()];
        int count = 0;
        Iterator iter = functionalityNameList.iterator();
        while (iter.hasNext()) {
            String functionalityName = (String)iter.next();
            List functionalityOptions = optionsRequest.getFunctionality(functionalityName);
            functionalitySet[count++] = new RepositoryFunctionalityImpl(functionalityName, functionalityOptions);
        }
        return functionalitySet;
    }

    public IRepositoryFunctionality getFunctionality(int conTemplID, String functionalityName) throws VcmFailure {
        ArrayList<String> functionalityList = new ArrayList<String>();
        functionalityList.add(functionalityName);
        OptionsRequest optionsRequest = new OptionsRequest("", functionalityList, false);
        DeltavCommand.execute(conTemplID, (IRequest)optionsRequest);
        List functionalityNameList = optionsRequest.getFunctionalitySet();
        if (functionalityNameList == null || functionalityNameList.size() == 0) {
            return null;
        }
        return new RepositoryFunctionalityImpl((String)functionalityNameList.get(0), optionsRequest.getFunctionality((String)functionalityNameList.get(0)));
    }

    static class RepositoryFunctionalityImpl
    implements IRepositoryFunctionality {
        private String m_name;
        private HashMap m_options;

        public RepositoryFunctionalityImpl(String name, List options) {
            this.m_name = name;
            this.m_options = new HashMap();
            if (options == null || options.size() == 0) {
                return;
            }
            Iterator iter = options.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                this.m_options.put(element, element);
            }
        }

        public String getName() {
            return this.m_name;
        }

        public String[] getOptions() {
            return this.m_options.values().toArray(new String[this.m_options.size()]);
        }

        public boolean containsOption(String optionName) {
            return this.m_options.get(optionName) != null;
        }
    }
}

