/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

public abstract class RawPropertyParser {
    public abstract PropertyElement parseValue(PropertyElement var1);

    public static RawPropertyParser createParser() {
        return new Delegator();
    }

    private static class QName {
        String lname;
        String ns;

        QName() {
        }

        QName(String name, String ns) {
            this.lname = name;
            this.ns = ns;
        }

        public int hashCode() {
            int result = 37;
            result = 37 * result + this.lname.hashCode();
            result = 37 * result + this.ns.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (o instanceof QName) {
                QName another = (QName)o;
                return this.lname.equals(another.lname) && this.ns.equals(another.ns);
            }
            return false;
        }
    }

    static class DebugParser
    extends RawPropertyParser {
        DebugParser() {
        }

        public PropertyElement parseValue(PropertyElement rawProperty) {
            boolean stop = false;
            return rawProperty;
        }
    }

    static class HrefParser
    extends RawPropertyParser {
        HrefParser() {
        }

        public PropertyElement parseValue(PropertyElement rawProperty) {
            String val = rawProperty.getValue();
            rawProperty.setValue(null);
            Element childHref = new Element("href", "DAV:");
            childHref.setValue(val);
            rawProperty.addChild(childHref);
            return rawProperty;
        }
    }

    static class Delegator
    extends RawPropertyParser {
        private static final Map rawParserMap = new Hashtable();
        private QName qname = new QName();
        private ArrayList propList;
        private int propIndex;

        Delegator() {
        }

        public void addProperty(String localName, String namespaceUri) {
            if (this.propList == null) {
                this.propList = new ArrayList();
            }
            this.propList.add(new QName(localName, namespaceUri));
        }

        public PropertyElement parseValue(PropertyElement rawProperty) {
            if (rawProperty.getStatusCode() != 200) {
                return rawProperty;
            }
            RawPropertyParser parser = this.getParser(rawProperty);
            return parser != null ? parser.parseValue(rawProperty) : rawProperty;
        }

        private RawPropertyParser getParser(PropertyElement rawProperty) {
            this.qname.lname = rawProperty.getName();
            this.qname.ns = rawProperty.getNamespaceURI();
            return (RawPropertyParser)rawParserMap.get(this.qname);
        }

        static {
            HrefParser hrefParser = new HrefParser();
            rawParserMap.put(new QName(DAV.CHECKED_IN.localName, "DAV:"), hrefParser);
            rawParserMap.put(new QName(DAV.WORKSPACE.localName, "DAV:"), hrefParser);
            rawParserMap.put(new QName(XCM.EXCLUSIVE_CHECKOUT.localName, XCM.NAMESPACE_URI), hrefParser);
        }
    }
}

