/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IElement;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableElement;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.protocol.util.Encoder;

abstract class PropertyFlyweight {
    protected PropertyFlyweight() {
    }

    private static StringBuffer getElementAsXmlFragment(StringBuffer buf, IElement element) {
        IElement firstChild = element.getFirstChild();
        String value = element.getValue();
        if (element.getValue() == null && element.getFirstChild() == null) {
            buf.append('<');
            buf.append(element.getQualifiedName());
            buf.append("/>");
        } else {
            buf.append('<');
            buf.append(element.getQualifiedName());
            buf.append('>');
            if (value != null) {
                buf.append(Encoder.encodeXml((String)value));
            }
            if (firstChild != null) {
                IElement current = firstChild;
                while (current != null) {
                    PropertyFlyweight.getElementAsXmlFragment(buf, current);
                    current = current.getNext();
                }
            }
            buf.append("</");
            buf.append(element.getQualifiedName());
            buf.append('>');
        }
        return buf;
    }

    private static StringBuffer getPropertyAsXmlFragment(StringBuffer buf, IProperty property) {
        IElement firstChild = property.getFirstChild();
        String value = property.getValue();
        if (value == null && property.getFirstChild() == null) {
            buf.append('<');
            buf.append(property.getQualifiedName());
            buf.append("/>");
        } else {
            buf.append('<');
            buf.append(property.getQualifiedName());
            buf.append('>');
            if (value != null) {
                buf.append(Encoder.encodeXml((String)value));
            }
            if (firstChild != null) {
                IElement current = firstChild;
                while (current != null) {
                    PropertyFlyweight.getElementAsXmlFragment(buf, current);
                    current = current.getNext();
                }
            }
            buf.append("</");
            buf.append(property.getQualifiedName());
            buf.append('>');
        }
        return buf;
    }

    static class StringProperty
    extends EmptyProperty {
        private String value;

        StringProperty(String namespace, String name, String value) {
            super(namespace, name);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    static class SingleDavHrefProperty
    extends AbstractBase
    implements IProperty {
        private IElement firstChild;

        public SingleDavHrefProperty(String namespace, String name, SingleDavHrefElement hrefElement) {
            super(namespace, name);
            if (hrefElement == null) {
                throw new NullPointerException();
            }
            this.firstChild = hrefElement;
        }

        public SingleDavHrefProperty(String namespace, String name, String value) {
            super(namespace, name);
            this.firstChild = new SingleDavHrefElement(value);
        }

        public StringBuffer getAsXmlFragment(StringBuffer buf) {
            return PropertyFlyweight.getPropertyAsXmlFragment(buf, this);
        }

        public IElement getFirstChild() {
            return this.firstChild;
        }

        public int getChildCount() {
            return 1;
        }
    }

    static class SingleDavHrefElement
    implements IElement {
        private static final String HREF_NAME = DAV.HREF.localName;
        private static final String HREF_QUALIFID_NAME = DAV.HREF.qualifiedName;
        public final String value;

        SingleDavHrefElement(String val) {
            this.value = val;
        }

        public StringBuffer getAsXmlFragment(StringBuffer buf) {
            return PropertyFlyweight.getElementAsXmlFragment(buf, this);
        }

        public int getChildCount() {
            return 0;
        }

        public IElement getFirstChild() {
            return null;
        }

        public String getName() {
            return HREF_NAME;
        }

        public String getNamespace() {
            return "DAV";
        }

        public IElement getNext() {
            return null;
        }

        public String getQualifiedName() {
            return HREF_QUALIFID_NAME;
        }

        public String getValue() {
            return this.value;
        }

        public void addNextChild(IMutableElement newChild) {
            throw new UnsupportedOperationException();
        }

        public boolean equal(Object o) {
            if (o instanceof IElement) {
                IElement prop = (IElement)o;
                return "DAV".equals(prop.getNamespace()) && HREF_NAME.equals(prop.getName());
            }
            return false;
        }

        public int hashCode() {
            return "DAV".hashCode() + HREF_NAME.hashCode();
        }

        public String toString() {
            if (this.value != null) {
                return Encoder.decodePath((String)this.value);
            }
            return null;
        }
    }

    static class EmptyProperty
    extends AbstractBase
    implements IProperty {
        EmptyProperty(String namespace, String name) {
            super(namespace, name);
        }

        public StringBuffer getAsXmlFragment(StringBuffer buf) {
            return PropertyFlyweight.getPropertyAsXmlFragment(buf, this);
        }
    }

    static class DavHrefProperty
    extends AbstractBase
    implements IProperty {
        private int childCount;
        private IElement firstChild;

        DavHrefProperty(String namespace, String name, String[] hrefs) {
            super(namespace, name);
            this.setHrefs(hrefs);
        }

        private void setHrefs(String[] hrefs) {
            if (hrefs == null) {
                throw new NullPointerException();
            }
            this.childCount = hrefs.length;
            DavHrefElement next = null;
            int i = hrefs.length - 1;
            while (i >= 0) {
                next = new DavHrefElement(hrefs[i], next);
                --i;
            }
            this.firstChild = next;
        }

        public int getChildCount() {
            return this.childCount;
        }

        public StringBuffer getAsXmlFragment(StringBuffer buf) {
            return PropertyFlyweight.getPropertyAsXmlFragment(buf, this);
        }

        public IElement getFirstChild() {
            return this.firstChild;
        }
    }

    static class DavHrefElement
    extends SingleDavHrefElement {
        private IElement next;

        DavHrefElement(String value, IElement next) {
            super(value);
            this.next = next;
        }

        public IElement getNext() {
            return this.next;
        }
    }

    protected static abstract class AbstractBase {
        protected String namespace;
        protected String name;

        public AbstractBase(String namespace, String name) {
            if (name == null) {
                throw new NullPointerException("null property name");
            }
            this.namespace = namespace == null ? "DAV" : namespace;
            this.name = name;
        }

        public abstract StringBuffer getAsXmlFragment(StringBuffer var1);

        public boolean equals(Object o) {
            if (o instanceof IProperty) {
                IProperty prop = (IProperty)o;
                return this.namespace.equals(prop.getNamespace()) && this.name.equals(prop.getName());
            }
            return false;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return null;
        }

        public int getChildCount() {
            return 0;
        }

        public IElement getFirstChild() {
            return null;
        }

        public String getQualifiedName() {
            return this.getQualifiedName(new StringBuffer()).toString();
        }

        public StringBuffer getQualifiedName(StringBuffer buf) {
            if (this.namespace != null) {
                buf.append(this.namespace).append(':');
            }
            buf.append(this.name);
            return buf;
        }

        public int hashCode() {
            if (this.namespace == null) {
                return this.name.hashCode();
            }
            int result = 17;
            result = 37 * result + this.namespace.hashCode();
            result = 37 * result + this.name.hashCode();
            return result;
        }
    }
}

