/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.impl.PropertyFlyweight;
import com.tssap.dtr.client.lib.deltavlib.properties.IElement;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableElement;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyFactory;
import com.tssap.dtr.client.lib.protocol.util.Encoder;

public class PropertyFactoryImpl
implements IPropertyFactory {
    private static final IPropertyFactory INSTANCE = new PropertyFactoryImpl();

    protected PropertyFactoryImpl() {
    }

    public static IPropertyFactory getInstance() {
        return INSTANCE;
    }

    public IMutableProperty createDavProperty(String name) {
        return new Property("DAV", name);
    }

    public IMutableProperty createProperty(String namespace, String name) {
        return new Property(namespace, name);
    }

    public IMutableElement createDavElement(String name) {
        return new PropElement("DAV", name);
    }

    public IMutableElement createElement(String namespace, String name) {
        return new PropElement(namespace, name);
    }

    public IProperty createDavHrefProperty(String namespace, String name, String hrefVal) {
        return new PropertyFlyweight.SingleDavHrefProperty(namespace, name, hrefVal);
    }

    public IProperty createDavHrefSetProperty(String namespace, String name, String[] values) {
        return new PropertyFlyweight.DavHrefProperty(namespace, name, values);
    }

    public IProperty createStringProperty(String namespace, String name, String value) {
        return new PropertyFlyweight.StringProperty(namespace, name, value);
    }

    public IProperty createEmptyProperty(String namespace, String name) {
        return new PropertyFlyweight.EmptyProperty(namespace, name);
    }

    private static StringBuffer getElementAsXmlFragment(StringBuffer buf, IElement element) {
        IElement firstChild = element.getFirstChild();
        String value = element.getValue();
        if (element.getValue() == null && element.getFirstChild() == null) {
            buf.append('<');
            buf.append(element.getQualifiedName());
            buf.append("/>");
        } else {
            buf.append('<');
            buf.append(element.getQualifiedName());
            buf.append('>');
            if (value != null) {
                buf.append(Encoder.encodeXml((String)value));
            }
            if (firstChild != null) {
                IElement current = firstChild;
                while (current != null) {
                    PropertyFactoryImpl.getElementAsXmlFragment(buf, current);
                    current = current.getNext();
                }
            }
            buf.append("</");
            buf.append(element.getQualifiedName());
            buf.append('>');
        }
        return buf;
    }

    private static StringBuffer getPropertyAsXmlFragment(StringBuffer buf, IProperty property) {
        IElement firstChild = property.getFirstChild();
        String value = property.getValue();
        if (value == null && property.getFirstChild() == null) {
            buf.append('<');
            buf.append(property.getQualifiedName());
            buf.append("/>");
        } else {
            buf.append('<');
            buf.append(property.getQualifiedName());
            buf.append('>');
            if (value != null) {
                buf.append(Encoder.encodeXml((String)value));
            }
            if (firstChild != null) {
                IElement current = firstChild;
                while (current != null) {
                    PropertyFactoryImpl.getElementAsXmlFragment(buf, current);
                    current = current.getNext();
                }
            }
            buf.append("</");
            buf.append(property.getQualifiedName());
            buf.append('>');
        }
        return buf;
    }

    private static class PropElement
    extends PropertyFlyweight.AbstractBase
    implements IMutableElement {
        private String value;
        private IMutableElement firstChild;
        private IMutableElement next;
        private int childCount;

        public PropElement(String namespace, String name) {
            super(namespace, name);
        }

        public boolean equals(Object o) {
            if (o instanceof IElement) {
                IElement prop = (IElement)o;
                return this.namespace.equals(prop.getNamespace()) && this.name.equals(prop.getName());
            }
            return false;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void clear() {
            this.value = null;
            this.firstChild = null;
            this.childCount = 0;
        }

        public int getChildCount() {
            return this.childCount;
        }

        public IElement getFirstChild() {
            return this.firstChild;
        }

        public IElement getNext() {
            return this.next;
        }

        public StringBuffer getAsXmlFragment(StringBuffer buf) {
            return PropertyFactoryImpl.getElementAsXmlFragment(buf, this);
        }

        public void addNextChild(IMutableElement newChild) {
            if (newChild == null) {
                throw new NullPointerException();
            }
            if (this.firstChild == null) {
                this.firstChild = newChild;
            } else {
                IMutableElement lastChild = this.firstChild;
                int i = 0;
                while (i < this.childCount - 1) {
                    lastChild = lastChild.getNextToModify();
                    ++i;
                }
                lastChild.setNext(newChild);
            }
            ++this.childCount;
        }

        public IMutableElement getFirstChildToModify() {
            return this.firstChild;
        }

        public IMutableElement getNextToModify() {
            return this.next;
        }

        public void setFirstChild(IMutableElement element) {
            this.childCount = 0;
            if (element != null) {
                this.firstChild = element;
                IElement child = this.firstChild.getFirstChild();
                while (child != null) {
                    ++this.childCount;
                    child = child.getNext();
                }
            } else {
                this.firstChild = null;
            }
        }

        public void setNext(IMutableElement next) {
            this.next = next;
        }
    }

    protected static class Property
    extends PropertyFlyweight.AbstractBase
    implements IMutableProperty {
        private String value;
        private int childCount;
        private IMutableElement firstChild;

        public Property(String namespace, String name) {
            super(namespace, name);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void clear() {
            this.value = null;
            this.firstChild = null;
            this.childCount = 0;
        }

        public int getChildCount() {
            return this.childCount;
        }

        public IElement getFirstChild() {
            return this.firstChild;
        }

        public boolean equals(Object o) {
            if (o instanceof IProperty) {
                IProperty prop = (IProperty)o;
                return this.namespace.equals(prop.getNamespace()) && this.name.equals(prop.getName());
            }
            return false;
        }

        public StringBuffer getAsXmlFragment(StringBuffer buf) {
            return PropertyFactoryImpl.getPropertyAsXmlFragment(buf, this);
        }

        public String getQualifiedName() {
            return this.getQualifiedName(new StringBuffer()).toString();
        }

        public StringBuffer getQualifiedName(StringBuffer buf) {
            if (this.namespace != null) {
                buf.append(this.namespace).append(':');
            }
            buf.append(this.name);
            return buf;
        }

        public void addNextChild(IMutableElement newChild) {
            if (newChild == null) {
                throw new NullPointerException();
            }
            if (this.firstChild == null) {
                this.firstChild = newChild;
            } else {
                IMutableElement lastChild = this.firstChild;
                int i = 0;
                while (i < this.childCount - 1) {
                    lastChild = lastChild.getNextToModify();
                    ++i;
                }
                lastChild.setNext(newChild);
            }
            ++this.childCount;
        }

        public IMutableElement getFirstChildToModify() {
            return this.firstChild;
        }

        public void setFirstChild(IMutableElement element) {
            this.childCount = 0;
            if (element != null) {
                this.firstChild = element;
                IElement child = this.firstChild.getFirstChild();
                while (child != null) {
                    ++this.childCount;
                    child = child.getNext();
                }
            } else {
                this.firstChild = null;
            }
        }
    }
}

