/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.impl.AbstractResourceLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.ResourceMetaClass;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyReport;
import java.util.Iterator;

public class PropertyExpander
extends AbstractResourceLoader {
    private ExpandPropertyReport report;
    private ResourceMetaClass metaClass;
    private ExpandPropertyDef rootProp;

    public static ExpandPropertyDef expandProperty(String expandedPropertyName, String[] selectProperties) {
        ExpandPropertyDef parent = new ExpandPropertyDef(expandedPropertyName, PropertyUtil.getNamespaceURI(expandedPropertyName));
        int i = 0;
        while (i < selectProperties.length) {
            String qualifiedName = selectProperties[i];
            parent.addChild(new ExpandPropertyDef(qualifiedName, PropertyUtil.getNamespaceURI(qualifiedName)));
            ++i;
        }
        return parent;
    }

    public PropertyExpander(String path, String propToExpand, ResourceMetaClass metaClass) {
        if (path == null || propToExpand == null || metaClass == null) {
            throw new NullPointerException();
        }
        this.report = new ExpandPropertyReport(path);
        this.rootProp = this.report.addPropertyExpand(propToExpand, PropertyUtil.getNamespaceURI(propToExpand), null);
        this.metaClass = metaClass;
    }

    protected void addPropertyNS(String nsPrefix, String nsUri) {
    }

    protected void addPropertyToLoad(String qualifiedName) {
        int pos = qualifiedName.indexOf(58);
        if (pos < 0) {
            this.report.addPropertyExpand(qualifiedName, this.rootProp);
        } else {
            this.report.addPropertyExpand(PropertyUtil.getLocalName(qualifiedName), PropertyUtil.getNamespaceURI(qualifiedName), this.rootProp);
        }
    }

    protected IRequest getRequest() {
        return this.report;
    }

    protected ResourceMetaClass getResourceMetaClass() {
        return this.metaClass;
    }

    protected Iterator setResponseResources(MultiStatusEntity responseEntity) {
        PropertyElement expandedProp;
        ResourceElement rootResource = responseEntity.getResource(0);
        if (rootResource == null) {
            return null;
        }
        Iterator props = rootResource.getProperties();
        PropertyElement propertyElement = expandedProp = props != null && props.hasNext() ? (PropertyElement)props.next() : null;
        if (expandedProp != null) {
            this.setSize(expandedProp.countExpandedResources());
            if (this.size() > 0) {
                return expandedProp.getExpandedResources();
            }
            return null;
        }
        return null;
    }
}

