/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IFile;
import com.tssap.dtr.client.lib.deltavlib.IPersistentResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.ActivityImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.CollectionImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.impl.FileImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.ResFactoryMgrImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.WorkspaceImpl;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.MkActivityRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.MkWorkspaceRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.io.InputStream;

public class PersistentResourceFactoryImpl
implements IPersistentResourceFactory {
    private static final PropertyElement FILE_RESOURCETYPE = new PropertyElement(DAV.RESOURCETYPE.localName, "DAV:");
    private static final PropertyElement COLLECTION_RESOURCETYPE = new PropertyElement(DAV.RESOURCETYPE.localName, "DAV:");
    private static final String OPEN_VERSION_SET = "open";
    private static final String CLOSED_VERSION_SET = "closed";

    private IResourceFactoryManager factoryManager() {
        return ResFactoryMgrImpl.getInstance();
    }

    public IActivity createActivity(int conTemplID, String path) throws VcmFailure {
        String encodedPath = Encoder.encodePath((String)path);
        MkActivityRequest mkactivity = new MkActivityRequest(encodedPath);
        DeltavCommand.execute(conTemplID, (IRequest)mkactivity);
        try {
            ActivityImpl activity = new ActivityImpl(conTemplID, encodedPath);
            PropertyElement isClosedProp = new PropertyElement(XCM.VERSION_SET_STATE.qualifiedName, XCM.NAMESPACE_URI);
            isClosedProp.setValue(OPEN_VERSION_SET);
            isClosedProp.setStatusCode(200);
            activity.localSetProperty(isClosedProp);
            return activity;
        }
        catch (InvalidPathException e) {
            throw new VcmFailure("client internal error", e);
        }
    }

    public ICollection createCollection(int conTemplID, String path) throws VcmFailure {
        String encodedPath = Encoder.encodePath((String)path);
        CollectionImpl.mkCollection(conTemplID, encodedPath);
        try {
            CollectionImpl collection = new CollectionImpl(conTemplID, encodedPath);
            collection.localSetProperty(COLLECTION_RESOURCETYPE);
            return collection;
        }
        catch (InvalidPathException e) {
            throw new VcmFailure("client internal error", e);
        }
    }

    public IFile createFile(int conTemplID, String path, InputStream dataContent, String contentType, long length) throws VcmFailure {
        String encodedPath = Encoder.encodePath((String)path);
        FileImpl.setContent(conTemplID, encodedPath, dataContent, contentType, length);
        try {
            FileImpl file = new FileImpl(conTemplID, encodedPath);
            file.localSetProperty(FILE_RESOURCETYPE);
            return file;
        }
        catch (InvalidPathException e) {
            throw new VcmFailure("client internal error", e);
        }
    }

    public IWorkspace createWorkspace(int conTemplID, String path) throws VcmFailure {
        String encodedPath = Encoder.encodePath((String)path);
        MkWorkspaceRequest mkwrkspc = new MkWorkspaceRequest(encodedPath);
        DeltavCommand.execute(conTemplID, (IRequest)mkwrkspc);
        try {
            WorkspaceImpl ws = new WorkspaceImpl(conTemplID, encodedPath);
            PropertyElement hrefProp = new PropertyElement(DAV.WORKSPACE.qualifiedName, "DAV:");
            hrefProp.addChild((Element)new PropertyElement(DAV.HREF.qualifiedName, "DAV:")).setValue(ws.getEncodedPath());
            hrefProp.setStatusCode(200);
            ws.localSetProperty(hrefProp);
            ws.localSetProperty(COLLECTION_RESOURCETYPE);
            return ws;
        }
        catch (InvalidPathException e) {
            throw new VcmFailure("client internal error", e);
        }
    }

    static {
        FILE_RESOURCETYPE.setStatusCode(200);
        COLLECTION_RESOURCETYPE.setStatusCode(200);
        COLLECTION_RESOURCETYPE.addChild((Element)new PropertyElement("collection", "DAV:"));
    }
}

