/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.IMergeConflict;
import com.tssap.dtr.client.lib.deltavlib.IMergePreview;
import com.tssap.dtr.client.lib.deltavlib.IMergeUpdate;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.ResFactoryMgrImpl;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.MergePreviewEntity;
import java.util.ArrayList;
import java.util.Iterator;

public class MergeImpl
implements IMergePreview {
    private Iterator updateIt;
    private Iterator conflictIt;
    private Iterator ignoreIt;

    public MergeImpl(int conTemplID, MergePreviewEntity previewResponse) throws VcmFailure {
        if (previewResponse == null) {
            throw new NullPointerException();
        }
        Iterator entries = previewResponse.getResources();
        if (entries != null || previewResponse.countResources() > 0) {
            this.initialize(entries, conTemplID);
        }
    }

    private void initialize(Iterator previewEntries, int conTemplID) throws VcmFailure {
        ArrayList<Update> updates = null;
        ArrayList<Conflict> conflicts = null;
        ArrayList<IVersion> ignores = null;
        IResourceFactory proxyFactory = ResFactoryMgrImpl.getInstance().getProxyFactory();
        while (previewEntries.hasNext()) {
            Element nextEntry = (Element)previewEntries.next();
            IVersion version = null;
            IVersion commonAncestor = null;
            IVersionControlledResource target = null;
            Element child = nextEntry.firstChild();
            while (child != null) {
                if ("version".equals(child.getName())) {
                    version = proxyFactory.createVersion(conTemplID, child.firstChild().getValue());
                }
                if ("target".equals(child.getName())) {
                    target = proxyFactory.createVCR(conTemplID, child.firstChild().getValue());
                }
                if ("common-ancestor".equals(child.getName())) {
                    commonAncestor = proxyFactory.createVersion(conTemplID, child.firstChild().getValue());
                }
                child = child.next();
            }
            if ("update-preview".equals(nextEntry.getName())) {
                if (updates == null) {
                    updates = new ArrayList<Update>();
                }
                updates.add(new Update(version, target));
                continue;
            }
            if ("conflict-preview".equals(nextEntry.getName())) {
                if (conflicts == null) {
                    conflicts = new ArrayList<Conflict>();
                }
                conflicts.add(new Conflict(version, commonAncestor, target));
                continue;
            }
            if (!"ignore-preview".equals(nextEntry.getName())) continue;
            if (ignores == null) {
                ignores = new ArrayList<IVersion>();
            }
            IVersion ver = proxyFactory.createVersion(conTemplID, nextEntry.firstChild().getValue());
            ignores.add(ver);
        }
        this.updateIt = updates != null ? updates.iterator() : null;
        this.conflictIt = conflicts != null ? conflicts.iterator() : null;
        this.ignoreIt = ignores != null ? ignores.iterator() : null;
    }

    public boolean hasConflicts() {
        return this.conflictIt != null;
    }

    public boolean hasUpdates() {
        return this.updateIt != null;
    }

    public boolean isEmpty() {
        return this.updateIt == null && this.conflictIt == null && this.ignoreIt == null;
    }

    public boolean hasIgnores() {
        return this.ignoreIt != null;
    }

    public IMergeConflict nextConflict() {
        if (this.conflictIt != null && this.conflictIt.hasNext()) {
            return (Conflict)this.conflictIt.next();
        }
        return null;
    }

    public IVersion nextIgnore() {
        if (this.ignoreIt != null && this.ignoreIt.hasNext()) {
            return (IVersion)this.updateIt.next();
        }
        return null;
    }

    public IMergeUpdate nextUpdate() {
        if (this.updateIt != null && this.updateIt.hasNext()) {
            return (Update)this.updateIt.next();
        }
        return null;
    }

    private static class Conflict
    implements IMergeConflict {
        private IVersion commonAncestor;
        private IVersion source;
        private IVersionControlledResource target;
        private boolean automerge;

        Conflict(IVersion source, IVersion commonAncestor, IVersionControlledResource target) {
            this.source = source;
            this.commonAncestor = commonAncestor;
            this.target = target;
        }

        public IVersion getCommonAncestor() {
            return this.commonAncestor;
        }

        public IVersion getSource() {
            return this.source;
        }

        public IVersionControlledResource getTarget() {
            return this.target;
        }
    }

    private static class Update
    implements IMergeUpdate {
        private IVersion source;
        private IVersionControlledResource target;

        Update(IVersion source, IVersionControlledResource target) {
            this.source = source;
            this.target = target;
        }

        public IVersion getSource() {
            return this.source;
        }

        public IVersionControlledResource getTarget() {
            return this.target;
        }
    }
}

