/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.PathUtil;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.AbstractResourceLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.BaseResource;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.ResourceMetaClass;
import com.tssap.dtr.client.lib.deltavlib.impl.util.PropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.dav.PropfindRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.lang.reflect.Array;
import java.util.Iterator;

public class MemberLoader
extends AbstractResourceLoader {
    private BaseResource parent;
    private PropfindRequest pfind;
    private ResourceMetaClass metaclass;
    boolean loadParentCacheProps;

    public MemberLoader(BaseResource parent, ResourceMetaClass metaclass, boolean recursive) {
        if (parent == null || metaclass == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.metaclass = metaclass;
        this.pfind = new PropfindRequest(parent.getEncodedPath(), recursive ? Depth.DEPTH_INFINITY : Depth.DEPTH_1);
    }

    public void setLoadParentCachedProperties(boolean useParent) {
        this.loadParentCacheProps = useParent;
    }

    protected IPropertyNameIterator getPropertiesToLoad() {
        if (this.loadParentCacheProps) {
            String[] propertiesToLoad = this.parent.getPropertyCache().getCacheControl().getPropertiesToCache();
            return new PropertyNameIterator(propertiesToLoad);
        }
        return super.getPropertiesToLoad();
    }

    public IResource[] loadMembers(int conTemplID) throws VcmFailure {
        IResource[] resources;
        this.execute(conTemplID);
        int memberCount = this.size() - 1;
        if (memberCount < 0) {
            memberCount = 0;
        }
        if ((resources = (IResource[])Array.newInstance(this.getResourceMetaClass().resourceType(), memberCount)).length == 0) {
            return resources;
        }
        String parentPath = this.parent.getEncodedPath();
        MemberLoader provider = this;
        int i = 0;
        String decodedParentPath = Encoder.decodePath((String)parentPath);
        while (this.hasMoreResources()) {
            ResourceElement nextResource = this.getNextResource();
            String currentPath = nextResource.getPath();
            if (PathUtil.equalWebDAVpaths(decodedParentPath, Encoder.decodePath((String)currentPath))) {
                this.parent.initialize(provider);
                continue;
            }
            try {
                BaseResource resourceBase = this.getResourceMetaClass().newInstance(conTemplID, currentPath);
                Iterator propIt = this.getResourceProperties();
                resourceBase.initializePropertyCache(propIt);
                resources[i++] = resourceBase;
            }
            catch (InvalidPathException e) {
                throw new VcmFailure("Received invalid href from server");
            }
        }
        return resources;
    }

    protected void addPropertyNS(String nsPrefix, String nsUri) {
        this.pfind.addNamespace(nsPrefix, nsUri);
    }

    protected void addPropertyToLoad(String qualifiedName) {
        this.pfind.addPropertyGet(qualifiedName);
    }

    protected IRequest getRequest() {
        return this.pfind;
    }

    protected ResourceMetaClass getResourceMetaClass() {
        return this.metaclass;
    }
}

