/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.CommunicationException;
import com.tssap.dtr.client.lib.deltavlib.ConnectionPool;
import com.tssap.dtr.client.lib.deltavlib.DeltavException;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.ErrorEntity;
import com.tssap.dtr.client.lib.protocol.pool.IConnectionPool;
import com.tssap.dtr.client.lib.protocol.pool.OutOfConnectionsException;
import com.tssap.dtr.client.lib.protocol.templates.TemplateException;
import java.io.IOException;

public abstract class DeltavCommand {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$impl$DeltavCommand == null ? (class$com$tssap$dtr$client$lib$deltavlib$impl$DeltavCommand = DeltavCommand.class$("com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand")) : class$com$tssap$dtr$client$lib$deltavlib$impl$DeltavCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$impl$DeltavCommand;

    private DeltavCommand() {
    }

    public static IResponse execute(int connectionTemplID, IRequest request) throws VcmFailure {
        IResponse response = DeltavCommand.uncheckedExecute(connectionTemplID, request);
        if (response == null) {
            throw new CommunicationException("Invalid response from server");
        }
        return DeltavCommand.checkResponseStatus(request, response);
    }

    private static IResponse checkResponseStatus(IRequest request, IResponse response) throws DeltavException, CommunicationException {
        int status = response.getStatus();
        if (!DeltavCommand.isStatusSuccess(status)) {
            Object[] args;
            ErrorEntity error;
            String condition = null;
            if ((status == 403 || status == 409) && "ErrorEntity".equals(response.getEntityType()) && (condition = (error = (ErrorEntity)response.getEntity()).getErrorCondition()) == null) {
                condition = error.getExtendedCondition();
            }
            if (condition != null) {
                if (LOC.beInfo()) {
                    args = new String[]{request.getMethod(), request.getPath(), response.getStatusDescription(), Integer.toString(status), condition};
                    LOC.infoT("request {0} on {1} failed: {2} status: {3} condition: {4}", args);
                }
                throw new DeltavException(response.getStatusDescription(), status, condition);
            }
            if (LOC.beInfo()) {
                args = new String[]{request.getMethod(), request.getPath(), response.getStatusDescription(), Integer.toString(status)};
                LOC.infoT("request {0} on {1} failed: {2} status: {3}", args);
            }
            throw new DeltavException(response.getStatusDescription(), status);
        }
        if (status == 207 && response.getEntity() == null) {
            CommunicationException e = new CommunicationException("Invalid response received from server");
            LOC.errorT(e.getMessage());
            throw e;
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IResponse uncheckedExecute(int connectionTemplID, IRequest request) throws VcmFailure {
        Object[] args;
        IConnectionPool conPool = ConnectionPool.getInstance();
        IConnection con = null;
        try {
            try {
                con = conPool.acquireConnection(connectionTemplID);
                if (LOC.beDebug()) {
                    args = new String[]{request.getMethod(), request.getPath(), Integer.toString(connectionTemplID)};
                    LOC.infoT("send request {0} on {1} connetion ID:{2}", args);
                }
                args = request.perform(con);
                Object var9_6 = null;
                if (con == null) return args;
            }
            catch (OutOfConnectionsException e) {
                throw new CommunicationException("Failed to acquire connection", e);
            }
            catch (TemplateException e) {
                throw new CommunicationException("Failed to acquire connection", e);
            }
            catch (IOException e) {
                throw new CommunicationException("Communication error", e);
            }
            catch (HTTPException e) {
                throw new CommunicationException("HTTP protocol error", e);
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (con == null) throw throwable;
            conPool.releaseConnection(con, false);
            throw throwable;
        }
        conPool.releaseConnection(con, false);
        return args;
    }

    public static boolean isStatusSuccess(int statusCode) {
        return statusCode >= 200 && statusCode <= 299;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IResponse executeInterruptable(int connectionTemplID, IRequest request, InterruptCallbackHandler interruptCallbackHandler) throws VcmFailure {
        IResponse iResponse;
        IConnection con;
        IConnectionPool conPool;
        block13: {
            IResponse iResponse2;
            block12: {
                if (request == null) throw new NullPointerException();
                if (interruptCallbackHandler == null) {
                    throw new NullPointerException();
                }
                conPool = ConnectionPool.getInstance();
                con = null;
                try {
                    try {
                        block11: {
                            con = conPool.acquireConnection(connectionTemplID);
                            InterruptRequestCallback cb = new InterruptRequestCallback(){
                                private boolean isInterrupted = false;

                                public void interrupt() {
                                    this.isInterrupted = true;
                                }

                                public boolean isInterrupted() {
                                    return this.isInterrupted;
                                }
                            };
                            interruptCallbackHandler.addCallback(cb);
                            try {
                                request.perform(con);
                            }
                            catch (IOException e) {
                                if (!cb.isInterrupted()) {
                                    throw new CommunicationException("Communication error", e);
                                }
                                if (!LOC.beDebug()) break block11;
                                LOC.infoT("Client interrupted request execution");
                            }
                        }
                        IResponse response = request.getResponse();
                        if (response != null) {
                            iResponse2 = DeltavCommand.checkResponseStatus(request, request.getResponse());
                            Object var9_13 = null;
                            if (con == null) return iResponse2;
                            break block12;
                        }
                        iResponse = null;
                        break block13;
                    }
                    catch (OutOfConnectionsException e) {
                        throw new CommunicationException("Failed to acquire connection", e);
                    }
                    catch (TemplateException e) {
                        throw new CommunicationException("Failed to acquire connection", e);
                    }
                    catch (HTTPException e) {
                        throw new CommunicationException("HTTP protocol error", e);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_15 = null;
                    if (con == null) throw throwable;
                    conPool.releaseConnection(con, false);
                    throw throwable;
                }
            }
            conPool.releaseConnection(con, false);
            return iResponse2;
        }
        Object var9_14 = null;
        if (con == null) return iResponse;
        conPool.releaseConnection(con, false);
        return iResponse;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface InterruptRequestCallback {
        public void interrupt();

        public boolean isInterrupted();
    }

    public static interface InterruptCallbackHandler {
        public void addCallback(InterruptRequestCallback var1);
    }
}

