/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.CollisionFactory;
import com.tssap.dtr.client.lib.deltavlib.impl.CollisionImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.util.DataUtil;
import com.tssap.dtr.client.lib.deltavlib.impl.util.DateRange;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollisionState;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollisionType;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollisionQuery;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollisionReport;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollisionReportFactory;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollisionResource;
import com.tssap.dtr.client.lib.deltavlib.xcm.IDateRange;
import com.tssap.dtr.client.lib.deltavlib.xcm.IPersistentCollision;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.xcm.CollisionReport;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CollisionReportFactoryImpl
implements ICollisionReportFactory {
    public static final ICollisionReportFactory INSTANCE = new CollisionReportFactoryImpl();

    private CollisionReportFactoryImpl() {
    }

    public ICollisionQuery createQuery() {
        return new Query();
    }

    public ICollisionReport createReport(int conTemplID, String requestUri) {
        return new Report(conTemplID, requestUri);
    }

    public static class Query
    implements ICollisionQuery {
        private CollisionType type;
        private Collection workspaceSet;
        private CollisionState state;
        private String creator;
        private IDateRange creationDate;
        private String resolver;
        private IDateRange resolutionDate;
        private String resolvingSeq;
        private String resolvingActivity;
        private String owner;
        private String integratedActivity;
        private String integratedSeq;
        private String integrateVersionOwner;
        private String activeVersionOwner;

        public void addWorkspaceQuery(String workspacePath) {
            if (workspacePath == null) {
                throw new NullPointerException();
            }
            if (this.workspaceSet == null) {
                this.workspaceSet = new ArrayList();
            }
            this.workspaceSet.add(workspacePath);
        }

        public CollisionState getCollisionState() {
            return this.state;
        }

        public CollisionType getCollisionType() {
            return this.type;
        }

        public String getCreatedBy() {
            return this.creator;
        }

        public IDateRange getCreationDate() {
            return this.creationDate;
        }

        public String getIntegratedActivity() {
            return this.integratedActivity;
        }

        public String getIntegrateSequence() {
            return this.integratedSeq;
        }

        public String getIntegrateVersionOwner() {
            return this.integrateVersionOwner;
        }

        public String getOwner() {
            return this.owner;
        }

        public IDateRange getResolutionDate() {
            return this.resolutionDate;
        }

        public String getResolvedBy() {
            return this.resolver;
        }

        public String getResolvingActivity() {
            return this.resolvingActivity;
        }

        public void setResolvingActivity(String activityPath) {
            this.resolvingActivity = activityPath;
        }

        public String getResolvingSequence() {
            return this.resolvingSeq;
        }

        public String[] getWorkspaceSet() {
            if (this.workspaceSet != null) {
                return this.workspaceSet.toArray(new String[this.workspaceSet.size()]);
            }
            return null;
        }

        public String getActiveVersionOwner() {
            return this.activeVersionOwner;
        }

        public void setCollisionState(CollisionState state) {
            this.state = state;
        }

        public void setCollisionType(CollisionType type) {
            this.type = type;
        }

        public void setCreatedBy(String creator) {
            this.creator = creator;
        }

        public void setCreationDate(Date from, Date to) {
            this.creationDate = new DateRange(from, to);
        }

        public void setIntegratedActivity(String activityPath) {
            this.integratedActivity = activityPath;
        }

        public void setIntegrateSequence(String sequenceNumber) {
            this.integratedSeq = sequenceNumber;
        }

        public void setIntegrateVersionOwner(String owner) {
            this.integrateVersionOwner = owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public void setResolutionDate(Date from, Date to) {
            this.resolutionDate = new DateRange(from, to);
        }

        public void setResolvedBy(String resolver) {
            this.resolver = resolver;
        }

        public void setResolvingSequence(String sequence) {
            this.resolvingSeq = sequence;
        }

        public void setWorkspace(String workspacePath) {
            if (workspacePath == null) {
                this.workspaceSet = null;
                return;
            }
            if (this.workspaceSet == null) {
                this.workspaceSet = new ArrayList();
            } else {
                this.workspaceSet.clear();
            }
            this.workspaceSet.add(workspacePath);
        }

        public void setActiveVersionOwner(String owner) {
            this.activeVersionOwner = owner;
        }
    }

    private static class Report
    implements ICollisionReport {
        private int conTemplID;
        private String requestPath;

        private CollisionReport createInitiliazedReport(ICollisionQuery query) {
            String[] workspaces;
            IDateRange dateRange;
            CollisionState state;
            if (query == null) {
                throw new NullPointerException();
            }
            CollisionReport report = new CollisionReport(Encoder.encodePath((String)this.requestPath));
            CollisionType collisionType = query.getCollisionType();
            if (collisionType != null) {
                report.addCollisionTypeQuery(collisionType.toProtocolElement());
            }
            if ((state = query.getCollisionState()) != null) {
                report.addCollisionStateQuery(state.toProtocolElement());
            }
            if (query.getCreatedBy() != null) {
                report.addCreatedByQuery(query.getCreatedBy());
            }
            if ((dateRange = query.getCreationDate()) != null) {
                report.addCreationDateQuery(Converter.dateToHTTPDate(dateRange.getFrom()), Converter.dateToHTTPDate(dateRange.getTo()));
            }
            if (query.getIntegratedActivity() != null) {
                report.addIntegratedActivityQuery(Encoder.encodePath((String)query.getIntegratedActivity()));
            }
            if (query.getIntegrateSequence() != null) {
                report.addIntegrateSequenceQuery(query.getIntegrateSequence());
            }
            if (query.getIntegrateVersionOwner() != null) {
                report.addIntegrateVersionOwnerQuery(query.getIntegrateVersionOwner());
            }
            if (query.getOwner() != null) {
                report.addOwnerQuery(query.getOwner());
            }
            if ((workspaces = query.getWorkspaceSet()) != null) {
                int i = 0;
                while (i < workspaces.length) {
                    report.addWorkspaceQuery(Encoder.encodePath((String)workspaces[i]));
                    ++i;
                }
            }
            if ((dateRange = query.getResolutionDate()) != null) {
                report.addResolutionDateQuery(Converter.dateToHTTPDate(dateRange.getFrom()), Converter.dateToHTTPDate(dateRange.getTo()));
            }
            if (query.getResolvedBy() != null) {
                report.addResolvedByQuery(query.getResolvedBy());
            }
            if (query.getResolvingActivity() != null) {
                report.addResolvingActivityQuery(Encoder.encodePath((String)query.getResolvingActivity()));
            }
            if (query.getResolvingSequence() != null) {
                report.addResolvingSequenceQuery(query.getResolvingSequence());
            }
            if (query.getActiveVersionOwner() != null) {
                report.addActiveVersionOwnerQuery(query.getActiveVersionOwner());
            }
            return report;
        }

        private Report(int conTemplID, String requestPath) {
            if (requestPath == null) {
                throw new NullPointerException();
            }
            this.requestPath = requestPath;
            this.conTemplID = conTemplID;
        }

        private Set selectDefaultProperties(CollisionReport report) {
            HashSet selectedProperties = new HashSet();
            IPropertyNameIterator propIt = CollisionFactory.getPersistentCollisionDefaultProperties();
            while (propIt.hasNext()) {
                Report.addPropertyToSelect(propIt.next(), selectedProperties, report);
            }
            IPropertyNameIterator integBasePropertyIt = CollisionFactory.getIntegrateCollisionDefaultProperties();
            while (integBasePropertyIt.hasNext()) {
                Report.addPropertyToSelect(integBasePropertyIt.next(), selectedProperties, report);
            }
            return selectedProperties;
        }

        private static void addPropertyToSelect(String propQualifiedName, Set selectedProperties, CollisionReport report) {
            if (!selectedProperties.contains(propQualifiedName)) {
                report.addSelectProperty(propQualifiedName, PropertyUtil.getNamespaceURI(propQualifiedName));
                selectedProperties.add(propQualifiedName);
            }
        }

        public IPersistentCollision[] select(ICollisionQuery query) throws VcmFailure {
            CollisionReport report = this.createInitiliazedReport(query);
            Set selectedProperties = this.selectDefaultProperties(report);
            IResponse response = DeltavCommand.execute(this.conTemplID, (IRequest)report);
            if (response.isMultiStatus()) {
                return Report.parseCollisionResponse(this.conTemplID, (MultiStatusEntity)response.getEntity());
            }
            return new IPersistentCollision[0];
        }

        public ICollisionResource[] select(ICollisionQuery query, String[] propertyNames) throws VcmFailure {
            DataUtil.checkArrayForNull(propertyNames);
            CollisionReport report = this.createInitiliazedReport(query);
            Set selectedProperties = this.selectDefaultProperties(report);
            int i = 0;
            while (i < propertyNames.length) {
                Report.addPropertyToSelect(propertyNames[i], selectedProperties, report);
                ++i;
            }
            IResponse response = DeltavCommand.execute(this.conTemplID, (IRequest)report);
            if (response.isMultiStatus()) {
                ICollisionResource[] reportedCollisions = new ICollisionResource[report.countResources()];
                if (reportedCollisions.length == 0) {
                    return reportedCollisions;
                }
                Iterator resourceIt = report.getResources();
                try {
                    ResourceElement nextResource = null;
                    int i2 = 0;
                    while (resourceIt.hasNext() && i2 < reportedCollisions.length) {
                        nextResource = (ResourceElement)resourceIt.next();
                        CollisionImpl collision = new CollisionImpl(this.conTemplID, nextResource.getPath());
                        if (nextResource.countProperties() > 0) {
                            collision.initializePropertyCache(nextResource.getProperties());
                        }
                        reportedCollisions[i2] = collision;
                        ++i2;
                    }
                }
                catch (InvalidPathException e) {
                    throw new VcmFailure("client internal error", e);
                }
                return reportedCollisions;
            }
            return new ICollisionResource[0];
        }

        static IPersistentCollision[] parseCollisionResponse(int conTemplID, MultiStatusEntity collisionResponse) throws VcmFailure {
            Iterator resources = collisionResponse.getResources();
            IPersistentCollision[] reportedCollision = new IPersistentCollision[collisionResponse.countResources()];
            if (reportedCollision.length == 0) {
                return reportedCollision;
            }
            ResourceElement nextResource = null;
            try {
                int i = 0;
                while (resources.hasNext() && i < reportedCollision.length) {
                    nextResource = (ResourceElement)resources.next();
                    reportedCollision[i] = CollisionFactory.createPersistentCollisionFromResource(conTemplID, nextResource);
                    ++i;
                }
                return reportedCollision;
            }
            catch (IllegalArgumentException e) {
                throw new VcmFailure("internal error", e);
            }
        }
    }
}

