/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IFile;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.BaseResource;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.util.PropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollisionState;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollisionType;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollisionResource;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import java.util.Date;

class CollisionImpl
extends BaseResource
implements ICollisionResource {
    private static final String[] INTEG_COLLISION_DEF_PROPS = new String[]{XCM.WORKSPACE_VERSION.qualifiedName, XCM.COLLIDING_VERSION.qualifiedName, XCM.VCR.qualifiedName, XCM.INACTIVE_VCR.qualifiedName, XCM.COLLISION_TYPE.qualifiedName};

    CollisionImpl(int conTemplID, String encodedPath) throws InvalidPathException {
        super(conTemplID, encodedPath);
    }

    protected IPropertyNameIterator getInitialPropertyNames() {
        return new PropertyNameIterator(INTEG_COLLISION_DEF_PROPS);
    }

    public IVersion getWorkspaceVersion() throws VcmFailure {
        String encodedPath = this.getPropertyHrefValue(XCM.WORKSPACE_VERSION.qualifiedName);
        if (encodedPath != null) {
            return this.getResourceFactoryManager().getProxyFactory().createVersion(this.getConnectionTemplID(), encodedPath, PathEncodingFlag.ENCODED);
        }
        return null;
    }

    public IVersion getCollidingVersion() throws VcmFailure {
        String encodedPath = this.getPropertyHrefValue(XCM.COLLIDING_VERSION.qualifiedName);
        if (encodedPath != null) {
            return this.getResourceFactoryManager().getProxyFactory().createVersion(this.getConnectionTemplID(), encodedPath, PathEncodingFlag.ENCODED);
        }
        return null;
    }

    public IVersionControlledResource getVCR() throws VcmFailure {
        String encodedPath = this.getPropertyHrefValue(XCM.VCR.qualifiedName);
        if (encodedPath != null) {
            return this.getResourceFactoryManager().getProxyFactory().createVCR(this.getConnectionTemplID(), encodedPath, PathEncodingFlag.ENCODED);
        }
        return null;
    }

    public IVersionControlledResource getInactiveVCR() throws VcmFailure {
        String encodedPath = this.getPropertyHrefValue(XCM.INACTIVE_VCR.qualifiedName);
        if (encodedPath != null) {
            return this.getResourceFactoryManager().getProxyFactory().createVCR(this.getConnectionTemplID(), encodedPath, PathEncodingFlag.ENCODED);
        }
        return null;
    }

    public CollisionType getCollisionType() throws VcmFailure {
        String collisionTypeName = this.getPropertyStringValue(XCM.COLLISION_TYPE.qualifiedName);
        if (collisionTypeName != null) {
            return CollisionType.getEnumFromName(collisionTypeName);
        }
        return null;
    }

    public CollisionState getCollisionState() throws VcmFailure {
        String collisionStateName = this.getPropertyStringValue(XCM.COLLISION_STATE.qualifiedName);
        if (collisionStateName != null) {
            return CollisionState.getEnumFromName(collisionStateName);
        }
        return null;
    }

    public IVersion getActiveVersion() throws VcmFailure {
        String encodedPath = this.getPropertyHrefValue(XCM.ACTIVE_VERSION.qualifiedName);
        if (encodedPath != null) {
            return this.getResourceFactoryManager().getProxyFactory().createVersion(this.getConnectionTemplID(), encodedPath, PathEncodingFlag.ENCODED);
        }
        return null;
    }

    public IActivity getIntegratedActivity() throws VcmFailure {
        String encodedPath = this.getPropertyHrefValue(XCM.INTEGRATED_VSET.qualifiedName);
        if (encodedPath != null) {
            return this.getResourceFactoryManager().getProxyFactory().createActivity(this.getConnectionTemplID(), encodedPath, PathEncodingFlag.ENCODED);
        }
        return null;
    }

    public String getISN() throws VcmFailure {
        return this.getPropertyStringValue(XCM.ISN.qualifiedName);
    }

    public IActivity getLockingActivity() throws VcmFailure {
        String encodedPath = this.getPropertyHrefValue(XCM.LOCKING_ACTIVITY.qualifiedName);
        if (encodedPath != null) {
            return this.getResourceFactoryManager().getProxyFactory().createActivity(this.getConnectionTemplID(), encodedPath, PathEncodingFlag.ENCODED);
        }
        return null;
    }

    public IVersion getOriginalVersion() throws VcmFailure {
        String encodedPath = this.getPropertyHrefValue(XCM.ORIGINAL_VERSION.qualifiedName);
        if (encodedPath != null) {
            return this.getResourceFactoryManager().getProxyFactory().createVersion(this.getConnectionTemplID(), encodedPath, PathEncodingFlag.ENCODED);
        }
        return null;
    }

    public Date getResolutionDate() throws VcmFailure {
        String dateStr = this.getPropertyStringValue(XCM.RESOLUTION_DATE.qualifiedName);
        return dateStr != null ? Converter.parseHTTPDate(dateStr) : null;
    }

    public String getResolvedBy() throws VcmFailure {
        return this.getPropertyStringValue(XCM.RESOLVED_BY.qualifiedName);
    }

    public IActivity getResolvingActivity() throws VcmFailure {
        String encodedPath = this.getPropertyHrefValue(XCM.RESOLVING_ACTIVITY.qualifiedName);
        if (encodedPath != null) {
            return this.getResourceFactoryManager().getProxyFactory().createActivity(this.getConnectionTemplID(), encodedPath, PathEncodingFlag.ENCODED);
        }
        return null;
    }

    public String getResolvingISN() throws VcmFailure {
        return this.getPropertyStringValue(XCM.RESOLVING_ISN.qualifiedName);
    }

    public ICollection getAsCollection() throws VcmFailure {
        return null;
    }

    public IFile getAsFile() throws VcmFailure {
        return null;
    }

    public IVersionControlledResource getAsVersionControlled() throws VcmFailure {
        return null;
    }
}

