/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.ICheckedOutResource;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.impl.CollisionImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.ResFactoryMgrImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.util.PropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyCacheControl;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollisionState;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollisionType;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICheckinCollision;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollisionResource;
import com.tssap.dtr.client.lib.deltavlib.xcm.IIntegrateCollision;
import com.tssap.dtr.client.lib.deltavlib.xcm.IPersistentCollision;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.entities.Collision;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

abstract class CollisionFactory {
    private static final String[] INTEG_COLLISION_DEF_PROPS = new String[]{XCM.WORKSPACE_VERSION.qualifiedName, XCM.COLLIDING_VERSION.qualifiedName, XCM.VCR.qualifiedName, XCM.COLLISION_TYPE.qualifiedName, XCM.INACTIVE_VCR.qualifiedName};

    CollisionFactory() {
    }

    public static IPropertyNameIterator getIntegrateCollisionDefaultProperties() {
        return new PropertyNameIterator(INTEG_COLLISION_DEF_PROPS);
    }

    public static IPropertyNameIterator getPersistentCollisionDefaultProperties() {
        return PersistentCollision.getDefaultProperties();
    }

    public static IIntegrateCollision createIntegrateCollisionFromResource(int conTemplID, ResourceElement collisionResource) throws VcmFailure {
        Iterator propIt = collisionResource.getProperties();
        if (propIt == null) {
            throw new IllegalArgumentException();
        }
        try {
            CollisionImpl collision = new CollisionImpl(conTemplID, collisionResource.getPath());
            collision.initializePropertyCache(propIt);
            return new IntegrateCollisionAdapter(collision);
        }
        catch (InvalidPathException e) {
            throw new VcmFailure("client internal error", e);
        }
    }

    private static boolean checkPropertiesLoadedInCache(IPropertyNameIterator propNameIt, IResource checkedResource) {
        IPropertyCacheControl cacheControl = checkedResource.getPropertyCacheControl();
        while (propNameIt.hasNext()) {
            String propertyName = propNameIt.next();
            int state = cacheControl.getPropertyState(propertyName);
            if (state != 3 && state != 4) continue;
            return false;
        }
        return true;
    }

    public static IPersistentCollision createPersistentCollisionFromResource(int conTemplID, ResourceElement collisionResource) throws VcmFailure {
        Iterator propIt = collisionResource.getProperties();
        if (propIt == null) {
            throw new IllegalArgumentException("mandatory resource properties missing");
        }
        try {
            CollisionImpl collision = new CollisionImpl(conTemplID, collisionResource.getPath());
            if (collisionResource.countProperties() > 0) {
                collision.initializePropertyCache(collisionResource.getProperties());
            }
            if (!CollisionFactory.checkPropertiesLoadedInCache(PersistentCollision.getDefaultProperties(), collision)) {
                throw new IllegalArgumentException("mandatory resource properties missing");
            }
            IntegrateCollisionAdapter integrateCollision = new IntegrateCollisionAdapter(collision);
            PersistentCollision persistentCollision = new PersistentCollision(integrateCollision, collision.getWorkspace(), collision.getActiveVersion(), collision.getCollisionState());
            return persistentCollision;
        }
        catch (InvalidPathException e) {
            throw new VcmFailure("client internal error", e);
        }
    }

    public static IIntegrateCollision createIntegrateCollision(ICollisionResource resource) throws VcmFailure {
        return new IntegrateCollisionAdapter(resource);
    }

    public static IPersistentCollision createPersistentCollision(ICollisionResource resource) throws VcmFailure {
        return new PersistentCollision(CollisionFactory.createIntegrateCollision(resource), resource.getWorkspace(), resource.getActiveVersion(), resource.getCollisionState());
    }

    static IIntegrateCollision[] createIntegrateCollisions(int conTemplID, MultiStatusEntity integrateResponse) throws VcmFailure {
        ArrayList<IIntegrateCollision> collisions = new ArrayList<IIntegrateCollision>(integrateResponse.countResources());
        Iterator resources = integrateResponse.getResources();
        if (resources == null) {
            return null;
        }
        ResourceElement nextResource = null;
        while (resources.hasNext()) {
            nextResource = (ResourceElement)resources.next();
            Iterator resCollisions = nextResource.getCollisions();
            if (resCollisions != null) {
                Collision nextCollision = null;
                IntegrateCollision integCollision = null;
                while (resCollisions.hasNext()) {
                    nextCollision = (Collision)resCollisions.next();
                    integCollision = new IntegrateCollision(conTemplID, nextCollision, nextResource.getPath());
                    integCollision.inactiveVCR = null;
                    collisions.add(integCollision);
                }
                continue;
            }
            collisions.add(CollisionFactory.createIntegrateCollisionFromResource(conTemplID, nextResource));
        }
        if (collisions.size() == 0) {
            return null;
        }
        IIntegrateCollision[] result = new IIntegrateCollision[collisions.size()];
        collisions.toArray(result);
        return result;
    }

    public static ICheckinCollision[] createCheckinCollisions(int conTemplID, MultiStatusEntity checkinResponse) throws VcmFailure {
        ArrayList<CheckinCollision> collisions = new ArrayList<CheckinCollision>(checkinResponse.countResources());
        Iterator resources = checkinResponse.getResources();
        if (resources == null) {
            return null;
        }
        ResourceElement nextResource = null;
        while (resources.hasNext()) {
            nextResource = (ResourceElement)resources.next();
            Iterator resCollisisions = nextResource.getCollisions();
            if (resCollisisions == null) {
                return null;
            }
            Collision nextCollision = null;
            while (resCollisisions.hasNext()) {
                nextCollision = (Collision)resCollisisions.next();
                collisions.add(CollisionFactory.createCheckinCollision(conTemplID, nextCollision, nextResource.getPath()));
            }
        }
        if (collisions.size() == 0) {
            return null;
        }
        ICheckinCollision[] result = new ICheckinCollision[collisions.size()];
        collisions.toArray(result);
        return result;
    }

    private static CheckinCollision createCheckinCollision(int conTemplID, Collision collision, String encCollidingVerPath) throws VcmFailure {
        String type;
        if (collision == null) {
            throw new NullPointerException();
        }
        if (collision.getVCR() == null || collision.getCollisionType() == null || collision.getWorkspaceVersion() == null) {
            throw new VcmFailure("Invalid collision element received from server");
        }
        IResourceFactory proxyFactory = ResFactoryMgrImpl.getInstance().getProxyFactory();
        ICheckedOutResource collidingVersion = proxyFactory.createCheckedOutResource(conTemplID, encCollidingVerPath, PathEncodingFlag.ENCODED);
        IVersionControlledResource vcr = proxyFactory.createVCR(conTemplID, collision.getVCR(), PathEncodingFlag.ENCODED);
        IVersion activeVersion = proxyFactory.createVersion(conTemplID, collision.getWorkspaceVersion(), PathEncodingFlag.ENCODED);
        CheckinCollision ciCollision = new CheckinCollision(vcr, activeVersion, collidingVersion);
        String origVerPath = collision.getOriginalVersion();
        if (origVerPath != null) {
            IVersion originalVersion = proxyFactory.createVersion(conTemplID, collision.getOriginalVersion(), PathEncodingFlag.ENCODED);
            ciCollision.setOriginalVersion(originalVersion);
        }
        if ((type = collision.getCollisionType()) != null) {
            ciCollision.setCollisionType(CollisionType.getEnumFromName(type));
        }
        return ciCollision;
    }

    private static class PersistentCollision
    implements IPersistentCollision {
        private static final String[] PERSISTENT_EXT_PROP_SET = new String[]{XCM.ACTIVE_VERSION.qualifiedName, XCM.COLLISION_STATE.qualifiedName, DAV.WORKSPACE.qualifiedName};
        private static String[] PERSISTENT_COLLISION_PROP_SET;
        private IIntegrateCollision iCollision;
        private CollisionState state;
        private IWorkspace workspace;
        private IVersion activeVersion;

        static IPropertyNameIterator getDefaultProperties() {
            return new PropertyNameIterator(PERSISTENT_COLLISION_PROP_SET);
        }

        PersistentCollision(IIntegrateCollision collision, IWorkspace workspace, IVersion activeVersion, CollisionState state) {
            this.iCollision = collision;
            this.state = state;
            this.workspace = workspace;
            this.activeVersion = activeVersion;
        }

        public IVersion getActiveVersion() {
            return this.activeVersion;
        }

        public IVersion getCollidingVersion() {
            return this.iCollision.getCollidingVersion();
        }

        public IVersionControlledResource getVCR() {
            return this.iCollision.getVCR();
        }

        public CollisionType getCollisionType() {
            return this.iCollision.getCollisionType();
        }

        public IVersion getOriginalVersion() {
            return this.iCollision.getOriginalVersion();
        }

        public String getCollisionResourcePath() {
            return this.iCollision.getCollisionResource().getDecodedPath();
        }

        public CollisionState getCollisionState() {
            return this.state;
        }

        public IWorkspace getWorkspace() {
            return this.workspace;
        }

        public ICollisionResource getCollisionResource() {
            return this.iCollision.getCollisionResource();
        }

        public IVersionControlledResource getInactiveVCR() {
            return this.iCollision.getInactiveVCR();
        }

        public IVersion getWorkspaceVersion() {
            return this.iCollision.getWorkspaceVersion();
        }

        static {
            ArrayList<String> propList = new ArrayList<String>(Arrays.asList(PERSISTENT_EXT_PROP_SET));
            propList.addAll(Arrays.asList(INTEG_COLLISION_DEF_PROPS));
            PERSISTENT_COLLISION_PROP_SET = propList.toArray(new String[propList.size()]);
        }
    }

    private static class IntegrateCollision
    implements IIntegrateCollision {
        private Collision collision;
        private IVersion workspaceVer;
        private IVersion originalVer;
        private IVersionControlledResource activeVCR;
        private IVersion collidingVer;
        private IVersionControlledResource inactiveVCR;
        private int conTemplID = -1;

        IntegrateCollision(int conTemplID, Collision collision, String collidingVerEncPath) throws VcmFailure {
            if (collision == null || collision.getVCR() == null || collision.getWorkspaceVersion() == null || collidingVerEncPath == null) {
                throw new NullPointerException();
            }
            this.collision = collision;
            this.conTemplID = conTemplID;
            this.collidingVer = this.getPxyFactory().createVersion(conTemplID, collidingVerEncPath, PathEncodingFlag.ENCODED);
        }

        private IResourceFactory getPxyFactory() {
            return ResourceFactoryManager.getInstance().getProxyFactory();
        }

        public IVersion getCollidingVersion() {
            return this.collidingVer;
        }

        public ICollisionResource getCollisionResource() {
            return null;
        }

        public IVersionControlledResource getInactiveVCR() {
            return this.inactiveVCR;
        }

        public IVersionControlledResource getVCR() {
            if (this.activeVCR == null) {
                try {
                    this.activeVCR = this.getPxyFactory().createVCR(this.conTemplID, this.collision.getVCR(), PathEncodingFlag.ENCODED);
                }
                catch (VcmFailure e) {
                    throw new IllegalStateException("invalid active-vcr");
                }
            }
            return this.activeVCR;
        }

        public IVersion getWorkspaceVersion() {
            if (this.workspaceVer == null) {
                try {
                    this.workspaceVer = this.getPxyFactory().createVersion(this.conTemplID, this.collision.getWorkspaceVersion());
                }
                catch (VcmFailure e) {
                    throw new IllegalStateException("invalid active-version");
                }
            }
            return this.workspaceVer;
        }

        public IVersion getOriginalVersion() {
            if (this.collision.getOriginalVersion() != null && this.originalVer == null) {
                try {
                    this.originalVer = this.getPxyFactory().createVersion(this.conTemplID, this.collision.getOriginalVersion(), PathEncodingFlag.ENCODED);
                }
                catch (VcmFailure e) {
                    throw new IllegalStateException("invalid original-version");
                }
            }
            return this.originalVer;
        }

        public CollisionType getCollisionType() {
            String type = this.collision.getCollisionType();
            return type != null ? CollisionType.getEnumFromName(type) : null;
        }
    }

    private static class CheckinCollision
    implements ICheckinCollision {
        private IVersionControlledResource activeVCR;
        private IVersion workspaceVer;
        private ICheckedOutResource collidingVersion;
        private IVersion originalVersion;
        private CollisionType type;

        CheckinCollision(IVersionControlledResource vcr, IVersion workspaceVer, ICheckedOutResource collidingVersion) {
            if (vcr == null || workspaceVer == null || collidingVersion == null) {
                throw new NullPointerException();
            }
            this.workspaceVer = workspaceVer;
            this.activeVCR = vcr;
            this.collidingVersion = collidingVersion;
        }

        void setOriginalVersion(IVersion version) {
            this.originalVersion = version;
        }

        void setCollisionType(CollisionType type) {
            this.type = type;
        }

        public ICheckedOutResource getCollidingVersion() {
            return this.collidingVersion;
        }

        public IVersionControlledResource getVCR() {
            return this.activeVCR;
        }

        public IVersion getWorkspaceVersion() {
            return this.workspaceVer;
        }

        public CollisionType getCollisionType() {
            return this.type;
        }

        public IVersion getOriginalVersion() {
            return this.originalVersion;
        }
    }

    static class IntegrateCollisionAdapter
    implements IIntegrateCollision {
        private ICollisionResource collisionResource;
        private IVersion collidingVer;
        private IVersion workspaceVer;
        private IVersion originalVer;
        private IVersionControlledResource inactiveVCR;
        private IVersionControlledResource activeVCR;
        private CollisionType collisionType;

        IntegrateCollisionAdapter(ICollisionResource collisionResource) throws VcmFailure {
            this.collisionResource = collisionResource;
            IPropertyCacheControl propCacheControl = collisionResource.getPropertyCacheControl();
            int i = 0;
            while (i < INTEG_COLLISION_DEF_PROPS.length) {
                int state = propCacheControl.getPropertyState(INTEG_COLLISION_DEF_PROPS[i]);
                if (state == 3 || state == 4) {
                    propCacheControl.addPropertyToCache(INTEG_COLLISION_DEF_PROPS[i]);
                }
                ++i;
            }
            this.collidingVer = collisionResource.getCollidingVersion();
            this.workspaceVer = collisionResource.getWorkspaceVersion();
            this.activeVCR = collisionResource.getVCR();
            this.collisionType = collisionResource.getCollisionType();
            if (this.collisionType == CollisionType.NAME_CLASH) {
                this.inactiveVCR = collisionResource.getInactiveVCR();
            }
        }

        void setInactiveVCR(IVersionControlledResource inactiveVCR) {
            this.inactiveVCR = inactiveVCR;
        }

        void setOriginalVersion(IVersion version) {
            this.originalVer = version;
        }

        public IVersion getCollidingVersion() {
            return this.collidingVer;
        }

        public IVersionControlledResource getVCR() {
            return this.activeVCR;
        }

        public IVersion getWorkspaceVersion() {
            return this.workspaceVer;
        }

        public CollisionType getCollisionType() {
            return this.collisionType;
        }

        public IVersion getOriginalVersion() {
            return null;
        }

        public ICollisionResource getCollisionResource() {
            return this.collisionResource;
        }

        public IVersionControlledResource getInactiveVCR() {
            return this.inactiveVCR;
        }
    }
}

