/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.ConnectionPool;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.PathUtil;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.DefaultCachedPropertyManager;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.RawPropertyParser;
import com.tssap.dtr.client.lib.deltavlib.impl.VersionControlledImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.util.DataUtil;
import com.tssap.dtr.client.lib.deltavlib.impl.util.PropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.deltavlib.xcm.CollectionSynchronizerOptions;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICollectionSynchronizer;
import com.tssap.dtr.client.lib.deltavlib.xcm.IResourceResultSet;
import com.tssap.dtr.client.lib.deltavlib.xcm.ISynchronizeResourceCallback;
import com.tssap.dtr.client.lib.deltavlib.xcm.ResourceCollector;
import com.tssap.dtr.client.lib.deltavlib.xcm.SelectResourcesOption;
import com.tssap.dtr.client.lib.deltavlib.xcm.SyncableResource;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.IResourceListener;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.xcm.ListCollectionReport;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Date;
import java.util.Iterator;

public class CollectionSynchronizer
implements ICollectionSynchronizer {
    private CollectionSynchronizerOptions m_synchronizerOptions;
    private static final PropertyElement FILE_RESOURCETYPE = new PropertyElement(DAV.RESOURCETYPE.localName, "DAV:");
    private static final PropertyElement COLLECTION_RESOURCETYPE = new PropertyElement(DAV.RESOURCETYPE.localName, "DAV:");
    public static final int NOT_APPLICABLE = 444;
    public static final int FINISHED = 246;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$IVersionControlledResource;

    private static Date readServerTimeStamp(IResponse response) throws VcmFailure {
        String dateHeaderValue = response.getHeaderValue("Expires");
        if (dateHeaderValue == null && (dateHeaderValue = response.getHeaderValue("Date")) == null) {
            throw new VcmFailure("internal error: missing Date header in server response");
        }
        Date serverTimeStamp = Converter.parseHTTPDate(dateHeaderValue);
        if (serverTimeStamp == null) {
            throw new VcmFailure("internal error: invalid Date header format in server response");
        }
        return serverTimeStamp;
    }

    private static IPropertyNameIterator vcrDefaultProperties() {
        return DefaultCachedPropertyManager.getInstance().getResourceCachedProperties(class$com$tssap$dtr$client$lib$deltavlib$IVersionControlledResource == null ? (class$com$tssap$dtr$client$lib$deltavlib$IVersionControlledResource = CollectionSynchronizer.class$("com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource")) : class$com$tssap$dtr$client$lib$deltavlib$IVersionControlledResource);
    }

    private static Date executeReport(int conTemplID, ListCollectionReport report, MemberListener listener) throws VcmFailure {
        DeltavCommand.executeInterruptable(conTemplID, (IRequest)report, listener);
        if (listener.getCaughtException() != null) {
            throw listener.getCaughtException();
        }
        return listener.getServerTimeStamp();
    }

    static IVersionControlledResource createVcr(int connectionId, ResourceElement resource, RawPropertyParser parser) throws InvalidResourceException {
        VersionControlledImpl vcr = null;
        try {
            vcr = new VersionControlledImpl(connectionId, resource.getPath());
        }
        catch (InvalidPathException e) {
            throw new InvalidResourceException(e.getMessage());
        }
        int statusCode = resource.getStatusCode();
        if (statusCode == 404 && resource.countProperties() == 0 || statusCode == 444) {
            return vcr;
        }
        Iterator propIt = resource.getProperties();
        int i = 0;
        while (i < resource.countProperties()) {
            PropertyElement nextProperty = (PropertyElement)propIt.next();
            PropertyElement normalizedProperty = parser.parseValue(nextProperty);
            vcr.localSetProperty(normalizedProperty);
            ++i;
        }
        PropertyElement resourceType = CollectionSynchronizer.getDavResourceProperty(vcr);
        vcr.localSetProperty(resourceType);
        if (resource.countProperties() > 0) {
            vcr.setInitialized(true);
        }
        return vcr;
    }

    private static PropertyElement getDavResourceProperty(IResource resource) throws InvalidResourceException {
        boolean isFile;
        int stateInCache = resource.getPropertyCacheControl().getPropertyState(DAV.GETCONTENTLENGTH.qualifiedName);
        boolean bl = isFile = 1 == stateInCache;
        if (!isFile) {
            if (2 == stateInCache) {
                isFile = false;
            } else {
                throw new InvalidResourceException("DAV:getcontentlength property required");
            }
        }
        return isFile ? FILE_RESOURCETYPE : COLLECTION_RESOURCETYPE;
    }

    private static void setupReportOptions(ListCollectionReport report, SelectResourcesOption options) {
        int depth = options.getDepth();
        Depth protocolDepth = null;
        switch (depth) {
            case 0: {
                protocolDepth = Depth.DEPTH_0;
                break;
            }
            case 1: {
                protocolDepth = Depth.DEPTH_1;
                break;
            }
            case 2: {
                protocolDepth = Depth.DEPTH_INFINITY;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        report.setDepth(protocolDepth);
        if (options.getProperties() != null) {
            CollectionSynchronizer.selectProperties(new PropertyNameIterator(options.getProperties()), report);
        } else {
            CollectionSynchronizer.selectProperties(PropertyNameIterator.EMPTY_ITERATOR, report);
        }
        if (options.isShowDeleted()) {
            report.showDeletedResources();
        }
        if (options.isPropertiesOnly()) {
            report.showPropertiesOnly();
        }
    }

    private static String getContextRootPath(int connectionTemplID) throws VcmFailure {
        try {
            IConnectionTemplate template = ConnectionPool.getTemplateProvider().getConnectionTemplate(connectionTemplID);
            String basePath = template.getBasePath();
            if (basePath != null && !"/".equals(basePath)) {
                return basePath;
            }
            return null;
        }
        catch (InvalidTemplateIDException e) {
            throw new VcmFailure("Invalid connection ID", e);
        }
    }

    public static String findCommonParentPath(int connectionTemplID, String[] paths) throws VcmFailure {
        String contextRoot = CollectionSynchronizer.getContextRootPath(connectionTemplID);
        if (contextRoot != null) {
            return contextRoot;
        }
        return new CommonParentPathFinder(paths).getCommonParentPath();
    }

    public static String findCommonParentHref(SyncableResource[] resources) throws VcmFailure {
        String contextRoot = CollectionSynchronizer.getContextRootPath(resources[0].getResource().getConnectionTemplID());
        if (contextRoot != null) {
            return contextRoot;
        }
        return new CommonParentPathFinder(resources).getCommonParentPath();
    }

    public Date syncSelected(SyncableResource[] resources, SelectResourcesOption options, ISynchronizeResourceCallback callback) throws VcmFailure {
        if (callback == null) {
            throw new NullPointerException("null sync callback");
        }
        DataUtil.checkArrayForNull(resources);
        if (resources.length == 0) {
            throw new IllegalArgumentException("empty resource array to sync");
        }
        String collectionHref = CollectionSynchronizer.findCommonParentHref(resources);
        int connectionID = resources[0].getResource().getConnectionTemplID();
        MemberListener listener = new MemberListener(connectionID, callback);
        ListCollectionReport report = new ListCollectionReport(collectionHref, (IResourceListener)listener);
        if (this.m_synchronizerOptions != null && this.m_synchronizerOptions.getEnsureFinished()) {
            report.ensureFinished();
        }
        int i = 0;
        while (i < resources.length) {
            long tstmp = resources[i].getTimestamp().getTime();
            String resourceHref = resources[i].getResource().getEncodedPath();
            report.addResource(resourceHref, tstmp);
            ++i;
        }
        CollectionSynchronizer.setupReportOptions(report, options);
        return CollectionSynchronizer.executeReport(connectionID, report, listener);
    }

    public IResourceResultSet findSelectedResources(int connectionId, String[] selectedPaths, SelectResourcesOption options) throws VcmFailure {
        DataUtil.checkArrayForNull(selectedPaths);
        String commonParentHref = Encoder.encodePath((String)CollectionSynchronizer.findCommonParentPath(connectionId, selectedPaths));
        ResourceCollector collector = new ResourceCollector();
        ListCollectionReport report = new ListCollectionReport(commonParentHref, (IResourceListener)new MemberListener(connectionId, collector));
        if (this.m_synchronizerOptions != null && this.m_synchronizerOptions.getEnsureFinished()) {
            report.ensureFinished();
        }
        boolean isPropertyOnlyValue = options.isPropertiesOnly();
        if (options.getProperties() == null || options.getProperties().length == 0) {
            IPropertyNameIterator propIt = CollectionSynchronizer.vcrDefaultProperties();
            String[] propNames = new String[propIt.size()];
            int i = 0;
            while (i < propNames.length) {
                propNames[i] = propIt.next();
                ++i;
            }
            options.setProperties(propNames);
        }
        CollectionSynchronizer.setupReportOptions(report, options);
        options.setPropertiesOnly(false);
        int i = 0;
        while (i < selectedPaths.length) {
            report.addResource(Encoder.encodePath((String)selectedPaths[i]));
            ++i;
        }
        try {
            IResponse resp = DeltavCommand.execute(connectionId, (IRequest)report);
            ResourceCollector resourceCollector = collector;
            Object var12_13 = null;
            options.setPropertiesOnly(isPropertyOnlyValue);
            return resourceCollector;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            options.setPropertiesOnly(isPropertyOnlyValue);
            throw throwable;
        }
    }

    public CollectionSynchronizer(CollectionSynchronizerOptions synchronizerOptions) {
        this.m_synchronizerOptions = synchronizerOptions;
    }

    public CollectionSynchronizer() {
        this.m_synchronizerOptions = null;
    }

    public IResource findResourceByPath(final int connectionTemplateId, String resourcePath, boolean showDeleted) throws VcmFailure {
        if (resourcePath == null) {
            throw new NullPointerException("null resource path");
        }
        String parentPath = PathUtil.getParentPath(resourcePath);
        final String href = Encoder.encodePath((String)resourcePath);
        final IResource[] result = new IResource[1];
        IResourceListener listener = new IResourceListener(){

            public void notifyResponse(IResponse response) {
            }

            public boolean notifyResource(ResourceElement resource, IResponseStream content) throws IOException {
                int status;
                if (PathUtil.equalWebDAVpaths(href, resource.getPath()) && ((status = resource.getStatusCode()) == 200 || status == 301 || status == 404 && resource.countProperties() > 0)) {
                    result[0] = CollectionSynchronizer.createVcr(connectionTemplateId, resource, RawPropertyParser.createParser());
                }
                return false;
            }
        };
        ListCollectionReport report = new ListCollectionReport(Encoder.encodePath((String)parentPath), listener);
        if (this.m_synchronizerOptions != null && this.m_synchronizerOptions.getEnsureFinished()) {
            report.ensureFinished();
        }
        report.showPropertiesOnly();
        if (showDeleted) {
            report.showDeletedResources();
        }
        report.addResource(resourcePath);
        report.setDepth(Depth.DEPTH_1);
        CollectionSynchronizer.selectProperties(CollectionSynchronizer.vcrDefaultProperties(), report);
        DeltavCommand.execute(connectionTemplateId, (IRequest)report);
        return result[0];
    }

    public Date syncSelected(SyncableResource[] resources, ISynchronizeResourceCallback callback) throws VcmFailure {
        SelectResourcesOption options = new SelectResourcesOption();
        options.setPropertiesOnly(false);
        options.setDepth(2);
        options.setShowDeleted(true);
        IPropertyNameIterator propIt = CollectionSynchronizer.vcrDefaultProperties();
        String[] propNames = new String[propIt.size()];
        int i = 0;
        while (i < propNames.length) {
            propNames[i] = propIt.next();
            ++i;
        }
        options.setProperties(propNames);
        return this.syncSelected(resources, options, callback);
    }

    public Date syncSinceTimestamp(ICollection parent, Date timeStamp, ISynchronizeResourceCallback callback) throws VcmFailure {
        if (callback == null || callback == null) {
            throw new NullPointerException();
        }
        MemberListener listener = new MemberListener(parent.getConnectionTemplID(), callback);
        ListCollectionReport report = new ListCollectionReport(PathUtil.getParentPath(parent.getEncodedPath()), (IResourceListener)listener);
        if (this.m_synchronizerOptions != null && this.m_synchronizerOptions.getEnsureFinished()) {
            report.ensureFinished();
        }
        CollectionSynchronizer.selectProperties(CollectionSynchronizer.vcrDefaultProperties(), report);
        report.setDepth(Depth.DEPTH_INFINITY);
        report.showDeletedResources();
        if (timeStamp != null) {
            report.addResource(parent.getEncodedPath(), timeStamp.getTime());
        } else {
            report.addResource(parent.getEncodedPath());
        }
        return CollectionSynchronizer.executeReport(parent.getConnectionTemplID(), report, listener);
    }

    public Date syncAll(ICollection sourceCollection, ISynchronizeResourceCallback callback) throws VcmFailure {
        return this.syncSinceTimestamp(sourceCollection, null, callback);
    }

    private static void selectProperties(IPropertyNameIterator propIt, ListCollectionReport report) {
        boolean isGetContentLengthSelected = false;
        int i = 0;
        while (i < propIt.size()) {
            String qname = propIt.next();
            if (!DAV.RESOURCETYPE.qualifiedName.equals(qname)) {
                String nsUri = PropertyUtil.getNamespaceURI(qname);
                report.addProperty(qname, nsUri);
                if (DAV.GETCONTENTLENGTH.qualifiedName.equals(qname)) {
                    isGetContentLengthSelected = true;
                }
            }
            ++i;
        }
        if (!isGetContentLengthSelected) {
            report.addProperty(DAV.GETCONTENTLENGTH.qualifiedName, "DAV:");
        }
    }

    public Date syncSinceISN(ICollection parent, int lastISN, ISynchronizeResourceCallback callback) throws VcmFailure {
        if (callback == null || callback == null) {
            throw new NullPointerException();
        }
        MemberListener listener = new MemberListener(parent.getConnectionTemplID(), callback);
        ListCollectionReport report = new ListCollectionReport(PathUtil.getParentPath(parent.getEncodedPath()), (IResourceListener)listener);
        if (this.m_synchronizerOptions != null && this.m_synchronizerOptions.getEnsureFinished()) {
            report.ensureFinished();
        }
        CollectionSynchronizer.selectProperties(CollectionSynchronizer.vcrDefaultProperties(), report);
        report.setDepth(Depth.DEPTH_INFINITY);
        report.showDeletedResources();
        if (lastISN > 0) {
            report.addResource(parent.getEncodedPath(), lastISN);
        } else {
            report.addResource(parent.getEncodedPath());
        }
        return CollectionSynchronizer.executeReport(parent.getConnectionTemplID(), report, listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FILE_RESOURCETYPE.setStatusCode(200);
        COLLECTION_RESOURCETYPE.setStatusCode(200);
        COLLECTION_RESOURCETYPE.addChild(new Element("collection", "DAV:"));
    }

    static class CommonParentPathFinder {
        private String firstParent;
        private String currentParent;
        private int count;

        private void nextPath(String path) {
            ++this.count;
            if (this.firstParent == null) {
                this.currentParent = this.firstParent = PathUtil.getParentPath(path);
                return;
            }
            String nextParent = PathUtil.getParentPath(path);
            if (this.currentParent.startsWith(nextParent)) {
                this.currentParent = nextParent;
            }
        }

        String getCommonParentPath() {
            return this.firstParent == this.currentParent && this.count > 1 ? "/" : this.currentParent;
        }

        CommonParentPathFinder(SyncableResource[] resources) {
            int i = 0;
            while (i < resources.length) {
                this.nextPath(resources[i].getResource().getEncodedPath());
                ++i;
            }
        }

        CommonParentPathFinder(String[] paths) {
            int i = 0;
            while (i < paths.length) {
                this.nextPath(paths[i]);
                ++i;
            }
        }
    }

    private static class MemberListener
    implements IResourceListener,
    DeltavCommand.InterruptCallbackHandler {
        private RawPropertyParser parser;
        private ISynchronizeResourceCallback delegate;
        private int connectionId;
        private Date serverTimeStamp;
        private VcmFailure caughtExc;
        private DeltavCommand.InterruptRequestCallback cb;

        MemberListener(int connectionId, ISynchronizeResourceCallback callback) {
            this.delegate = callback;
            this.parser = RawPropertyParser.createParser();
            this.connectionId = connectionId;
        }

        public void addCallback(DeltavCommand.InterruptRequestCallback cb) {
            this.cb = cb;
        }

        public void notifyResponse(IResponse response) {
            try {
                this.serverTimeStamp = CollectionSynchronizer.readServerTimeStamp(response);
                this.delegate.currentServerTime(this.serverTimeStamp);
            }
            catch (VcmFailure e) {
                this.caughtExc = e;
            }
        }

        public boolean notifyResource(ResourceElement resource, IResponseStream content) throws IOException {
            if (resource.getStatusCode() == 403) {
                return this.delegate.forbidden(Encoder.decodePath((String)resource.getPath()));
            }
            if (resource.getStatusCode() == 246) {
                this.delegate.requestCompleted();
                return false;
            }
            boolean isInterrupted = false;
            IVersionControlledResource vcr = null;
            try {
                vcr = CollectionSynchronizer.createVcr(this.connectionId, resource, this.parser);
                isInterrupted = resource.getStatusCode() == 404 ? (resource.countProperties() > 0 ? this.delegate.deleted(vcr) : this.delegate.notFound(vcr)) : (resource.getStatusCode() == 301 ? this.delegate.moved(vcr) : (resource.getStatusCode() == 444 ? this.delegate.notApplicable(vcr) : (resource.getStatusCode() == 200 ? (FILE_RESOURCETYPE == CollectionSynchronizer.getDavResourceProperty(vcr) ? this.delegate.receivedFile(vcr, content) : this.delegate.receivedCollection(vcr)) : false)));
            }
            catch (InvalidResourceException e) {
                isInterrupted = this.delegate.invalid(resource.getPath());
            }
            if (isInterrupted) {
                if (this.cb != null) {
                    this.cb.interrupt();
                } else {
                    content.release();
                }
                throw new InterruptedIOException("Sync Interrupted");
            }
            return false;
        }

        VcmFailure getCaughtException() {
            return this.caughtExc;
        }

        Date getServerTimeStamp() {
            return this.serverTimeStamp;
        }
    }

    private static class InvalidResourceException
    extends IOException {
        public InvalidResourceException() {
        }

        public InvalidResourceException(String s) {
            super(s);
        }
    }
}

