/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.ConnectionPool;
import com.tssap.dtr.client.lib.deltavlib.IBaseline;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IFile;
import com.tssap.dtr.client.lib.deltavlib.IMemberIterator;
import com.tssap.dtr.client.lib.deltavlib.IPersistentResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.PathUtil;
import com.tssap.dtr.client.lib.deltavlib.PropertyBehavior;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.PropertyFactoryAccess;
import com.tssap.dtr.client.lib.deltavlib.impl.AbstractResource;
import com.tssap.dtr.client.lib.deltavlib.impl.AbstractResourceLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.BaseResource;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.impl.FileImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.MemberLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.NameServerConfigImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.ResourceMetaClass;
import com.tssap.dtr.client.lib.deltavlib.impl.VersionControlledImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.WorkspaceImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.util.MemberTree;
import com.tssap.dtr.client.lib.deltavlib.impl.util.PropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.search.Constraint;
import com.tssap.dtr.client.lib.deltavlib.search.SearchContext;
import com.tssap.dtr.client.lib.deltavlib.xcm.INameServerConfig;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dasl.SearchRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.BaselineControlRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.CopyRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.dav.MkColRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.MoveRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.PropfindRequest;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.io.InputStream;
import java.util.Iterator;

class CollectionImpl
extends FileImpl
implements ICollection {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$impl$CollectionImpl == null ? (class$com$tssap$dtr$client$lib$deltavlib$impl$CollectionImpl = CollectionImpl.class$("com.tssap.dtr.client.lib.deltavlib.impl.CollectionImpl")) : class$com$tssap$dtr$client$lib$deltavlib$impl$CollectionImpl));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$impl$CollectionImpl;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$ICollection;

    protected IPropertyNameIterator getInitialPropertyNames() {
        IPropertyNameIterator propNameIt = AbstractResource.PROPERTY_MANAGER.getResourceCachedProperties(class$com$tssap$dtr$client$lib$deltavlib$ICollection == null ? (class$com$tssap$dtr$client$lib$deltavlib$ICollection = CollectionImpl.class$("com.tssap.dtr.client.lib.deltavlib.ICollection")) : class$com$tssap$dtr$client$lib$deltavlib$ICollection);
        if (propNameIt == null) {
            return new PropertyNameIterator(new String[0]);
        }
        return propNameIt;
    }

    public CollectionImpl(int conTemplID, String path) throws InvalidPathException {
        super(conTemplID, path);
    }

    public CollectionImpl(BaseResource base) {
        super(base);
    }

    public IResource find(String name) throws VcmFailure {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        String[] componentPath = new String[]{this.getEncodedPath(), Encoder.encodePath((String)name)};
        String encodedPath = PathUtil.composePath(componentPath);
        IResourceFactory factory = this.getResourceFactoryManager().getLocatorFactory();
        return factory.createFile(this.getConnectionTemplID(), encodedPath, PathEncodingFlag.ENCODED);
    }

    public IFile createFile(String newFileName, InputStream dataContent, String contentType, long length) throws VcmFailure {
        if (newFileName == null) {
            throw new NullPointerException("file name is null");
        }
        IPersistentResourceFactory persistence = this.getResourceFactoryManager().getPersistenceFactory();
        String parentPath = this.getDecodedPath();
        String newFilePath = parentPath.endsWith("/") ? parentPath + newFileName : parentPath + "/" + newFileName;
        return persistence.createFile(this.getConnectionTemplID(), newFilePath, dataContent, contentType, length);
    }

    public ICollection createSubCollection(String newCollectionName) throws VcmFailure {
        if (newCollectionName == null) {
            throw new NullPointerException("collection name is null");
        }
        IPersistentResourceFactory persistence = this.getResourceFactoryManager().getPersistenceFactory();
        String parentPath = this.getDecodedPath();
        String newCollectionPath = parentPath.endsWith("/") ? parentPath + newCollectionName : parentPath + "/" + newCollectionName;
        return persistence.createCollection(this.getConnectionTemplID(), newCollectionPath);
    }

    public void copy(IResource source) throws VcmFailure {
        if (source == null) {
            throw new NullPointerException();
        }
        String sourcePath = source.getEncodedPath();
        String targetPath = PathUtil.composePath(new String[]{this.getEncodedPath(), Encoder.encodePath((String)source.getName())});
        CopyRequest copy = new CopyRequest(sourcePath, targetPath, Depth.DEPTH_INFINITY);
        copy.setOverwrite(false);
        this.executeRequest((IRequest)copy);
    }

    public void copy(IResource source, PropertyBehavior propertyCopy, boolean overwrite) throws VcmFailure {
        if (source == null || propertyCopy == null) {
            throw new NullPointerException();
        }
        String sourcePath = source.getEncodedPath();
        String targetPath = PathUtil.composePath(new String[]{this.getEncodedPath(), Encoder.encodePath((String)source.getName())});
        CopyRequest copy = new CopyRequest(sourcePath, targetPath, Depth.DEPTH_INFINITY);
        com.tssap.dtr.client.lib.protocol.requests.dav.PropertyBehavior behavior = null;
        if (propertyCopy == PropertyBehavior.OMIT) {
            behavior = com.tssap.dtr.client.lib.protocol.requests.dav.PropertyBehavior.OMIT;
        } else if (propertyCopy == PropertyBehavior.KEEP_ALIVE_ALL) {
            behavior = com.tssap.dtr.client.lib.protocol.requests.dav.PropertyBehavior.KEEP_ALIVE;
        } else if (propertyCopy == PropertyBehavior.DEFAULT) {
            behavior = com.tssap.dtr.client.lib.protocol.requests.dav.PropertyBehavior.NONE;
        } else {
            behavior = com.tssap.dtr.client.lib.protocol.requests.dav.PropertyBehavior.KEEP_ALIVE;
            String[] keepAliveProps = propertyCopy.getPropertyNames();
            if (keepAliveProps != null) {
                copy.addKeepAliveProperty(keepAliveProps);
            }
        }
        copy.setPropertyBehavior(behavior);
        copy.setOverwrite(overwrite);
        this.executeRequest((IRequest)copy);
    }

    public void move(IResource source) throws VcmFailure {
        if (source == null) {
            throw new NullPointerException();
        }
        String sourcePath = source.getEncodedPath();
        String targetPath = PathUtil.composePath(new String[]{sourcePath, Encoder.encodePath((String)source.getName())});
        CopyRequest move = new CopyRequest(sourcePath, targetPath, Depth.DEPTH_INFINITY);
        move.setOverwrite(false);
        this.executeRequest((IRequest)move);
    }

    public void move(IResource source, PropertyBehavior propertyMove, boolean overwrite) throws VcmFailure {
        if (source == null || propertyMove == null) {
            throw new NullPointerException();
        }
        String sourcePath = source.getEncodedPath();
        String targetPath = PathUtil.composePath(new String[]{this.getEncodedPath(), Encoder.encodePath((String)source.getName())});
        MoveRequest copy = new MoveRequest(sourcePath, targetPath);
        com.tssap.dtr.client.lib.protocol.requests.dav.PropertyBehavior behavior = null;
        if (propertyMove == PropertyBehavior.OMIT) {
            behavior = com.tssap.dtr.client.lib.protocol.requests.dav.PropertyBehavior.OMIT;
        } else if (propertyMove == PropertyBehavior.KEEP_ALIVE_ALL) {
            behavior = com.tssap.dtr.client.lib.protocol.requests.dav.PropertyBehavior.KEEP_ALIVE;
            String[] keepAliveProps = propertyMove.getPropertyNames();
            if (keepAliveProps != null) {
                copy.addKeepAliveProperty(keepAliveProps);
            }
        } else if (propertyMove == PropertyBehavior.DEFAULT) {
            behavior = com.tssap.dtr.client.lib.protocol.requests.dav.PropertyBehavior.NONE;
        }
        copy.setPropertyBehavior(behavior);
        copy.setOverwrite(overwrite);
        this.executeRequest((IRequest)copy);
    }

    public void putUnderBaselineControl() throws VcmFailure {
        BaselineControlRequest baseReq = new BaselineControlRequest(this.getEncodedPath());
        this.executeRequest((IRequest)baseReq);
        this.refresh();
    }

    public void putUnderBaselineControl(IBaseline baseline) throws VcmFailure {
        BaselineControlRequest baseReq = new BaselineControlRequest(this.getEncodedPath(), baseline.getEncodedPath());
        this.executeRequest((IRequest)baseReq);
        this.refresh();
    }

    public long getSize() {
        return -1L;
    }

    public IMemberIterator getAllMembersHiearchy() throws VcmFailure {
        MemberLoader loader = new MemberLoader(this, ResourceMetaClass.MC_FILE, true);
        loader.setLoadParentCachedProperties(true);
        IResource[] members = loader.loadMembers(this.getConnectionTemplID());
        return new MemberTree(members).getTopLevelMembers();
    }

    public IResource[] search(Constraint criterion, boolean recursive) throws VcmFailure {
        Depth depth = recursive ? Depth.DEPTH_INFINITY : Depth.DEPTH_1;
        SearchRequest search = new SearchRequest(this.getEncodedPath(), this.getEncodedPath(), depth);
        search.addWhereClause(criterion.queryElement());
        SearchResourceLoader loader = new SearchResourceLoader(search);
        return loader.loadResources(this.getConnectionTemplID());
    }

    public IResource[] search(Constraint criterion, SearchContext searchContext) throws VcmFailure {
        Depth depth = searchContext.isRecursive ? Depth.DEPTH_INFINITY : Depth.DEPTH_1;
        SearchRequest search = new SearchRequest(this.getEncodedPath(), this.getEncodedPath(), depth);
        search.addWhereClause(criterion.queryElement());
        SearchResourceLoader loader = new SearchResourceLoader(search);
        return loader.loadResources(this.getConnectionTemplID());
    }

    public boolean isWorkspace() throws VcmFailure {
        if (this.getWorkspaceHref() == null) {
            return false;
        }
        return PathUtil.equalWebDAVpaths(this.getEncodedPath(), this.getWorkspaceHref());
    }

    public IWorkspace getAsWorkspace() throws VcmFailure {
        return this.isWorkspace() ? new WorkspaceImpl(this) : null;
    }

    public String[] listMemberNames() throws VcmFailure {
        PropfindRequest pfind = new PropfindRequest(this.getEncodedPath(), Depth.DEPTH_1);
        pfind.addPropertyGet(DAV.DISPLAYNAME.qualifiedName, "DAV:");
        this.executeRequest((IRequest)pfind);
        int memberCount = pfind.countResources() - 1;
        String[] names = new String[memberCount];
        Iterator resources = pfind.getResources();
        if (resources == null) {
            return names;
        }
        String thisPath = this.getEncodedPath();
        String nextPath = null;
        int i = 0;
        while (resources.hasNext()) {
            ResourceElement nextResource = (ResourceElement)resources.next();
            nextPath = nextResource.getPath();
            if (PathUtil.equalWebDAVpaths(thisPath, nextPath)) continue;
            if (i >= memberCount) {
                Object[] args = new String[]{thisPath, nextPath};
                String msg = "List collection member names failed due to resource path clash. parentPath:{0} nextMemberPath:{1}";
                LOC.errorT(msg, args);
                throw new VcmFailure("client internal error");
            }
            names[i++] = PathUtil.getNameFromPath(nextPath);
        }
        if (i != memberCount) {
            LOC.errorT("List collection member names failed. Invalid member count.");
            throw new VcmFailure("client internal error");
        }
        return names;
    }

    public ICollection getAsCollection() throws VcmFailure {
        return this;
    }

    public IFile getAsFile() {
        return null;
    }

    public boolean isFile() {
        return false;
    }

    public IVersionControlledResource getAsVersionControlled() throws VcmFailure {
        if (this.isVersioned()) {
            try {
                return new VersionControlledImpl(this);
            }
            catch (InvalidPathException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        return null;
    }

    public static void mkCollection(int conTemplID, String resourcePath) throws VcmFailure {
        MkColRequest mkcol = new MkColRequest(resourcePath);
        DeltavCommand.execute(conTemplID, (IRequest)mkcol);
    }

    protected String validatePath(String urlPath) throws InvalidPathException {
        String validPath = super.validatePath(urlPath);
        if (this.usePathTrailSlash() && !validPath.endsWith("/")) {
            StringBuffer buf = new StringBuffer(urlPath.length() + 1);
            buf.append(validPath);
            buf.append('/');
            return buf.toString();
        }
        return validPath;
    }

    protected boolean usePathTrailSlash() {
        return true;
    }

    public void setNameServerConfigurations(INameServerConfig[] configs) throws VcmFailure {
        if (configs == null || configs.length == 0) {
            throw new VcmFailure("Invalid parameter value for Name-Server-Config property");
        }
        if (!this.isRootCollection()) {
            throw new VcmFailure("Name-Server-Config property can only be set on the Root Collection");
        }
        String propertyString = this.getNameServerConfigPropertyStringValue(configs);
        if (propertyString == null) {
            throw new VcmFailure("Unable to construct Name-Server-Config property String value");
        }
        IMutableProperty property = PropertyFactoryAccess.getFactory().createProperty(XCM.NAMESPACE_PREFIX, XCM.NAME_SERVER_CONFIG.localName);
        property.setValue(propertyString);
        this.setProperties(new IProperty[]{property});
    }

    public boolean isRootCollection() {
        String contextRootPath = CollectionImpl.getContextRootPath(this.getConnectionTemplID());
        return contextRootPath != null && this.getDecodedPath().equalsIgnoreCase(contextRootPath);
    }

    private String getNameServerConfigPropertyStringValue(INameServerConfig[] configs) throws VcmFailure {
        String delimiter = this.findDelimiter(configs);
        if (delimiter == null) {
            throw new VcmFailure("Unable to find Delimiter for property");
        }
        StringBuffer propertyStringValue = new StringBuffer(delimiter);
        int i = 0;
        while (i < configs.length) {
            INameServerConfig nextConfig = configs[i];
            propertyStringValue.append(this.getConfigStringValue(delimiter, nextConfig));
            ++i;
        }
        return propertyStringValue.toString();
    }

    private String getConfigStringValue(String delimiter, INameServerConfig config) {
        StringBuffer propertyStringValue = new StringBuffer();
        propertyStringValue.append(config.getURL());
        propertyStringValue.append(delimiter);
        propertyStringValue.append(config.getUser());
        propertyStringValue.append(delimiter);
        propertyStringValue.append(config.getPassword());
        propertyStringValue.append(delimiter);
        propertyStringValue.append(config.getTrustStore());
        propertyStringValue.append(delimiter);
        propertyStringValue.append(config.getKeyStore());
        propertyStringValue.append(delimiter);
        return propertyStringValue.toString();
    }

    private String findDelimiter(INameServerConfig[] configs) {
        String[] delimiterArray = new String[]{"\n", "!", "\u00c2\u00a7", "$", "%", "&", "{", "}", "[", "]", "=", "?", "~", "\u00c2\u00b0", "@", "<", ">", "*", ";"};
        StringBuffer configsAsStringBuffer = new StringBuffer();
        int i = 0;
        while (i < configs.length) {
            INameServerConfig nextConfig = configs[i];
            configsAsStringBuffer.append(nextConfig.getURL());
            configsAsStringBuffer.append(nextConfig.getUser());
            configsAsStringBuffer.append(nextConfig.getPassword());
            configsAsStringBuffer.append(nextConfig.getTrustStore());
            configsAsStringBuffer.append(nextConfig.getKeyStore());
            ++i;
        }
        String configsAsString = configsAsStringBuffer.toString();
        int i2 = 0;
        while (i2 < delimiterArray.length) {
            String nextDelimiter = delimiterArray[i2];
            if (configsAsString.indexOf(nextDelimiter) == -1) {
                return nextDelimiter;
            }
            ++i2;
        }
        return null;
    }

    private static String getContextRootPath(int connectionTemplID) {
        try {
            IConnectionTemplate template = ConnectionPool.getTemplateProvider().getConnectionTemplate(connectionTemplID);
            String basePath = template.getBasePath();
            if (basePath != null && !"/".equals(basePath)) {
                return basePath;
            }
            return null;
        }
        catch (InvalidTemplateIDException e) {
            return null;
        }
    }

    public INameServerConfig createNameServerConfiguration(String URL2, String user, String password, String trustStore, String keyStore) {
        return new NameServerConfigImpl(URL2, user, password, trustStore, keyStore);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SearchResourceLoader
    extends AbstractResourceLoader {
        private SearchRequest search;

        public SearchResourceLoader(SearchRequest search) {
            if (search == null) {
                throw new NullPointerException();
            }
            this.search = search;
        }

        protected void addPropertyNS(String nsPrefix, String nsUri) {
            this.search.addNamespace(nsPrefix, nsUri);
        }

        protected void addPropertyToLoad(String qualifiedName) {
            this.search.addSelectProperty(qualifiedName);
        }

        protected IRequest getRequest() {
            return this.search;
        }

        protected ResourceMetaClass getResourceMetaClass() {
            return ResourceMetaClass.MC_FILE;
        }
    }
}

