/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IConfiguration;
import com.tssap.dtr.client.lib.deltavlib.IFile;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactory;
import com.tssap.dtr.client.lib.deltavlib.IResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.PathUtil;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.AbstractResource;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.ResFactoryMgrImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.cache.IConvertableCachedObj;
import com.tssap.dtr.client.lib.deltavlib.impl.util.DataUtil;
import com.tssap.dtr.client.lib.deltavlib.impl.util.ResourceTypeProperty;
import com.tssap.dtr.client.lib.deltavlib.lock.IResourceLockManager;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyCacheControl;
import com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.deltavlib.properties.QualifiedName;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.DeleteRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.dav.MoveRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.PropfindOption;
import com.tssap.dtr.client.lib.protocol.requests.dav.PropfindRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.ProppatchRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.VersionControlRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.Date;
import java.util.Iterator;

public abstract class BaseResource
extends AbstractResource
implements IResource {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$impl$BaseResource == null ? (class$com$tssap$dtr$client$lib$deltavlib$impl$BaseResource = BaseResource.class$("com.tssap.dtr.client.lib.deltavlib.impl.BaseResource")) : class$com$tssap$dtr$client$lib$deltavlib$impl$BaseResource));
    protected static final int FLAG_INITIALIZED = 1;
    protected static final int FLAG_IS_COLLECTION = 2;
    protected static final int FLAG_IS_FILE = 4;
    protected static final int FLAG_IS_PRINCIPAL = 8;
    protected static final int FLAG_IS_WORKING_RESOURCE = 64;
    protected static final int FLAG_IS_RESOURCETYPE_INITIALIZED = 128;
    private int flags;
    private String canonicalPath;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$impl$BaseResource;

    private boolean testResourceTypeFlag(int typeFlag) throws VcmFailure {
        if (!this.testFLAG(128)) {
            this.getProperty(DAV.RESOURCETYPE.qualifiedName);
        }
        return this.testFLAG(typeFlag);
    }

    protected BaseResource(BaseResource resource) {
        super(resource);
        this.flags = resource.flags;
    }

    protected boolean testFLAG(int testFlag) {
        return (this.flags & testFlag) != 0;
    }

    protected void localSetContentType(String contentType) {
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        this.setPropertyStringValue(DAV.GETCONTENTTYPE.qualifiedName, contentType);
    }

    protected void localSetContentLength(long length) {
        this.setPropertyStringValue(DAV.GETCONTENTLENGTH.qualifiedName, Long.toString(length));
    }

    protected IConvertableCachedObj onSetNonPrimitiveCachedProperty(PropertyElement property) {
        return null;
    }

    protected IConvertableCachedObj onSetDAVResourceType(PropertyElement prop) {
        IConvertableCachedObj typeProp = ResourceTypeProperty.getResourceType(prop);
        if (typeProp != null) {
            if (typeProp == ResourceTypeProperty.TYPE_COLLECTION || typeProp == ResourceTypeProperty.TYPE_COLLECTION_PRINCIPAL) {
                this.flags |= 2;
            } else if (typeProp == ResourceTypeProperty.TYPE_FILE) {
                this.flags |= 4;
            } else if (typeProp == ResourceTypeProperty.TYPE_WORKING_RESOURCE) {
                this.flags |= 0x44;
            } else if (typeProp == ResourceTypeProperty.TYPE_WORKING_COLLECTION) {
                this.flags |= 0x42;
            } else if (typeProp == ResourceTypeProperty.TYPE_WORKSPACE) {
                this.flags |= 2;
            } else if (typeProp == ResourceTypeProperty.TYPE_PRINCIPAL || typeProp == ResourceTypeProperty.TYPE_COLLECTION_PRINCIPAL) {
                this.flags |= 8;
            }
        } else {
            if (LOC.beWarning()) {
                LOC.warningT("No resource type property singleton for reuse");
            }
            typeProp = null;
        }
        this.flags |= 0x80;
        return typeProp;
    }

    protected IResourceFactoryManager resourceFactoryManager() {
        return ResFactoryMgrImpl.getInstance();
    }

    protected void setInitialized(boolean state) {
        if (state) {
            this.flags |= 1;
            try {
                this.setPath(this.validatePath(this.getEncodedPath()));
            }
            catch (InvalidPathException invalidPathException) {}
        } else {
            this.flags &= 0xFFFFFFFE;
        }
    }

    protected String getRepositoryWebRootContext() {
        String path = this.getEncodedPath();
        int pos = path.indexOf(47, 1);
        if (pos < 0) {
            return path;
        }
        return path.substring(0, pos + 1);
    }

    protected boolean testAndAddCachedProperty(String propertyName) {
        IPropertyCacheControl cacheControl = this.getPropertyCacheControl();
        boolean isCached = 4 != cacheControl.getPropertyState(propertyName);
        cacheControl.addPropertyToCache(propertyName);
        return isCached;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String constructCanonicalPath() throws VcmFailure {
        String string;
        boolean notCachedDavWorkspace;
        boolean notCachedXcmPath;
        block16: {
            String string2;
            block15: {
                notCachedXcmPath = !this.testAndAddCachedProperty(XCM.PATH.qualifiedName);
                notCachedDavWorkspace = !this.testAndAddCachedProperty(DAV.WORKSPACE.qualifiedName);
                boolean notCachedResourceType = !this.testAndAddCachedProperty(DAV.RESOURCETYPE.qualifiedName);
                try {
                    String xcmDecodedPath = this.getPropertyStringValue(XCM.PATH.qualifiedName);
                    if (xcmDecodedPath == null) {
                        String string3 = this.getDecodedPath();
                        Object var10_7 = null;
                        IPropertyCacheControl cacheControl = this.getPropertyCacheControl();
                        if (notCachedXcmPath) {
                            cacheControl.clearProperty(XCM.PATH.qualifiedName);
                        }
                        if (notCachedDavWorkspace) {
                            cacheControl.clearProperty(DAV.WORKSPACE.qualifiedName);
                        }
                        if (!notCachedDavWorkspace) return string3;
                        cacheControl.clearProperty(DAV.RESOURCETYPE.qualifiedName);
                        return string3;
                    }
                    String workspacePath = this.getWorkspacePath();
                    if (workspacePath == null) {
                        string2 = this.getDecodedPath();
                        break block15;
                    }
                    StringBuffer pathBuf = new StringBuffer();
                    boolean isCollection = this.isCollection();
                    if (isCollection && PathUtil.equalWebDAVpaths(this.getDecodedPath(), workspacePath)) {
                        PathUtil.appendPathElement(pathBuf, this.getRepositoryWebRootContext());
                        PathUtil.appendPathElement(pathBuf, xcmDecodedPath);
                    } else {
                        PathUtil.appendPathElement(pathBuf, workspacePath);
                        PathUtil.appendPathElement(pathBuf, xcmDecodedPath);
                    }
                    if (isCollection) {
                        pathBuf.append('/');
                    }
                    string = pathBuf.toString();
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    IPropertyCacheControl cacheControl = this.getPropertyCacheControl();
                    if (notCachedXcmPath) {
                        cacheControl.clearProperty(XCM.PATH.qualifiedName);
                    }
                    if (notCachedDavWorkspace) {
                        cacheControl.clearProperty(DAV.WORKSPACE.qualifiedName);
                    }
                    if (!notCachedDavWorkspace) throw throwable;
                    cacheControl.clearProperty(DAV.RESOURCETYPE.qualifiedName);
                    throw throwable;
                }
            }
            Object var10_8 = null;
            IPropertyCacheControl cacheControl = this.getPropertyCacheControl();
            if (notCachedXcmPath) {
                cacheControl.clearProperty(XCM.PATH.qualifiedName);
            }
            if (notCachedDavWorkspace) {
                cacheControl.clearProperty(DAV.WORKSPACE.qualifiedName);
            }
            if (!notCachedDavWorkspace) return string2;
            cacheControl.clearProperty(DAV.RESOURCETYPE.qualifiedName);
            return string2;
        }
        Object var10_9 = null;
        IPropertyCacheControl cacheControl = this.getPropertyCacheControl();
        if (notCachedXcmPath) {
            cacheControl.clearProperty(XCM.PATH.qualifiedName);
        }
        if (notCachedDavWorkspace) {
            cacheControl.clearProperty(DAV.WORKSPACE.qualifiedName);
        }
        if (!notCachedDavWorkspace) return string;
        cacheControl.clearProperty(DAV.RESOURCETYPE.qualifiedName);
        return string;
    }

    protected String getWorkspacePath() throws VcmFailure {
        String workspaceHref = this.getWorkspaceHref();
        return workspaceHref == null ? null : Encoder.decodePath((String)workspaceHref);
    }

    public abstract IFile getAsFile() throws VcmFailure;

    public abstract ICollection getAsCollection() throws VcmFailure;

    public abstract IVersionControlledResource getAsVersionControlled() throws VcmFailure;

    public boolean isInitialized() {
        return (this.flags & 1) != 0;
    }

    public BaseResource(int conTemplID, String path) throws InvalidPathException {
        super(conTemplID, path);
    }

    public final String getCanonicalPath() throws VcmFailure {
        String decodedPath;
        if (this.canonicalPath == null) {
            this.canonicalPath = this.constructCanonicalPath();
        }
        if (this.canonicalPath.equals(decodedPath = this.getDecodedPath())) {
            this.canonicalPath = decodedPath;
        }
        return this.canonicalPath;
    }

    public final String getCanonicalName() throws VcmFailure {
        return PathUtil.getNameFromPath(this.getCanonicalPath());
    }

    public boolean isCollection() throws VcmFailure {
        return this.testResourceTypeFlag(2);
    }

    public boolean isFile() throws VcmFailure {
        return this.testResourceTypeFlag(4);
    }

    public String getDisplayName() throws VcmFailure {
        return this.getPropertyStringValue(DAV.DISPLAYNAME.qualifiedName);
    }

    public void setDisplayName(String name) throws VcmFailure {
        if (name == null) {
            throw new NullPointerException();
        }
        this.setProperty(DAV.DISPLAYNAME.qualifiedName, name);
    }

    public long getSize() throws VcmFailure {
        String lengthStr = this.getPropertyStringValue(DAV.GETCONTENTLENGTH.qualifiedName);
        if (lengthStr != null) {
            try {
                return Long.parseLong(lengthStr);
            }
            catch (NumberFormatException e) {
                throw new VcmFailure("client internal error", e);
            }
        }
        return -1L;
    }

    public String getContentType() throws VcmFailure {
        return this.getPropertyStringValue(DAV.GETCONTENTTYPE.qualifiedName);
    }

    public void setContentType(String contentType) throws VcmFailure {
        this.remoteSetProperty(DAV.GETCONTENTTYPE.qualifiedName, contentType);
        this.localSetContentType(contentType);
    }

    public String getPersistentURL() {
        return this.getResourceURL();
    }

    public void remove() throws VcmFailure {
        DeleteRequest delete = new DeleteRequest(this.getEncodedPath());
        this.executeRequest((IRequest)delete);
    }

    public String getComment() throws VcmFailure {
        return this.getPropertyStringValue(DAV.COMMENT.qualifiedName);
    }

    public void setComment(String comment) throws VcmFailure {
        this.setProperty(DAV.COMMENT.qualifiedName, comment);
    }

    public String getAuthor() throws VcmFailure {
        return this.getPropertyStringValue(DAV.CREATOR_DISPLAYNAME.qualifiedName);
    }

    public void setAuthor(String author) throws VcmFailure {
        if (author == null) {
            throw new NullPointerException("null author");
        }
        this.setProperty(DAV.CREATOR_DISPLAYNAME.qualifiedName, author);
    }

    public void rename(String newName) throws VcmFailure {
        String currentPath = this.getEncodedPath();
        String destPath = PathUtil.getParentPath(currentPath) + newName;
        MoveRequest move = new MoveRequest(currentPath, destPath);
        move.setOverwrite(false);
        this.executeRequest((IRequest)move);
        try {
            this.setPath(destPath);
            this.canonicalPath = null;
        }
        catch (InvalidPathException e) {
            throw new VcmFailure("internal client error.", e);
        }
        if (this.isPropertyInitialized(DAV.DISPLAYNAME.qualifiedName)) {
            this.setPropertyStringValue(DAV.DISPLAYNAME.qualifiedName, newName);
        } else {
            this.setPropertyStringValue(DAV.DISPLAYNAME.qualifiedName, null);
        }
    }

    public Date created() throws VcmFailure {
        return this.getPropertyDateValue(DAV.CREATIONDATE.qualifiedName);
    }

    public Date lastModified() throws VcmFailure {
        return this.getPropertyDateValue(DAV.GETLASTMODIFIED.qualifiedName);
    }

    public boolean isVersioned() throws VcmFailure {
        IPropertyCacheControl cacheControl = this.getPropertyCacheControl();
        String ciHref = null;
        String coHref = null;
        String vhHref = null;
        int checkedInState = cacheControl.getPropertyState(DAV.CHECKED_IN.qualifiedName);
        if (checkedInState == 1 && (ciHref = this.getPropertyHrefValue(DAV.CHECKED_IN.qualifiedName)) != null) {
            return true;
        }
        int checkedOutState = cacheControl.getPropertyState(DAV.CHECKED_OUT.qualifiedName);
        if (checkedOutState == 1 && (coHref = this.getPropertyHrefValue(DAV.CHECKED_OUT.qualifiedName)) != null) {
            return true;
        }
        if (this.isPropertyInitialized(DAV.VERSION_HISTORY.qualifiedName) && (vhHref = this.getPropertyHrefValue(DAV.VERSION_HISTORY.qualifiedName)) != null) {
            return true;
        }
        if (checkedInState == 2) {
            return false;
        }
        cacheControl.addPropertyToCache(DAV.CHECKED_IN.qualifiedName);
        cacheControl.addPropertyToCache(DAV.CHECKED_OUT.qualifiedName);
        ciHref = this.getPropertyHrefValue(DAV.CHECKED_IN.qualifiedName);
        coHref = this.getPropertyHrefValue(DAV.CHECKED_OUT.qualifiedName);
        if (checkedOutState == 4) {
            cacheControl.clearProperty(DAV.CHECKED_OUT.qualifiedName);
        }
        if (checkedInState == 4) {
            cacheControl.clearProperty(DAV.CHECKED_IN.qualifiedName);
        }
        return ciHref != null || coHref != null;
    }

    public String getEntityTag() throws VcmFailure {
        return this.getPropertyStringValue(DAV.GETETAG.qualifiedName);
    }

    public boolean isMemberOfConfiguration() throws VcmFailure {
        return this.getVcConfigurationHref() != null;
    }

    public IConfiguration getVersionControlledConfiguration() throws VcmFailure {
        if (this.isMemberOfConfiguration()) {
            IResourceFactory pxyFy = this.getResourceFactoryManager().getProxyFactory();
            return pxyFy.createConfiguration(this.getConnectionTemplID(), this.getVcConfigurationHref(), PathEncodingFlag.ENCODED);
        }
        return null;
    }

    public IWorkspace getWorkspace() throws VcmFailure {
        String workspaceHref = this.getWorkspaceHref();
        if (workspaceHref != null) {
            IResourceFactory factory = this.getResourceFactoryManager().getProxyFactory();
            return factory.createWorkspace(this.getConnectionTemplID(), workspaceHref, PathEncodingFlag.ENCODED);
        }
        return null;
    }

    public QualifiedName[] getQPropertyNames() throws VcmFailure {
        PropfindRequest pfind = new PropfindRequest(this.getEncodedPath(), Depth.DEPTH_0);
        pfind.setOption(PropfindOption.PROPERTY_NAMES);
        IResponse resp = this.executeRequest((IRequest)pfind);
        ResourceElement resource = pfind.getResource(0);
        if (resource != null) {
            QualifiedName[] names = new QualifiedName[resource.countProperties()];
            Iterator props = resource.getProperties();
            int i = 0;
            while (props.hasNext()) {
                PropertyElement p = (PropertyElement)props.next();
                names[i] = new QualifiedName(p.getNamespaceURI(), p.getName());
                ++i;
            }
            return names;
        }
        return new QualifiedName[0];
    }

    public String[] getPropertyNames() throws VcmFailure {
        PropfindRequest pfind = new PropfindRequest(this.getEncodedPath(), Depth.DEPTH_0);
        pfind.setOption(PropfindOption.PROPERTY_NAMES);
        IResponse resp = this.executeRequest((IRequest)pfind);
        ResourceElement resource = pfind.getResource(0);
        if (resource != null) {
            String[] names = new String[resource.countProperties()];
            Iterator props = resource.getProperties();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (props.hasNext()) {
                PropertyElement p = (PropertyElement)props.next();
                String prefix = NSPrefixToUriMap.getPrefixForUri(p.getNamespaceURI());
                if (prefix == null) continue;
                buf.setLength(0);
                names[i++] = buf.append(prefix).append(':').append(p.getName()).toString();
            }
            if (names.length != i) {
                String[] cutNames = new String[i];
                System.arraycopy(names, 0, cutNames, 0, cutNames.length);
                return cutNames;
            }
            return names;
        }
        return new String[0];
    }

    protected void setHrefProperty(String propertyName, IResource[] resources) throws VcmFailure {
        if (propertyName == null) {
            throw new NullPointerException("null property to set");
        }
        ProppatchRequest ppatchReq = new ProppatchRequest(this.getEncodedPath());
        String nsPrefix = PropertyUtil.getNamespacePrefix(propertyName);
        String nsUri = PropertyUtil.getNamespaceURI(propertyName);
        if (null != nsPrefix) {
            ppatchReq.addNamespace(nsPrefix, nsUri);
        }
        ppatchReq.addNamespace(PropertyUtil.getNamespacePrefix(propertyName), PropertyUtil.getNamespaceURI(propertyName));
        ppatchReq.addNamespace("DAV", "DAV:");
        PropertyElement protocolProperty = new PropertyElement(propertyName, "DAV:");
        if (resources != null) {
            int i = 0;
            while (i < resources.length) {
                protocolProperty.addChild(new Element(DAV.HREF.localName, "DAV:", resources[i].getEncodedPath()));
                ++i;
            }
        }
        ppatchReq.addPropertySet((Element)protocolProperty);
        this.performCheckedProppath(ppatchReq);
        String[] hrefs = null;
        if (resources != null || resources.length > 0) {
            hrefs = DataUtil.getAsHrefs(resources);
        }
        this.setPropertyHrefSetValue(propertyName, hrefs);
    }

    public void setProperties(IProperty[] propertyNames) throws VcmFailure {
        DataUtil.checkArrayForNull(propertyNames);
        this.remoteSetProperties(propertyNames);
        this.localSetProperties(propertyNames);
    }

    protected void setProperty(String propertyName, String value) throws VcmFailure {
        if (propertyName == null) {
            throw new NullPointerException("null property name");
        }
        this.remoteSetProperty(propertyName, value);
        this.setPropertyStringValue(propertyName, value);
    }

    public void removeProperties(String[] propertyNames) throws VcmFailure {
        DataUtil.checkArrayForNull(propertyNames);
        this.remoteRemoveProperties(propertyNames);
        IPropertyCacheControl cacheControl = this.getPropertyCacheControl();
        int i = 0;
        while (i < propertyNames.length) {
            cacheControl.clearProperty(propertyNames[i]);
            ++i;
        }
    }

    public IProperty[] getPropertySet(String[] propertyNames) throws VcmFailure {
        DataUtil.checkArrayForNull(propertyNames);
        return this.getPropertyObjects(propertyNames);
    }

    public void putUnderVersionControl() throws VcmFailure {
        VersionControlRequest vcrRequest = new VersionControlRequest(this.getEncodedPath());
        this.executeRequest((IRequest)vcrRequest);
    }

    public String getXCMObjectId() throws VcmFailure {
        return this.getPropertyStringValue(XCM.OID.qualifiedName);
    }

    public IResourceLockManager getLockManager() {
        throw new UnsupportedOperationException("not implemented");
    }

    public String toString() {
        return this.getDecodedPath() + "[" + this.getClass() + "]";
    }

    protected String getVcConfigurationHref() throws VcmFailure {
        return this.getPropertyHrefValue(DAV.VERSION_CONTROLLED_CONFIGURATION.qualifiedName);
    }

    protected String getWorkspaceHref() throws VcmFailure {
        return this.getPropertyHrefValue(DAV.WORKSPACE.qualifiedName);
    }

    protected boolean usePathTrailSlash() {
        if (this.testFLAG(128)) {
            return this.testFLAG(2);
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

