/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.ICheckedOutResource;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.IVersion;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.AbstractCompositeLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.ActivityComposite;
import com.tssap.dtr.client.lib.deltavlib.impl.ActivityContent;
import com.tssap.dtr.client.lib.deltavlib.impl.IActivityContentMember;
import com.tssap.dtr.client.lib.deltavlib.impl.ResourceMetaClass;
import com.tssap.dtr.client.lib.deltavlib.impl.VersionSetLoader;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityComposite;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyReport;
import java.util.ArrayList;
import java.util.Collection;

public class ActivityVSetCompositeLoader
extends VersionSetLoader {
    protected static final State CHECKOUT_STATE = new State(){

        public void storeComponent(ActivityComposite composite, IResource[] component) {
            composite.checkoutSet = (ICheckedOutResource[])component;
        }
    };
    protected static final State VER_STATE = new State(){

        public void storeComponent(ActivityComposite composite, IResource[] component) {
            composite.versionSet = (IVersion[])component;
        }
    };
    protected static final State CONTENT_STATE = new State(){

        public void storeComponent(ActivityComposite composite, IResource[] component) {
            try {
                composite.activityContent = new ActivityContent((IActivityContentMember[])component);
            }
            catch (VcmFailure e) {
                throw new IllegalStateException();
            }
        }
    };
    protected static final State WS_STATE = new State(){

        public void storeComponent(ActivityComposite composite, IResource[] component) {
            composite.workspaceSet = (IWorkspace[])component;
        }
    };
    protected static final State SUBACT_STATE = new State(){

        public void storeComponent(ActivityComposite composite, IResource[] component) {
            composite.subactivitySet = (IActivity[])component;
        }
    };
    private State state;
    IActivityComposite currentComposite;
    Collection activityComposites = new ArrayList();
    ExpandPropertyReport report;

    ActivityVSetCompositeLoader(int conTemplID, ExpandPropertyReport report) {
        super(conTemplID);
        this.report = report;
    }

    ActivityVSetCompositeLoader(int conTemplID) {
        super(conTemplID);
    }

    IActivityComposite[] getResult() {
        return this.activityComposites.toArray(new IActivityComposite[this.activityComposites.size()]);
    }

    protected void addCompositeProperty(String compositeProperty) {
        if (compositeProperty == null) {
            throw new NullPointerException();
        }
        this.report.addPropertyExpand(compositeProperty, PropertyUtil.getNamespaceURI(compositeProperty), null);
    }

    protected ResourceMetaClass onGetComponentType(PropertyElement nextProp) {
        ResourceMetaClass metaClass = null;
        if ("DAV:".equals(nextProp.getNamespaceURI())) {
            if (DAV.CURRENT_WORKSPACE_SET.localName.equals(nextProp.getName())) {
                this.state = WS_STATE;
                metaClass = ResourceMetaClass.MC_WORKSPACE;
            } else if (DAV.ACTIVITY_VERSION_SET.localName.equals(nextProp.getName())) {
                this.state = VER_STATE;
                metaClass = ResourceMetaClass.MC_VERSION;
            } else if (DAV.ACTIVITY_CHECKOUT_SET.localName.equals(nextProp.getName())) {
                this.state = CHECKOUT_STATE;
                metaClass = ResourceMetaClass.MC_WORKING_RESOURCE;
            } else if (DAV.SUBACTIVITY_SET.localName.equals(nextProp.getName())) {
                this.state = SUBACT_STATE;
                metaClass = ResourceMetaClass.MC_ACTIVITY;
            }
        } else if (XCM.NAMESPACE_URI.equals(nextProp.getNamespaceURI())) {
            if (XCM.ACTIVITY_CONTENT_SET.localName.equals(nextProp.getName())) {
                this.state = CONTENT_STATE;
                metaClass = ResourceMetaClass.MC_ACTIVITY_CONTENT_MEMBER;
            } else if (XCM.VERSION_SET.localName.equals(nextProp.getName())) {
                this.state = VER_STATE;
                metaClass = ResourceMetaClass.MC_VERSION;
            }
        }
        if (metaClass != null) {
            return metaClass;
        }
        throw new IllegalStateException();
    }

    protected ResourceMetaClass onGetCompositeType() {
        this.currentComposite = new ActivityComposite();
        return ResourceMetaClass.MC_ACTIVITY;
    }

    protected void onStoreComponent(IResource[] components) {
        this.state.storeComponent((ActivityComposite)this.currentComposite, components);
    }

    protected void onStoreComposite(IResource compositeResource) {
        ((ActivityComposite)this.currentComposite).activity = (IActivity)compositeResource;
        this.activityComposites.add(this.currentComposite);
    }

    public void addComponentDef(AbstractCompositeLoader.ComponentDef componentDef) {
        this.report.addPropertyExpand((ExpandPropertyDef)componentDef, null);
    }

    public void addSecondLevelComponentDef(AbstractCompositeLoader.ComponentDef componentDef, AbstractCompositeLoader.ComponentDef parentComponentDef) {
        this.report.addPropertyExpand((ExpandPropertyDef)componentDef, (ExpandPropertyDef)parentComponentDef);
    }

    static interface State {
        public void storeComponent(ActivityComposite var1, IResource[] var2);
    }
}

