/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.IResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.AbstractResourceLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.ActivityCompositeLoader;
import com.tssap.dtr.client.lib.deltavlib.impl.BaseResource;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.ResourceMetaClass;
import com.tssap.dtr.client.lib.deltavlib.impl.VersionSetLoader;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.deltavlib.xcm.ActivityCompositeDef;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityComposite;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityQuery;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityReport;
import com.tssap.dtr.client.lib.deltavlib.xcm.IDateRange;
import com.tssap.dtr.client.lib.deltavlib.xcm.IPropagationList;
import com.tssap.dtr.client.lib.deltavlib.xcm.IVersionSetHolder;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import com.tssap.dtr.client.lib.protocol.requests.xcm.ActivityReport;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.BitSet;
import java.util.Iterator;

public class ActivityReportImpl
implements IActivityReport {
    private String requestPath;
    private int conTemplID;
    private ActivityCompositeDef definition;
    protected ActivityReport report;

    private static BaseResource localSetProperties(BaseResource resource, Iterator propertyIt) {
        while (propertyIt.hasNext()) {
            PropertyElement nextProp = (PropertyElement)propertyIt.next();
            resource.localSetProperty(nextProp);
        }
        return resource;
    }

    private void initResources(IResource[] apiResources, Iterator resourceIt, ResourceMetaClass metaclass) throws InvalidPathException {
        if (resourceIt == null && apiResources.length == 0) {
            return;
        }
        int i = 0;
        while (i < apiResources.length) {
            ResourceElement nextResource = (ResourceElement)resourceIt.next();
            BaseResource base = metaclass.newInstance(this.conTemplID, nextResource.getPath());
            apiResources[i] = ActivityReportImpl.localSetProperties(base, nextResource.getProperties());
            ++i;
        }
    }

    private ExpandPropertyDef initExpandedProperty(ActivityReport report, String expandedProp, String[] propToGet) {
        String nsuri = PropertyUtil.getNamespaceURI(expandedProp);
        ExpandPropertyDef topProp = report.addPropertyExpand(expandedProp, nsuri, null);
        String property = null;
        int i = 0;
        while (i < propToGet.length) {
            property = propToGet[i];
            if (property != null) {
                nsuri = PropertyUtil.getNamespaceURI(property);
                if (nsuri != null) {
                    report.addPropertyExpand(property, nsuri, topProp);
                } else {
                    report.addPropertyExpand(property, topProp);
                }
            }
            ++i;
        }
        return topProp;
    }

    private void initReport(ActivityReport report) {
        ExpandPropertyDef top;
        if (this.definition.currentWorkspaceSetProperties != null) {
            top = this.initExpandedProperty(report, DAV.CURRENT_WORKSPACE_SET.qualifiedName, this.definition.currentWorkspaceSetProperties);
            this.ensureImplicitPropertiesAdded(top, new String[]{DAV.RESOURCETYPE.qualifiedName, DAV.WORKSPACE.qualifiedName});
        }
        if (this.definition.versionSetProperties != null) {
            top = this.initExpandedProperty(report, DAV.ACTIVITY_VERSION_SET.qualifiedName, this.definition.versionSetProperties);
            this.ensureImplicitPropertiesAdded(top, new String[]{DAV.RESOURCETYPE.qualifiedName});
        }
        if (this.definition.activityContentProperties != null) {
            top = this.initExpandedProperty(report, XCM.ACTIVITY_CONTENT_SET.qualifiedName, this.definition.activityContentProperties);
            this.ensureImplicitPropertiesAdded(top, new String[]{DAV.RESOURCETYPE.qualifiedName, DAV.AUTO_UPDATE.qualifiedName});
        }
        if (this.definition.subActivityProperties != null) {
            this.initExpandedProperty(report, DAV.SUBACTIVITY_SET.qualifiedName, this.definition.subActivityProperties);
        }
        if (this.definition.checkedOutSetProperties != null) {
            top = this.initExpandedProperty(report, DAV.ACTIVITY_CHECKOUT_SET.qualifiedName, this.definition.checkedOutSetProperties);
            this.ensureImplicitPropertiesAdded(top, new String[]{DAV.RESOURCETYPE.qualifiedName, DAV.AUTO_UPDATE.qualifiedName});
        }
        if (this.definition.activityProperties == null) {
            return;
        }
        int i = 0;
        while (i < this.definition.activityProperties.length) {
            String qualifiedNameStr = this.definition.activityProperties[i];
            if (qualifiedNameStr != null) {
                String prefix = PropertyUtil.getNamespacePrefix(qualifiedNameStr);
                if (prefix != null) {
                    report.addNamespace(prefix, PropertyUtil.getNamespaceURI(qualifiedNameStr));
                }
                report.addSelectProperty(qualifiedNameStr);
            }
            ++i;
        }
    }

    private void ensureImplicitPropertiesAdded(ExpandPropertyDef topProp, String[] implicitProps) {
        BitSet flags = new BitSet(implicitProps.length);
        ExpandPropertyDef child = topProp.firstChild;
        int i = 0;
        while (child != null) {
            int pos = PropertyUtil.searchProperty(implicitProps, child.name, child.namespaceURI);
            if (pos >= 0) {
                flags.set(pos);
            }
            child = child.next;
            ++i;
        }
        PropertyUtil.QualifiedName qualifiedName = new PropertyUtil.QualifiedName();
        int i2 = 0;
        while (i2 < implicitProps.length) {
            if (!flags.get(i2)) {
                PropertyUtil.getAsQualifiedName(qualifiedName, implicitProps[i2]);
                topProp.addChild(new ExpandPropertyDef(qualifiedName.name, qualifiedName.namespaceUri));
            }
            ++i2;
        }
    }

    public ActivityReportImpl(int conTemplID, String requestUri) {
        this.conTemplID = conTemplID;
        this.requestPath = requestUri;
    }

    public IActivity[] select(IActivityQuery query) throws VcmFailure {
        if (query == null) {
            throw new NullPointerException();
        }
        this.createInitializedRequest(query);
        ActivityLoader activityLoader = new ActivityLoader();
        return (IActivity[])activityLoader.loadResources(this.conTemplID);
    }

    public IActivityComposite[] select(IActivityQuery query, ActivityCompositeDef resultDef) throws VcmFailure {
        if (query == null || resultDef == null) {
            throw new NullPointerException();
        }
        this.definition = resultDef;
        this.createInitializedRequest(query);
        ActivityCompositeLoader.ActivityReportResultLoader resultLoader = new ActivityCompositeLoader.ActivityReportResultLoader(this.conTemplID, this.report);
        resultLoader.setCompositeDefinition(resultDef);
        return resultLoader.execute();
    }

    private void createInitializedRequest(IActivityQuery query) {
        IProperty[] propertyEquals;
        String[] workspaces;
        String to;
        String from;
        if (query == null) {
            return;
        }
        this.report = new ActivityReport(Encoder.encodePath((String)this.requestPath));
        IDateRange dateRange = query.getCreationDate();
        if (dateRange != null) {
            from = dateRange.getFrom() != null ? Converter.dateToHTTPDate(dateRange.getFrom()) : null;
            to = dateRange.getTo() != null ? Converter.dateToHTTPDate(dateRange.getTo()) : null;
            this.report.addCreationDateQuery(from, to);
        }
        if ((dateRange = query.getIntegrationDate()) != null) {
            from = dateRange.getFrom() != null ? Converter.dateToHTTPDate(dateRange.getFrom()) : null;
            to = dateRange.getTo() != null ? Converter.dateToHTTPDate(dateRange.getTo()) : null;
            this.report.addIntegrationDateQuery(from, to);
        }
        if (query.getClosedOnly()) {
            this.report.applyToClosedActivitiesOnly();
        }
        if (query.getOpenedOnly()) {
            this.report.applyToOpenActivitiesOnly();
        }
        if (query.getSelectEmptyActivitiesOnly()) {
            this.report.applyToEmptyActivitiesOnly();
        } else if (query.getSelectNonEmptyActivitiesOnly()) {
            this.report.applyToNonEmptyActivitiesOnly();
        }
        Integer intSeqNum = query.getIntegrationSeqNum();
        if (intSeqNum != null) {
            this.report.addIntegrationSequenceQuery(intSeqNum.intValue());
        }
        if (query.getUser() != null) {
            this.report.addUserQuery(query.getUser());
        }
        if (query.getNamePrefix() != null) {
            this.report.addNameQuery(query.getNamePrefix());
        }
        if ((workspaces = query.getWorkspaceSet()) != null) {
            int i = 0;
            while (i < workspaces.length) {
                this.report.addWorkspaceQuery(Encoder.encodePath((String)workspaces[i]));
                ++i;
            }
        }
        if ((propertyEquals = query.getPropertyEqualsConstraints()) != null) {
            int i = 0;
            while (i < propertyEquals.length) {
                IProperty prop = propertyEquals[i];
                String qualifiedName = prop.getQualifiedName();
                String nsuri = PropertyUtil.getNamespaceURI(qualifiedName);
                this.report.addPropertyEqualsQuery(qualifiedName, prop.getValue(), nsuri);
                ++i;
            }
        }
        if (query.getApplyToPropagations()) {
            this.report.applyToPropagations();
        }
        if (query.getApplyToPropagationsOnly()) {
            this.report.applyToPropagationsOnly();
        }
        if (query.getApplyToActivitiesContainingFiles()) {
            this.report.applyToActivitiesContainingFiles();
        }
        if (query.getApplyToActivitiesWithoutPropagationRequestId()) {
            this.report.applyToActivitiesWithoutPropagationRequestId();
        }
    }

    public IVersionSetHolder selectVersionSet(IActivityQuery query, ActivityCompositeDef resultDef) throws VcmFailure {
        if (query == null || resultDef == null) {
            throw new NullPointerException();
        }
        this.definition = resultDef;
        this.createInitializedRequest(query);
        VersionSetLoader.ActivityVsetLoader resultLoader = new VersionSetLoader.ActivityVsetLoader(this.conTemplID, this.report);
        resultLoader.setCompositeDefinition(resultDef);
        return resultLoader.execute();
    }

    public IPropagationList[] selectPropagationLists(IActivityQuery query) throws VcmFailure {
        if (query == null) {
            throw new NullPointerException();
        }
        this.createInitializedRequest(query);
        PropagationListLoader pListLoader = new PropagationListLoader();
        return (IPropagationList[])pListLoader.loadResources(this.conTemplID);
    }

    private class PropagationListLoader
    extends AbstractResourceLoader {
        private PropagationListLoader() {
        }

        protected void addPropertyToLoad(String qualifiedName) {
            ActivityReportImpl.this.report.addSelectProperty(qualifiedName);
        }

        protected void addPropertyNS(String nsPrefix, String nsUri) {
            ActivityReportImpl.this.report.addNamespace(nsPrefix, nsUri);
        }

        protected ResourceMetaClass getResourceMetaClass() {
            return ResourceMetaClass.MC_PROPAGATION_LIST;
        }

        protected IRequest getRequest() {
            return ActivityReportImpl.this.report;
        }
    }

    private class ActivityLoader
    extends AbstractResourceLoader {
        private ActivityLoader() {
        }

        protected void addPropertyToLoad(String qualifiedName) {
            ActivityReportImpl.this.report.addSelectProperty(qualifiedName);
        }

        protected void addPropertyNS(String nsPrefix, String nsUri) {
            ActivityReportImpl.this.report.addNamespace(nsPrefix, nsUri);
        }

        protected ResourceMetaClass getResourceMetaClass() {
            return ResourceMetaClass.MC_ACTIVITY;
        }

        protected IRequest getRequest() {
            return ActivityReportImpl.this.report;
        }
    }
}

