/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.impl.ActivityIntersectionReportImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.ActivityIsnReportImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.ActivityReportImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.util.DateRange;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityIntersectionReport;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityQuery;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityReport;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityReportFactory;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivitySequenceNumReport;
import com.tssap.dtr.client.lib.deltavlib.xcm.IDateRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class ActivityReportFactoryImpl
implements IActivityReportFactory {
    private static final IActivityReportFactory instance = new ActivityReportFactoryImpl();

    private ActivityReportFactoryImpl() {
    }

    public static IActivityReportFactory getInstance() {
        return instance;
    }

    public IActivityQuery createQuery() {
        return new Query();
    }

    public IActivityReport createReport(int conTemplID, String requestPath) {
        return new ActivityReportImpl(conTemplID, requestPath);
    }

    public IActivitySequenceNumReport create(int conTemplID, String requestPath) {
        return new ActivityIsnReportImpl(conTemplID, requestPath);
    }

    public IActivityIntersectionReport createIntersectionReport(int conTemplID, String requestPath) {
        return new ActivityIntersectionReportImpl(conTemplID, requestPath);
    }

    static class Query
    implements IActivityQuery {
        private boolean closedOnly;
        private boolean openedOnly;
        private boolean emptyOnly;
        private boolean nonEmptyOnly;
        private IDateRange integrationDate;
        private IDateRange creationDate;
        private Integer integrationSeqNum;
        private Collection workspaceSet;
        private String user;
        private String namePrefix;
        private ArrayList propEquals;
        private boolean propagationsOnly;
        private boolean propagationsAlso;
        private boolean onlyActivitiesContainingFiles;
        private boolean noPropgationRequestID = false;

        Query() {
        }

        public boolean getClosedOnly() {
            return this.closedOnly;
        }

        public IDateRange getCreationDate() {
            return this.creationDate;
        }

        public IDateRange getIntegrationDate() {
            return this.integrationDate;
        }

        public Integer getIntegrationSeqNum() {
            return this.integrationSeqNum;
        }

        public String getNamePrefix() {
            return this.namePrefix;
        }

        public void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        public boolean getOpenedOnly() {
            return this.openedOnly;
        }

        public String getUser() {
            return this.user;
        }

        public String[] getWorkspaceSet() {
            if (this.workspaceSet != null) {
                return this.workspaceSet.toArray(new String[this.workspaceSet.size()]);
            }
            return null;
        }

        public void setClosedOnly(boolean closedOnly) {
            this.closedOnly = closedOnly;
        }

        public void setCreationDate(Date from, Date to) {
            this.creationDate = from == null && to == null ? null : new DateRange(from, to);
        }

        public void setIntegrationDate(Date from, Date to) {
            this.integrationDate = from == null && to == null ? null : new DateRange(from, to);
        }

        public void setIntegrationSeqNum(Integer sequenceNum) {
            this.integrationSeqNum = sequenceNum;
        }

        public void setOpenedOnly(boolean openedOnly) {
            this.openedOnly = openedOnly;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setWorkspace(String workspacePath) {
            if (workspacePath == null) {
                this.workspaceSet = null;
                return;
            }
            if (this.workspaceSet == null) {
                this.workspaceSet = new ArrayList();
            } else {
                this.workspaceSet.clear();
            }
            this.workspaceSet.add(workspacePath);
        }

        public void addWorkspace(String workspacePath) {
            if (workspacePath == null) {
                throw new NullPointerException();
            }
            if (this.workspaceSet == null) {
                this.workspaceSet = new ArrayList();
            }
            this.workspaceSet.add(workspacePath);
        }

        public boolean getSelectEmptyActivitiesOnly() {
            return this.emptyOnly;
        }

        public boolean getSelectNonEmptyActivitiesOnly() {
            return this.nonEmptyOnly;
        }

        public void setSelectEmptyActivitiesOnly() {
            this.emptyOnly = true;
            this.nonEmptyOnly = false;
        }

        public void setSelectNonEmptyActivitiesOnly() {
            this.emptyOnly = false;
            this.nonEmptyOnly = true;
        }

        public void addPropertyEqualsConstraint(IProperty property) {
            if (property == null) {
                throw new NullPointerException();
            }
            if (this.propEquals == null) {
                this.propEquals = new ArrayList();
            }
            this.propEquals.add(property);
        }

        public IProperty[] getPropertyEqualsConstraints() {
            if (this.propEquals != null) {
                return this.propEquals.toArray(new IProperty[this.propEquals.size()]);
            }
            return null;
        }

        public void applyToPropagationsOnly(boolean propagationsOnly) {
            this.propagationsOnly = propagationsOnly;
        }

        public void applyToPropagations(boolean propagations) {
            this.propagationsAlso = propagations;
        }

        public boolean getApplyToPropagationsOnly() {
            return this.propagationsOnly;
        }

        public boolean getApplyToPropagations() {
            return this.propagationsAlso;
        }

        public void applyToActivitiesContainingFiles(boolean apply) {
            this.onlyActivitiesContainingFiles = apply;
        }

        public boolean getApplyToActivitiesContainingFiles() {
            return this.onlyActivitiesContainingFiles;
        }

        public void applyToActivitiesWithoutPropagationRequestId(boolean apply) {
            this.noPropgationRequestID = apply;
        }

        public boolean getApplyToActivitiesWithoutPropagationRequestId() {
            return this.noPropgationRequestID;
        }
    }
}

