/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.ICollection;
import com.tssap.dtr.client.lib.deltavlib.IFile;
import com.tssap.dtr.client.lib.deltavlib.IVersionControlledResource;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.PathEncodingFlag;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.BaseResource;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.ResourceMetaClass;
import com.tssap.dtr.client.lib.deltavlib.impl.util.DataUtil;
import com.tssap.dtr.client.lib.deltavlib.impl.util.PropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyNameIterator;
import com.tssap.dtr.client.lib.deltavlib.properties.PropertyUtil;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityIsnMapping;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivitySequenceNumReport;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.xcm.IntegrationReport;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.Iterator;

public class ActivityIsnReportImpl
implements IActivitySequenceNumReport {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$impl$ActivityIsnReportImpl == null ? (class$com$tssap$dtr$client$lib$deltavlib$impl$ActivityIsnReportImpl = ActivityIsnReportImpl.class$("com.tssap.dtr.client.lib.deltavlib.impl.ActivityIsnReportImpl")) : class$com$tssap$dtr$client$lib$deltavlib$impl$ActivityIsnReportImpl));
    private int conTemplID;
    private String requestURI;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$impl$ActivityIsnReportImpl;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$IActivity;

    private IActivityIsnMapping[] execute(IntegrationReport report) throws VcmFailure {
        MultiStatusEntity entity;
        IResponse response = DeltavCommand.execute(this.conTemplID, (IRequest)report);
        MultiStatusEntity multiStatusEntity = entity = response.getStatus() == 207 ? (MultiStatusEntity)response.getEntity() : null;
        if (entity == null) {
            return new IActivityIsnMapping[0];
        }
        IActivityIsnMapping[] resultMapping = new IActivityIsnMapping[entity.countResources()];
        ResourceMetaClass activityMetaClass = ResourceMetaClass.getMetaClass(class$com$tssap$dtr$client$lib$deltavlib$IActivity == null ? (class$com$tssap$dtr$client$lib$deltavlib$IActivity = ActivityIsnReportImpl.class$("com.tssap.dtr.client.lib.deltavlib.IActivity")) : class$com$tssap$dtr$client$lib$deltavlib$IActivity);
        Iterator resourceIt = entity.getResources();
        try {
            ResourceElement nextResource = null;
            Mapping nextMapping = null;
            IntegrationResource integResource = null;
            int i = 0;
            while (resourceIt.hasNext()) {
                nextResource = (ResourceElement)resourceIt.next();
                Iterator propertyIt = nextResource.getProperties();
                integResource = new IntegrationResource(this.conTemplID, nextResource.getPath());
                if (propertyIt != null) {
                    integResource.initializePropertyCache(propertyIt);
                }
                nextMapping = new Mapping();
                nextMapping.activity = integResource.getActivity();
                nextMapping.isn = integResource.getISN();
                ++i;
            }
        }
        catch (InvalidPathException e) {
            LOC.errorT("received invalid resource url");
            throw new VcmFailure("client internal error", e);
        }
        return resultMapping;
    }

    ActivityIsnReportImpl(int conTemplID, String requestPath) {
        if (requestPath == null) {
            throw new NullPointerException("null report request-uri");
        }
        this.conTemplID = conTemplID;
        this.requestURI = Encoder.encodePath((String)requestPath);
    }

    void addPropertyToSelect(IntegrationReport report, String propertyName) {
        String prefix = PropertyUtil.getNamespacePrefix(propertyName);
        if (prefix != null) {
            report.addNamespace(prefix, PropertyUtil.getNamespaceURI(propertyName));
        }
    }

    public IActivityIsnMapping[] selectMappings(IWorkspace workspace, IActivity[] activitySet) throws VcmFailure {
        if (workspace == null) {
            throw new NullPointerException("null workspace");
        }
        DataUtil.checkArrayForNull(activitySet);
        IntegrationReport report = new IntegrationReport(this.requestURI, workspace.getEncodedPath());
        int i = 0;
        while (i < activitySet.length) {
            report.addActivityQuery(activitySet[i].getEncodedPath());
            ++i;
        }
        int i2 = 0;
        while (i2 < IntegrationResource.DEFAULT_PROPNAMES.length) {
            this.addPropertyToSelect(report, IntegrationResource.DEFAULT_PROPNAMES[i2]);
            ++i2;
        }
        return this.execute(report);
    }

    public IActivityIsnMapping[] selectMappings(IWorkspace workspace, String[] isnSet) throws VcmFailure {
        DataUtil.checkArrayForNull(isnSet);
        IntegrationReport report = new IntegrationReport(this.requestURI, workspace.getEncodedPath());
        int i = 0;
        while (i < isnSet.length) {
            try {
                report.addSequenceNumberQuery(Integer.parseInt(isnSet[i]));
            }
            catch (NumberFormatException e) {
                LOC.errorT("invalid integration-sequence-num type");
                throw new VcmFailure("client internal error", e);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < IntegrationResource.DEFAULT_PROPNAMES.length) {
            this.addPropertyToSelect(report, IntegrationResource.DEFAULT_PROPNAMES[i2]);
            ++i2;
        }
        return this.execute(report);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Mapping
    implements IActivityIsnMapping {
        IActivity activity;
        String isn;

        private Mapping() {
        }

        public IActivity getActivity() {
            return this.activity;
        }

        public String getIsn() {
            return this.isn;
        }
    }

    private static class IntegrationResource
    extends BaseResource {
        static final String[] DEFAULT_PROPNAMES = new String[]{XCM.ACTIVITY.qualifiedName, XCM.ISN.qualifiedName, DAV.WORKSPACE.qualifiedName};

        IntegrationResource(int connectionTemplID, String encResourcePath) throws InvalidPathException {
            super(connectionTemplID, encResourcePath);
        }

        public IActivity getActivity() throws VcmFailure {
            String hrefValue = this.getPropertyHrefValue(XCM.ACTIVITY.qualifiedName);
            return this.getResourceFactoryManager().getProxyFactory().createActivity(this.getConnectionTemplID(), hrefValue, PathEncodingFlag.ENCODED);
        }

        public IWorkspace getWorkspace() throws VcmFailure {
            String hrefValue = this.getPropertyHrefValue(DAV.WORKSPACE.qualifiedName);
            return this.getResourceFactoryManager().getProxyFactory().createWorkspace(this.getConnectionTemplID(), hrefValue, PathEncodingFlag.ENCODED);
        }

        public String getISN() throws VcmFailure {
            return this.getPropertyStringValue(XCM.ISN.qualifiedName);
        }

        public ICollection getAsCollection() throws VcmFailure {
            return null;
        }

        public boolean isCollection() throws VcmFailure {
            return false;
        }

        public IFile getAsFile() throws VcmFailure {
            return null;
        }

        public boolean isFile() throws VcmFailure {
            return false;
        }

        public IVersionControlledResource getAsVersionControlled() throws VcmFailure {
            return null;
        }

        public boolean isVersionControlled() throws VcmFailure {
            return false;
        }

        protected IPropertyNameIterator getInitialPropertyNames() {
            return new PropertyNameIterator(DEFAULT_PROPNAMES);
        }
    }
}

