/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.deltavlib.IActivity;
import com.tssap.dtr.client.lib.deltavlib.IWorkspace;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.ResourceMetaClass;
import com.tssap.dtr.client.lib.deltavlib.impl.util.DataUtil;
import com.tssap.dtr.client.lib.deltavlib.xcm.IActivityIntersectionReport;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.xcm.ActivityIntersectionReport;
import java.util.Iterator;

public class ActivityIntersectionReportImpl
implements IActivityIntersectionReport {
    private static final Location LOC = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$deltavlib$impl$ActivityIntersectionReportImpl == null ? (class$com$tssap$dtr$client$lib$deltavlib$impl$ActivityIntersectionReportImpl = ActivityIntersectionReportImpl.class$("com.tssap.dtr.client.lib.deltavlib.impl.ActivityIntersectionReportImpl")) : class$com$tssap$dtr$client$lib$deltavlib$impl$ActivityIntersectionReportImpl));
    private static final int METHOD_PROPAGATION = 1;
    private static final int METHOD_INTEGRATION = 2;
    private int conTemplID;
    private String requestURI;
    private int maxLevel = 5;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$impl$ActivityIntersectionReportImpl;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$deltavlib$IActivity;

    private IActivity[] execute(ActivityIntersectionReport report) throws VcmFailure {
        IResponse response = DeltavCommand.execute(this.conTemplID, (IRequest)report);
        Object entity = null;
        IActivity[] result = new IActivity[entity.countResources()];
        if (result.length == 0) {
            return result;
        }
        ResourceMetaClass activityMetaClass = ResourceMetaClass.getMetaClass(class$com$tssap$dtr$client$lib$deltavlib$IActivity == null ? (class$com$tssap$dtr$client$lib$deltavlib$IActivity = ActivityIntersectionReportImpl.class$("com.tssap.dtr.client.lib.deltavlib.IActivity")) : class$com$tssap$dtr$client$lib$deltavlib$IActivity);
        Iterator resourceIt = entity.getResources();
        try {
            int i = 0;
            while (resourceIt.hasNext()) {
                ResourceElement nextResource = (ResourceElement)resourceIt.next();
                result[i] = (IActivity)((Object)activityMetaClass.newInstance(this.conTemplID, nextResource.getPath()));
                ++i;
            }
        }
        catch (InvalidPathException e) {
            LOC.errorT("received invalid resource url");
            throw new VcmFailure("client internal error", e);
        }
        return result;
    }

    private void setActivities(ActivityIntersectionReport report, IActivity[] activitySet) {
        String[] hrefs = DataUtil.getAsHrefs(activitySet);
        int i = 0;
        while (i < hrefs.length) {
            report.addActivity(hrefs[i]);
            ++i;
        }
    }

    ActivityIntersectionReportImpl(int conTemplID, String requestURI) {
        if (requestURI == null) {
            throw new NullPointerException("null report request-uri");
        }
        this.conTemplID = conTemplID;
        this.requestURI = requestURI;
    }

    public IActivity[] selectForIntegration(IWorkspace sourceWorkspace, IWorkspace targetWorkspace, IActivity[] activitySet) throws VcmFailure {
        ActivityIntersectionReport report = new ActivityIntersectionReport(this.requestURI);
        report.applyToIntegration(sourceWorkspace.getEncodedPath(), targetWorkspace.getEncodedPath());
        this.setActivities(report, activitySet);
        return this.execute(report);
    }

    public IActivity[] selectForPropagation(IWorkspace workspace, IActivity[] activitySet) throws VcmFailure {
        ActivityIntersectionReport report = new ActivityIntersectionReport(this.requestURI);
        report.applyToPropagation(workspace.getEncodedPath());
        this.setActivities(report, activitySet);
        return this.execute(report);
    }

    public void setMaxLevel(int level) {
        this.maxLevel = level;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

