/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.deltavlib.impl;

import com.tssap.dtr.client.lib.deltavlib.ICheckedOutResource;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.FileImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.IActivityContentMember;
import com.tssap.dtr.client.lib.deltavlib.impl.InvalidPathException;
import com.tssap.dtr.client.lib.deltavlib.impl.VersionImpl;
import com.tssap.dtr.client.lib.deltavlib.impl.WorkingResourceImpl;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IPropertyCacheControl;
import com.tssap.dtr.client.lib.deltavlib.xcm.IClosedResource;
import com.tssap.dtr.client.lib.deltavlib.xcm.ICreatedResource;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;

public class ActivityContentMemberImpl
extends FileImpl
implements IActivityContentMember {
    ActivityContentMemberImpl(int conTemplID, String encodedPath) throws InvalidPathException {
        super(conTemplID, encodedPath);
    }

    ActivityContentMemberImpl(FileImpl resource) {
        super(resource);
    }

    public boolean isCreatedMember() throws VcmFailure {
        return !this.isVersion() && !this.isWorkingResource();
    }

    public boolean isCheckedOutMember() throws VcmFailure {
        return this.isWorkingResource();
    }

    public ICheckedOutResource getMemberAsCheckedOut() throws VcmFailure {
        return new WorkingResourceImpl(this);
    }

    public ICreatedResource getMemberAsCreated() throws VcmFailure {
        return new WorkingResourceImpl(this);
    }

    public IClosedResource getMemberAsClosed() throws VcmFailure {
        return new VersionImpl(this);
    }

    protected boolean isWorkingResource() throws VcmFailure {
        boolean isWorkingResource = false;
        IPropertyCacheControl cacheControl = this.getPropertyCacheControl();
        if (this.isPropertyInitialized(DAV.RESOURCETYPE.qualifiedName)) {
            isWorkingResource = this.testFLAG(64);
        } else if (this.isPropertyInitialized(DAV.AUTO_UPDATE.qualifiedName)) {
            isWorkingResource = true;
        } else {
            cacheControl.addPropertyToCache(DAV.RESOURCETYPE.qualifiedName);
            this.refresh();
            isWorkingResource = this.testFLAG(64);
        }
        return isWorkingResource;
    }

    private boolean isVersion() throws VcmFailure {
        IProperty resourceType = this.getProperty(XCM.RESOURCE_TYPE.qualifiedName);
        return resourceType != null && resourceType.getValue().equalsIgnoreCase("VERSION");
    }

    public boolean isClosedMember() throws VcmFailure {
        return this.isVersion();
    }
}

